/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRemoveCommand {
    private final Project myProject;

    public HgRemoveCommand(Project project) {
        this.myProject = project;
    }

    public void execute(HgFile ... hgFiles) {
        if (hgFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFiles", "org/zmlx/hg4idea/command/HgRemoveCommand", "execute"));
        }
        this.execute(Arrays.asList(hgFiles));
    }

    public void execute(@NotNull Collection<HgFile> hgFiles) {
        if (hgFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFiles", "org/zmlx/hg4idea/command/HgRemoveCommand", "execute"));
        }
        for (Map.Entry<VirtualFile, List<String>> entry : HgUtil.getRelativePathsByRepository(hgFiles).entrySet()) {
            List<String> filePaths = entry.getValue();
            for (List chunkFiles : VcsFileUtil.chunkRelativePaths(filePaths)) {
                LinkedList<String> parameters = new LinkedList<String>();
                parameters.addAll(chunkFiles);
                parameters.add(0, "--after");
                new HgCommandExecutor(this.myProject).executeInCurrentThread(entry.getKey(), "remove", parameters);
            }
        }
    }
}

