/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class TypesUtil {
    @NonNls
    public static final Map<String, PsiType> ourQNameToUnboxed = new HashMap();
    public static final PsiPrimitiveType[] PRIMITIVES = new PsiPrimitiveType[]{PsiType.BYTE, PsiType.CHAR, PsiType.DOUBLE, PsiType.FLOAT, PsiType.INT, PsiType.SHORT, PsiType.LONG, PsiType.BOOLEAN, PsiType.VOID};
    private static final Map<IElementType, String> ourPrimitiveTypesToClassNames = new HashMap();
    private static final String NULL = "null";
    private static final Map<IElementType, String> ourOperationsToOperatorNames;
    private static final Map<IElementType, String> ourUnaryOperationsToOperatorNames;
    private static final TObjectIntHashMap<String> TYPE_TO_RANK;
    private static final TIntObjectHashMap<String> RANK_TO_TYPE;

    private TypesUtil() {
    }

    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        GroovyResolveResult[] groovyResolveResultArray = TypesUtil.getOverloadedOperatorCandidates(thisType, tokenType, place, argumentTypes, false);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        return groovyResolveResultArray;
    }

    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes, boolean incompleteCode) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.getMethodCandidates(thisType, ourOperationsToOperatorNames.get(tokenType), (PsiElement)place, true, incompleteCode, false, argumentTypes);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedOperatorCandidates"));
        }
        return groovyResolveResultArray;
    }

    public static GroovyResolveResult[] getOverloadedUnaryOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes) {
        if (thisType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedUnaryOperatorCandidates"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getOverloadedUnaryOperatorCandidates"));
        }
        return ResolveUtil.getMethodCandidates(thisType, ourUnaryOperationsToOperatorNames.get(tokenType), (PsiElement)place, argumentTypes);
    }

    public static boolean isAssignable(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        GlobalSearchScope scope;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignable"));
        }
        if (lType == null || rType == null) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType child : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!TypesUtil.isAssignable(lType, child, context)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType child : ((PsiIntersectionType)lType).getConjuncts()) {
                if (TypesUtil.isAssignable(child, rType, context)) continue;
                return false;
            }
            return true;
        }
        if (TypesUtil.isAssignableWithoutConversions(lType, rType, context)) {
            return true;
        }
        Boolean byConversionInMethodCall = TypesUtil.isAssignableByConversion(lType, rType, context, true);
        if (byConversionInMethodCall != null) {
            return byConversionInMethodCall;
        }
        if (lType instanceof PsiPrimitiveType && rType == PsiType.NULL) {
            return false;
        }
        PsiManager manager = context.getManager();
        if ((lType = TypesUtil.boxPrimitiveType(lType, manager, scope = context.getResolveScope())).isAssignableFrom(rType = TypesUtil.boxPrimitiveType(rType, manager, scope))) {
            return true;
        }
        Boolean byConversion = TypesUtil.isAssignableByConversion(lType, rType, context, false);
        if (byConversion != null) {
            return byConversion;
        }
        return false;
    }

    public static boolean isAssignableByMethodCallConversion(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableByMethodCallConversion"));
        }
        if (lType == null || rType == null) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType child : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!TypesUtil.isAssignableByMethodCallConversion(lType, child, context)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType child : ((PsiIntersectionType)lType).getConjuncts()) {
                if (TypesUtil.isAssignableByMethodCallConversion(child, rType, context)) continue;
                return false;
            }
            return true;
        }
        if (TypesUtil.isAssignableWithoutConversions(lType, rType, context)) {
            return true;
        }
        Boolean byConversion = TypesUtil.isAssignableByConversion(lType, rType, context, true);
        if (byConversion != null) {
            return byConversion;
        }
        return false;
    }

    @Nullable
    private static Boolean isAssignableByConversion(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull PsiElement context, boolean inMethodCall) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableByConversion"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableByConversion"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableByConversion"));
        }
        if (context instanceof GroovyPsiElement) {
            for (GrTypeConverter converter : (GrTypeConverter[])GrTypeConverter.EP_NAME.getExtensions()) {
                Boolean result;
                if (inMethodCall != converter.isAllowedInMethodCall() || (result = converter.isConvertible(lType, rType, (GroovyPsiElement)context)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static boolean isAssignableWithoutConversions(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        Boolean result;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableWithoutConversions"));
        }
        if (lType == null || rType == null) {
            return false;
        }
        if (rType == PsiType.NULL) {
            return !(lType instanceof PsiPrimitiveType);
        }
        PsiManager manager = context.getManager();
        GlobalSearchScope scope = context.getResolveScope();
        if (rType instanceof GrTupleType && ((GrTupleType)rType).getComponentTypes().length == 0 && (lType instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiType)lType, (String)"java.util.Set"))) {
            return true;
        }
        if (rType instanceof GrTraitType) {
            if (TypesUtil.isAssignableWithoutConversions(lType, (PsiType)((GrTraitType)rType).getExprType(), context)) {
                return true;
            }
            for (PsiClassType trait : ((GrTraitType)rType).getTraitTypes()) {
                if (!TypesUtil.isAssignableWithoutConversions(lType, (PsiType)trait, context)) continue;
                return true;
            }
            return false;
        }
        if (TypesUtil.isClassType(rType, "groovy.lang.GString") && lType.equalsToText("java.lang.String")) {
            return true;
        }
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            if (TypesUtil.isClassType(lType = TypesUtil.unboxPrimitiveTypeWrapper(lType), "java.math.BigDecimal")) {
                lType = PsiType.DOUBLE;
            }
            if (TypesUtil.isClassType(rType = TypesUtil.unboxPrimitiveTypeWrapper(rType), "java.math.BigDecimal")) {
                rType = PsiType.DOUBLE;
            }
        } else {
            rType = TypesUtil.boxPrimitiveType(rType, manager, scope);
            lType = TypesUtil.boxPrimitiveType(lType, manager, scope);
        }
        if ((rType instanceof GrMapType || rType instanceof GrTupleType) && (result = TypesUtil.isAssignableForNativeTypes(lType, (PsiClassType)rType, context)) != null && result.booleanValue()) {
            return true;
        }
        if (rType instanceof GrClosureType && TypesUtil.canMakeClosureRaw(lType)) {
            rType = ((GrClosureType)rType).rawType();
        }
        return TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType);
    }

    private static boolean canMakeClosureRaw(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return true;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        if (parameters.length != 1) {
            return true;
        }
        PsiType parameter = parameters[0];
        return parameter instanceof PsiWildcardType;
    }

    @Nullable
    private static Boolean isAssignableForNativeTypes(@NotNull PsiType lType, @NotNull PsiClassType rType, @NotNull PsiElement context) {
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableForNativeTypes"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableForNativeTypes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAssignableForNativeTypes"));
        }
        if (!(lType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult leftResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rightResult = rType.resolveGenerics();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        if (rightClass == null || leftClass == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)rightClass, (PsiClass)leftClass, (boolean)true)) {
            return Boolean.FALSE;
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        if (!leftClass.hasTypeParameters()) {
            return Boolean.TRUE;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent((PsiElement)leftClass, (PsiElement)rightClass)) {
            rightSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)leftClass, (PsiClass)rightClass, (PsiSubstitutor)rightSubstitutor);
            rightClass = leftClass;
        } else if (!rightClass.hasTypeParameters()) {
            return Boolean.TRUE;
        }
        Iterator li = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)leftClass);
        Iterator ri = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)rightClass);
        while (li.hasNext()) {
            if (!ri.hasNext()) {
                return Boolean.FALSE;
            }
            PsiTypeParameter lp = (PsiTypeParameter)li.next();
            PsiTypeParameter rp = (PsiTypeParameter)ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType typeRight = rightSubstitutor.substituteWithBoundsPromotion(rp);
            if (typeRight == null) {
                return Boolean.TRUE;
            }
            if (TypesUtil.isAssignableWithoutConversions(typeLeft, typeRight, context)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isNumericType(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            return TYPE_TO_RANK.contains((Object)TypesUtil.getQualifiedName(type));
        }
        return type instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type);
    }

    public static PsiType unboxPrimitiveTypeWrapperAndEraseGenerics(PsiType result) {
        return TypeConversionUtil.erasure((PsiType)TypesUtil.unboxPrimitiveTypeWrapper(result));
    }

    public static PsiType unboxPrimitiveTypeWrapper(@Nullable PsiType type) {
        PsiType unboxed;
        PsiClass psiClass;
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && (unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName())) != null) {
            type = unboxed;
        }
        return type;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean boxVoid) {
        PsiPrimitiveType primitive;
        String boxedTypeName;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "boxPrimitiveType"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "boxPrimitiveType"));
        }
        if (result instanceof PsiPrimitiveType && (boxVoid || result != PsiType.VOID) && (boxedTypeName = (primitive = (PsiPrimitiveType)result).getBoxedTypeName()) != null) {
            return GroovyPsiManager.getInstance(manager.getProject()).createTypeByFQClassName(boxedTypeName, resolveScope);
        }
        return result;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "boxPrimitiveType"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "boxPrimitiveType"));
        }
        return TypesUtil.boxPrimitiveType(result, manager, resolveScope, false);
    }

    @NotNull
    public static PsiClassType createType(String fqName, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createType"));
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName(fqName, context);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createType"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getJavaLangObject"));
        }
        PsiClassType psiClassType = LazyFqnClassType.getLazyType("java.lang.Object", context);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getJavaLangObject"));
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@Nullable PsiType type1, @Nullable PsiType type2, @NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBoundNullable"));
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return TypesUtil.getLeastUpperBound(type1, type2, manager);
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@NotNull Iterable<PsiType> collection, @NotNull PsiManager manager) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBoundNullable"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBoundNullable"));
        }
        Iterator<PsiType> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        PsiType result = iterator.next();
        while (iterator.hasNext()) {
            result = TypesUtil.getLeastUpperBoundNullable(result, iterator.next(), manager);
        }
        return result;
    }

    @Nullable
    public static PsiType getLeastUpperBound(@NotNull PsiType type1, @NotNull PsiType type2, PsiManager manager) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBound"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBound"));
        }
        if (type1 instanceof GrTupleType && type2 instanceof GrTupleType) {
            GrTupleType tuple1 = (GrTupleType)type1;
            GrTupleType tuple2 = (GrTupleType)type2;
            PsiType[] components1 = tuple1.getComponentTypes();
            PsiType[] components2 = tuple2.getComponentTypes();
            if (components1.length == 0) {
                return TypesUtil.genNewListBy(type2, manager);
            }
            if (components2.length == 0) {
                return TypesUtil.genNewListBy(type1, manager);
            }
            PsiType[] components3 = PsiType.createArray((int)Math.min(components1.length, components2.length));
            for (int i = 0; i < components3.length; ++i) {
                PsiType c1 = components1[i];
                PsiType c2 = components2[i];
                components3[i] = c1 == null || c2 == null ? null : TypesUtil.getLeastUpperBound(c1, c2, manager);
            }
            return new GrImmediateTupleType(components3, JavaPsiFacade.getInstance((Project)manager.getProject()), tuple1.getScope().intersectWith(tuple2.getResolveScope()));
        }
        if (TypesUtil.checkEmptyListAndList(type1, type2)) {
            return TypesUtil.genNewListBy(type2, manager);
        }
        if (TypesUtil.checkEmptyListAndList(type2, type1)) {
            return TypesUtil.genNewListBy(type1, manager);
        }
        if (type1 instanceof GrMapType && type2 instanceof GrMapType) {
            return GrMapType.merge((GrMapType)type1, (GrMapType)type2);
        }
        if (TypesUtil.checkEmptyMapAndMap(type1, type2)) {
            return TypesUtil.genNewMapBy(type2, manager);
        }
        if (TypesUtil.checkEmptyMapAndMap(type2, type1)) {
            return TypesUtil.genNewMapBy(type1, manager);
        }
        if (type1 instanceof GrClosureType && type2 instanceof GrClosureType) {
            GrClosureSignature signature;
            GrClosureType clType1 = (GrClosureType)type1;
            GrClosureType clType2 = (GrClosureType)type2;
            GrSignature signature1 = clType1.getSignature();
            GrSignature signature2 = clType2.getSignature();
            if (signature1 instanceof GrClosureSignature && signature2 instanceof GrClosureSignature && ((GrClosureSignature)signature1).getParameterCount() == ((GrClosureSignature)signature2).getParameterCount() && (signature = GrImmediateClosureSignatureImpl.getLeastUpperBound((GrClosureSignature)signature1, (GrClosureSignature)signature2, manager)) != null) {
                GlobalSearchScope scope = clType1.getResolveScope().intersectWith(clType2.getResolveScope());
                LanguageLevel languageLevel = (LanguageLevel)ComparatorUtil.max((Comparable)clType1.getLanguageLevel(), (Comparable)clType2.getLanguageLevel());
                return GrClosureType.create(signature, scope, JavaPsiFacade.getInstance((Project)manager.getProject()), languageLevel, true);
            }
        } else {
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type1)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type2))) {
                return type2;
            }
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type2)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type1))) {
                return type1;
            }
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager);
    }

    private static boolean checkEmptyListAndList(PsiType type1, PsiType type2) {
        PsiType[] types;
        return type1 instanceof GrTupleType && (types = ((GrTupleType)type1).getComponentTypes()).length == 0 && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List");
    }

    private static PsiType genNewListBy(PsiType genericOwner, PsiManager manager) {
        PsiClass list = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (list == null) {
            return factory.createTypeFromText("java.util.List", null);
        }
        return factory.createType(list, PsiUtil.extractIterableTypeParameter((PsiType)genericOwner, (boolean)false));
    }

    private static boolean checkEmptyMapAndMap(PsiType type1, PsiType type2) {
        return type1 instanceof GrMapType && ((GrMapType)type1).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    private static PsiType genNewMapBy(PsiType genericOwner, PsiManager manager) {
        PsiClass map = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (map == null) {
            return factory.createTypeFromText("java.util.Map", null);
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)1, (boolean)false);
        return factory.createType(map, new PsiType[]{key, value});
    }

    @Nullable
    public static PsiType getPsiType(PsiElement context, IElementType elemType) {
        if (elemType == GroovyTokenTypes.kNULL) {
            return PsiType.NULL;
        }
        String typeName = TypesUtil.getBoxedTypeName(elemType);
        if (typeName != null) {
            return TypesUtil.createTypeByFQClassName(typeName, context);
        }
        return null;
    }

    @Nullable
    public static String getBoxedTypeName(IElementType elemType) {
        return ourPrimitiveTypesToClassNames.get(elemType);
    }

    @NotNull
    public static PsiType getLeastUpperBound(PsiClass[] classes, PsiManager manager) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (classes.length == 0) {
            PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.Object");
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBound"));
            }
            return psiClassType;
        }
        PsiClassType type = factory.createType(classes[0]);
        for (int i = 1; i < classes.length; ++i) {
            PsiType t = TypesUtil.getLeastUpperBound((PsiType)type, (PsiType)factory.createType(classes[i]), manager);
            if (t == null) continue;
            type = t;
        }
        PsiClassType psiClassType = type;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getLeastUpperBound"));
        }
        return psiClassType;
    }

    public static boolean isClassType(@Nullable PsiType type, @NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isClassType"));
        }
        return qName.equals(TypesUtil.getQualifiedName(type));
    }

    public static PsiSubstitutor composeSubstitutors(PsiSubstitutor s1, PsiSubstitutor s2) {
        Map map = s1.getSubstitutionMap();
        THashMap result = new THashMap(map.size());
        for (PsiTypeParameter parameter : map.keySet()) {
            result.put(parameter, s2.substitute((PsiType)map.get(parameter)));
        }
        Map map2 = s2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map2.keySet()) {
            if (result.containsKey(parameter)) continue;
            result.put(parameter, map2.get(parameter));
        }
        return PsiSubstitutorImpl.createSubstitutor((Map)result);
    }

    @NotNull
    public static PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createTypeByFQClassName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createTypeByFQClassName"));
        }
        PsiClassType psiClassType = GroovyPsiManager.getInstance(context.getProject()).createTypeByFQClassName(fqName, context.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createTypeByFQClassName"));
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type, Project project, GlobalSearchScope resolveScope) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClassType result = null;
        PsiClass javaLangClass = facade.findClass("java.lang.Class", resolveScope);
        if (javaLangClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], type);
            }
            result = facade.getElementFactory().createType(javaLangClass, substitutor);
        }
        return result;
    }

    @NotNull
    public static PsiPrimitiveType getPrimitiveTypeByText(String typeText) {
        for (PsiPrimitiveType primitive : PRIMITIVES) {
            if (PsiType.VOID.equals((Object)primitive)) {
                PsiPrimitiveType psiPrimitiveType = primitive;
                if (psiPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getPrimitiveTypeByText"));
                }
                return psiPrimitiveType;
            }
            if (!primitive.getCanonicalText().equals(typeText)) continue;
            PsiPrimitiveType psiPrimitiveType = primitive;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getPrimitiveTypeByText"));
            }
            return psiPrimitiveType;
        }
        assert (false) : "Unknown primitive type";
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "getPrimitiveTypeByText"));
        }
        return null;
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiClass elements) {
        GlobalSearchScope resolveScope;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createListType"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)elements.getProject());
        PsiClass listClass = facade.findClass("java.util.List", resolveScope = elements.getResolveScope());
        if (listClass == null) {
            PsiClassType psiClassType = facade.getElementFactory().createTypeByFQClassName("java.util.List", resolveScope);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createListType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = facade.getElementFactory().createType(listClass, (PsiType)facade.getElementFactory().createType(elements));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createListType"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiType createSetType(@NotNull PsiElement context, @NotNull PsiType type) {
        GlobalSearchScope resolveScope;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createSetType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createSetType"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiClass setClass = facade.findClass("java.util.Set", resolveScope = context.getResolveScope());
        if (setClass != null && setClass.getTypeParameters().length == 1) {
            PsiClassType psiClassType = facade.getElementFactory().createType(setClass, type);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createSetType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = facade.getElementFactory().createTypeByFQClassName("java.util.Set", resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "createSetType"));
        }
        return psiClassType;
    }

    public static boolean isAnnotatedCheckHierarchyWithCache(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAnnotatedCheckHierarchyWithCache"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "isAnnotatedCheckHierarchyWithCache"));
        }
        Map<String, PsiClass> classMap = ClassUtil.getSuperClassesWithCache(aClass);
        for (PsiClass psiClass : classMap.values()) {
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList == null || modifierList.findAnnotation(annotationFQN) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType substituteBoxAndNormalizeType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor, @Nullable SpreadState state, @NotNull GrExpression expression) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "substituteBoxAndNormalizeType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil", "substituteBoxAndNormalizeType"));
        }
        if (type == null) {
            return null;
        }
        GlobalSearchScope resolveScope = expression.getResolveScope();
        PsiManager manager = expression.getManager();
        type = substitutor.substitute(type);
        if ((type = TypesUtil.boxPrimitiveType(type, manager, resolveScope)) == null) {
            return null;
        }
        type = PsiImplUtil.normalizeWildcardTypeByPosition(type, expression);
        type = SpreadState.apply(type, state, expression.getProject());
        return type;
    }

    @Nullable
    public static PsiType getItemType(@Nullable PsiType containerType) {
        if (containerType == null) {
            return null;
        }
        if (containerType instanceof PsiArrayType) {
            return ((PsiArrayType)containerType).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)containerType, (boolean)false);
    }

    @Nullable
    public static PsiType inferAnnotationMemberValueType(GrAnnotationMemberValue value) {
        if (value instanceof GrExpression) {
            return ((GrExpression)value).getType();
        }
        if (value instanceof GrAnnotation) {
            PsiElement resolved = ((GrAnnotation)value).getClassReference().resolve();
            if (resolved instanceof PsiClass) {
                return JavaPsiFacade.getElementFactory((Project)value.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
            }
            return null;
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            return TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value);
        }
        return null;
    }

    public static PsiType getTupleByAnnotationArrayInitializer(final GrAnnotationArrayInitializer value) {
        return new GrTupleType(value.getResolveScope(), JavaPsiFacade.getInstance((Project)value.getProject())){

            @Override
            @NotNull
            protected PsiType[] inferComponents() {
                Object[] initializers = value.getInitializers();
                PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map((Object[])initializers, (Function)new Function<GrAnnotationMemberValue, PsiType>(){

                    public PsiType fun(GrAnnotationMemberValue value) {
                        return TypesUtil.inferAnnotationMemberValueType(value);
                    }
                }, (Object[])PsiType.createArray((int)initializers.length));
                if (psiTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil$1", "inferComponents"));
                }
                return psiTypeArray;
            }

            public boolean isValid() {
                return value.isValid();
            }
        };
    }

    public static boolean resolvesTo(PsiType type, String fqn) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            return resolved != null && fqn.equals(resolved.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType rawSecondGeneric(PsiType type, Project project) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
        PsiClass element = result.getElement();
        if (element == null) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        boolean changed = false;
        for (int i = 0; i < parameters.length; ++i) {
            PsiType parameter = parameters[i];
            if (parameter == null) continue;
            final Ref newParam = new Ref();
            parameter.accept((PsiTypeVisitor)new PsiTypeVisitorEx<Object>(){

                @Nullable
                public Object visitClassType(PsiClassType classType) {
                    if (classType.getParameterCount() > 0) {
                        newParam.set((Object)classType.rawType());
                    }
                    return null;
                }

                @Nullable
                public Object visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                    newParam.set((Object)capturedWildcardType.getWildcard().getBound());
                    return null;
                }

                @Nullable
                public Object visitWildcardType(PsiWildcardType wildcardType) {
                    newParam.set((Object)wildcardType.getBound());
                    return null;
                }
            });
            if (newParam.isNull()) continue;
            changed = true;
            parameters[i] = (PsiType)newParam.get();
        }
        if (!changed) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createType(element, parameters);
    }

    public static boolean isPsiClassTypeToClosure(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return false;
        }
        return "groovy.lang.Closure".equals(psiClass.getQualifiedName());
    }

    @Nullable
    public static String getQualifiedName(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            if (resolved instanceof PsiAnonymousClass) {
                return TypesUtil.getQualifiedName((PsiType)((PsiAnonymousClass)resolved).getBaseClassType());
            }
            if (resolved != null) {
                return resolved.getQualifiedName();
            }
            return PsiNameHelper.getQualifiedClassName((String)type.getCanonicalText(), (boolean)true);
        }
        return null;
    }

    static {
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mGSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mREGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_INT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_LONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_FLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_DOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_INT, "java.math.BigInteger");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_DECIMAL, "java.math.BigDecimal");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFALSE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kTRUE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kNULL, NULL);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kINT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kLONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kDOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBOOLEAN, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kCHAR, "java.lang.Character");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBYTE, "java.lang.Byte");
        ourOperationsToOperatorNames = new HashMap();
        ourUnaryOperationsToOperatorNames = new HashMap();
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "plus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "minus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBAND, "and");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBOR, "or");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBXOR, "xor");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mDIV, "div");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMOD, "mod");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mSTAR, "multiply");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.kAS, "asType");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mCOMPARE_TO, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mGT, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mGE, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mLT, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mLE, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mSTAR_STAR, "power");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, "leftShift");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, "rightShift");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, "rightShiftUnsigned");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mEQUAL, "equals");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mNOT_EQUAL, "equals");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mLNOT, "asBoolean");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "positive");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "negative");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mDEC, "previous");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mINC, "next");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mBNOT, "bitwiseNegate");
        TYPE_TO_RANK = new TObjectIntHashMap();
        TYPE_TO_RANK.put((Object)"java.lang.Byte", 1);
        TYPE_TO_RANK.put((Object)"java.lang.Short", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Character", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Integer", 3);
        TYPE_TO_RANK.put((Object)"java.lang.Long", 4);
        TYPE_TO_RANK.put((Object)"java.math.BigInteger", 5);
        TYPE_TO_RANK.put((Object)"java.math.BigDecimal", 6);
        TYPE_TO_RANK.put((Object)"java.lang.Float", 7);
        TYPE_TO_RANK.put((Object)"java.lang.Double", 8);
        TYPE_TO_RANK.put((Object)"java.lang.Number", 9);
        ourQNameToUnboxed.put("java.lang.Boolean", (PsiType)PsiType.BOOLEAN);
        ourQNameToUnboxed.put("java.lang.Byte", (PsiType)PsiType.BYTE);
        ourQNameToUnboxed.put("java.lang.Character", (PsiType)PsiType.CHAR);
        ourQNameToUnboxed.put("java.lang.Short", (PsiType)PsiType.SHORT);
        ourQNameToUnboxed.put("java.lang.Integer", (PsiType)PsiType.INT);
        ourQNameToUnboxed.put("java.lang.Long", (PsiType)PsiType.LONG);
        ourQNameToUnboxed.put("java.lang.Float", (PsiType)PsiType.FLOAT);
        ourQNameToUnboxed.put("java.lang.Double", (PsiType)PsiType.DOUBLE);
        RANK_TO_TYPE = new TIntObjectHashMap();
        RANK_TO_TYPE.put(1, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(2, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(3, (Object)"java.lang.Integer");
        RANK_TO_TYPE.put(4, (Object)"java.lang.Long");
        RANK_TO_TYPE.put(5, (Object)"java.math.BigInteger");
        RANK_TO_TYPE.put(6, (Object)"java.math.BigDecimal");
        RANK_TO_TYPE.put(7, (Object)"java.lang.Double");
        RANK_TO_TYPE.put(8, (Object)"java.lang.Double");
        RANK_TO_TYPE.put(9, (Object)"java.lang.Number");
    }
}

