/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;

public abstract class ParameterTablePanel
extends JPanel {
    private ParameterInfo[] myParameterInfos;
    private TypeSelector[] myParameterTypeSelectors;
    private JBTable myTable;
    private MyTableModel myTableModel;
    private JComboBox myTypeRendererCombo;

    public ParameterTablePanel() {
        super(new BorderLayout());
    }

    public void init(ExtractInfoHelper helper) {
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GroovyRefactoringBundle.message("parameters.border.title", new Object[0]), (boolean)false));
        this.myParameterInfos = helper.getParameterInfos();
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.setTableHeader(null);
        this.myTable.getSelectionModel().setSelectionMode(0);
        TableColumn checkBoxColumn = this.myTable.getColumnModel().getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setCellRenderer((TableCellRenderer)((Object)new CheckBoxTableCellRenderer()));
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ParameterInfo info = ParameterTablePanel.this.myParameterInfos[row];
                this.setText(info.getName());
                return this;
            }
        });
        Project project = helper.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        this.myParameterTypeSelectors = new TypeSelector[this.myParameterInfos.length];
        for (int i = 0; i < this.myParameterTypeSelectors.length; ++i) {
            PsiType type = this.myParameterInfos[i].getType();
            this.myParameterTypeSelectors[i] = new TypeSelector((PsiType)(type != null ? type : PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope)), project);
        }
        this.myTypeRendererCombo = new JComboBox<ParameterInfo>(this.myParameterInfos);
        this.myTypeRendererCombo.setOpaque(true);
        this.myTypeRendererCombo.setBorder(null);
        this.myTypeRendererCombo.setRenderer(new ListCellRendererWrapper<ParameterInfo>(){

            public void customize(JList list, ParameterInfo info, int index, boolean selected, boolean hasFocus) {
                PsiType type = info.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                type = unboxed != null ? unboxed : type;
                this.setText(type != null ? type.getPresentableText() : "");
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            TypeSelector myCurrentSelector;

            public Object getCellEditorValue() {
                return this.myCurrentSelector.getSelectedType();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myCurrentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
                return this.myCurrentSelector.getComponent();
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (ParameterTablePanel.this.myParameterTypeSelectors[row].getComponent() instanceof JComboBox) {
                    ParameterTablePanel.this.myTypeRendererCombo.setSelectedIndex(row);
                    return ParameterTablePanel.this.myTypeRendererCombo;
                }
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ParameterInfo info = ParameterTablePanel.this.myParameterInfos[row];
                PsiType type = info.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                type = unboxed != null ? unboxed : type;
                this.setText(type != null ? type.getPresentableText() : "");
                return this;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = ParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (ParameterTablePanel.this.myParameterInfos[row].passAsParameter()) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ParameterTablePanel.this.myParameterInfos[row].setPassAsParameter(valueToBeSet);
                    }
                    ParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)ParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit_parameter_name");
        actionMap.put("edit_parameter_name", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ParameterTablePanel.this.myTable.isEditing() && (row = ParameterTablePanel.this.myTable.getSelectedRow()) >= 0 && row < ParameterTablePanel.this.myTableModel.getRowCount()) {
                    TableUtil.editCellAt((JTable)ParameterTablePanel.this.myTable, (int)row, (int)2);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doEnterAction();
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction().createPanel();
        this.add((Component)listPanel, "Center");
    }

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    private class CheckBoxTableCellRenderer
    extends BooleanTableCellRenderer {
        private CheckBoxTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setEnabled(ParameterTablePanel.this.isEnabled());
            return rendererComponent;
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_TYPE_COLUMN = 1;
        public static final int PARAMETER_NAME_COLUMN = 2;

        private MyTableModel() {
        }

        public void addRow() {
            throw new IllegalAccessError("Not implemented");
        }

        public void removeRow(int index) {
            throw new IllegalAccessError("Not implemented");
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            if (oldIndex >= ParameterTablePanel.this.myParameterInfos.length || newIndex >= ParameterTablePanel.this.myParameterInfos.length) {
                return;
            }
            ParameterInfo old = ParameterTablePanel.this.myParameterInfos[oldIndex];
            ((ParameterTablePanel)ParameterTablePanel.this).myParameterInfos[oldIndex] = ParameterTablePanel.this.myParameterInfos[newIndex];
            ((ParameterTablePanel)ParameterTablePanel.this).myParameterInfos[newIndex] = old;
            ParameterTablePanel.this.myParameterInfos[oldIndex].setPosition(oldIndex);
            ParameterTablePanel.this.myParameterInfos[newIndex].setPosition(newIndex);
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
            ParameterTablePanel.this.updateSignature();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            if (oldIndex < 0 || newIndex < 0) {
                return false;
            }
            return oldIndex < ParameterTablePanel.this.myParameterInfos.length && newIndex < ParameterTablePanel.this.myParameterInfos.length;
        }

        @Override
        public int getRowCount() {
            return ParameterTablePanel.this.myParameterInfos.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return ParameterTablePanel.this.myParameterInfos[rowIndex].getName();
                }
                case 1: {
                    PsiType type = ParameterTablePanel.this.myParameterInfos[rowIndex].getType();
                    return type != null ? type.getPresentableText() : "";
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ParameterTablePanel.this.myParameterInfos[rowIndex].setPassAsParameter((Boolean)aValue);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 2: {
                    ParameterInfo info = ParameterTablePanel.this.myParameterInfos[rowIndex];
                    String name = (String)aValue;
                    if (GroovyNamesUtil.isIdentifier(name)) {
                        info.setNewName(name);
                    }
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    ParameterInfo info = ParameterTablePanel.this.myParameterInfos[rowIndex];
                    info.setType((PsiType)aValue);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.isEnabled();
                }
                case 2: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter();
                }
                case 1: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter() && !(ParameterTablePanel.this.myParameterTypeSelectors[rowIndex].getComponent() instanceof JLabel);
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }
}

