/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsCommitAdditionalComponent;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkin.GitCommitAuthorCorrector;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.ComboBoxEditor;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger log = Logger.getInstance((String)GitCheckinEnvironment.class.getName());
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
    @NonNls
    private static final String GIT_COMMIT_MSG_FILE_EXT = ".txt";
    private final Project myProject;
    public static final SimpleDateFormat COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final GitVcsSettings mySettings;
    private String myNextCommitAuthor;
    private boolean myNextCommitAmend;
    private Boolean myNextCommitIsPushed;
    private Date myNextCommitAuthorDate;

    public GitCheckinEnvironment(@NotNull Project project, @NotNull VcsDirtyScopeManager dirtyScopeManager, GitVcsSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment", "<init>"));
        }
        if (dirtyScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScopeManager", "git4idea/checkin/GitCheckinEnvironment", "<init>"));
        }
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myProject = project;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.mySettings = settings;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return new GitCheckinOptions(this.myProject, panel);
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        LinkedHashSet messages = ContainerUtil.newLinkedHashSet();
        for (VirtualFile root : GitUtil.gitRoots(Arrays.asList(filesToCheckin))) {
            VirtualFile mergeMsg = root.findFileByRelativePath(GitRepositoryFiles.GIT_MERGE_MSG);
            VirtualFile squashMsg = root.findFileByRelativePath(GitRepositoryFiles.GIT_SQUASH_MSG);
            try {
                if (mergeMsg == null && squashMsg == null) continue;
                String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
                if (mergeMsg != null) {
                    messages.add(GitCheckinEnvironment.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(GitCheckinEnvironment.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull((Collection)messages);
    }

    private static String loadMessage(@NotNull VirtualFile messageFile, @NotNull String encoding) throws IOException {
        if (messageFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageFile", "git4idea/checkin/GitCheckinEnvironment", "loadMessage"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "git4idea/checkin/GitCheckinEnvironment", "loadMessage"));
        }
        return FileUtil.loadFile((File)new File(messageFile.getPath()), (String)encoding);
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return GitBundle.getString("commit.action.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsException> commit(@NotNull List<Change> changes, @NotNull String message, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "git4idea/checkin/GitCheckinEnvironment", "commit"));
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Map<VirtualFile, Collection<Change>> sortedChanges = GitCheckinEnvironment.sortChangesByGitRoot(changes, exceptions);
        log.assertTrue(!sortedChanges.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        for (Map.Entry<VirtualFile, Collection<Change>> entry : sortedChanges.entrySet()) {
            VirtualFile root = entry.getKey();
            try {
                File messageFile = this.createMessageFile(root, message);
                try {
                    HashSet<FilePath> added = new HashSet<FilePath>();
                    HashSet<FilePath> removed = new HashSet<FilePath>();
                    block15: for (Change change : entry.getValue()) {
                        switch (change.getType()) {
                            case NEW: 
                            case MODIFICATION: {
                                added.add(change.getAfterRevision().getFile());
                                continue block15;
                            }
                            case DELETED: {
                                removed.add(change.getBeforeRevision().getFile());
                                continue block15;
                            }
                            case MOVED: {
                                FilePath afterPath = change.getAfterRevision().getFile();
                                FilePath beforePath = change.getBeforeRevision().getFile();
                                added.add(afterPath);
                                if (GitFileUtils.shouldIgnoreCaseChange(afterPath.getPath(), beforePath.getPath())) continue block15;
                                removed.add(beforePath);
                                continue block15;
                            }
                        }
                        throw new IllegalStateException("Unknown change type: " + change.getType());
                    }
                    try {
                        try {
                            HashSet<FilePath> files = new HashSet<FilePath>();
                            files.addAll(added);
                            files.addAll(removed);
                            GitCheckinEnvironment.commit(this.myProject, root, files, messageFile, this.myNextCommitAuthor, this.myNextCommitAmend, this.myNextCommitAuthorDate);
                        }
                        catch (VcsException ex) {
                            PartialOperation partialOperation = GitCheckinEnvironment.isMergeCommit(ex);
                            if (partialOperation == PartialOperation.NONE) {
                                throw ex;
                            }
                            if (GitCheckinEnvironment.mergeCommit(this.myProject, root, added, removed, messageFile, this.myNextCommitAuthor, exceptions, partialOperation)) continue;
                            throw ex;
                        }
                    }
                    finally {
                        if (messageFile.delete()) continue;
                        log.warn("Failed to remove temporary file: " + messageFile);
                    }
                }
                catch (VcsException e) {
                    exceptions.add(GitCheckinEnvironment.cleanupExceptionText(e));
                }
            }
            catch (IOException ex) {
                exceptions.add(new VcsException("Creation of commit message file failed", (Throwable)ex));
            }
        }
        if (this.myNextCommitIsPushed != null && this.myNextCommitIsPushed.booleanValue() && exceptions.isEmpty()) {
            GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
            Collection<GitRepository> repositories = GitUtil.getRepositoriesFromRoots(manager, sortedChanges.keySet());
            final ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositories);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    new VcsPushDialog(GitCheckinEnvironment.this.myProject, preselectedRepositories).show();
                }
            });
        }
        return exceptions;
    }

    @NotNull
    private static VcsException cleanupExceptionText(VcsException original) {
        String msg = original.getMessage();
        msg = GitUtil.cleanupErrorPrefixes(msg);
        String DURING_EXECUTING_SUFFIX = "during executing";
        int suffix = msg.indexOf("during executing");
        if (suffix > 0) {
            msg = msg.substring(0, suffix);
        }
        VcsException vcsException = new VcsException(msg.trim(), original.getCause());
        if (vcsException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment", "cleanupExceptionText"));
        }
        return vcsException;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    private static boolean mergeCommit(final Project project, VirtualFile root, Set<FilePath> added, Set<FilePath> removed, File messageFile, String author, List<VcsException> exceptions, final @NotNull PartialOperation partialOperation) {
        String output;
        if (partialOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialOperation", "git4idea/checkin/GitCheckinEnvironment", "mergeCommit"));
        }
        HashSet<FilePath> realAdded = new HashSet<FilePath>();
        HashSet<FilePath> realRemoved = new HashSet<FilePath>();
        GitSimpleHandler diff = new GitSimpleHandler(project, root, GitCommand.DIFF);
        diff.setSilent(true);
        diff.setStdoutSuppressed(true);
        diff.addParameters("--diff-filter=ADMRUX", "--name-status", "HEAD");
        diff.endOptions();
        try {
            output = diff.run();
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        String rootPath = root.getPath();
        StringTokenizer lines = new StringTokenizer(output, "\n", false);
        block11: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.length() == 0) continue;
            String[] tk = line.split("\t");
            switch (tk[0].charAt(0)) {
                case 'A': 
                case 'M': {
                    realAdded.add(VcsUtil.getFilePath((String)(rootPath + "/" + tk[1])));
                    continue block11;
                }
                case 'D': {
                    realRemoved.add(VcsUtil.getFilePathForDeletedFile((String)(rootPath + "/" + tk[1]), (boolean)false));
                    continue block11;
                }
            }
            throw new IllegalStateException("Unexpected status: " + line);
        }
        realAdded.removeAll(added);
        realRemoved.removeAll(removed);
        if (realAdded.size() != 0 || realRemoved.size() != 0) {
            final ArrayList<FilePath> files = new ArrayList<FilePath>();
            files.addAll(realAdded);
            files.addAll(realRemoved);
            final Ref mergeAll = new Ref();
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String message = GitBundle.message("commit.partial.merge.message", partialOperation.getName());
                        SelectFilePathsDialog dialog = new SelectFilePathsDialog(project, files, message, null, "Commit All Files", CommonBundle.getCancelButtonText(), false);
                        dialog.setTitle(GitBundle.getString("commit.partial.merge.title"));
                        dialog.show();
                        mergeAll.set((Object)dialog.isOK());
                    }
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to invoke a message box on AWT thread", ex);
            }
            if (!((Boolean)mergeAll.get()).booleanValue()) {
                return false;
            }
            if (!GitCheckinEnvironment.updateIndex(project, root, realAdded, realRemoved, exceptions)) {
                return false;
            }
            for (FilePath f : realAdded) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
            for (FilePath f : realRemoved) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(f);
            }
        }
        try {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters("-F", messageFile.getAbsolutePath());
            if (author != null) {
                handler.addParameters("--author=" + author);
            }
            handler.endOptions();
            handler.run();
            GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
            manager.updateRepository(root);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
            return false;
        }
        return true;
    }

    private static PartialOperation isMergeCommit(VcsException ex) {
        String message = ex.getMessage();
        if (message.contains("fatal: cannot do a partial commit during a merge")) {
            return PartialOperation.MERGE;
        }
        if (message.contains("fatal: cannot do a partial commit during a cherry-pick")) {
            return PartialOperation.CHERRY_PICK;
        }
        return PartialOperation.NONE;
    }

    private static boolean updateIndex(Project project, VirtualFile root, Collection<FilePath> added, Collection<FilePath> removed, List<VcsException> exceptions) {
        boolean rc = true;
        if (!added.isEmpty()) {
            try {
                GitFileUtils.addPaths(project, root, added);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        if (!removed.isEmpty()) {
            try {
                GitFileUtils.delete(project, root, removed, "--ignore-unmatch");
            }
            catch (VcsException ex) {
                exceptions.add(ex);
                rc = false;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createMessageFile(VirtualFile root, String message) throws IOException {
        File file = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
        file.deleteOnExit();
        String encoding = GitConfigUtil.getCommitEncoding(this.myProject, root);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        try {
            out.write(message);
        }
        finally {
            ((Writer)out).close();
        }
        return file;
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        Map<VirtualFile, List<FilePath>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilePathsByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<FilePath>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.delete(this.myProject, root, (Collection<FilePath>)e.getValue(), new String[0]);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static void commit(Project project, VirtualFile root, Collection<FilePath> files, File message, String nextCommitAuthor, boolean nextCommitAmend, Date nextCommitAuthorDate) throws VcsException {
        boolean amend = nextCommitAmend;
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            if (amend) {
                handler.addParameters("--amend");
            } else {
                amend = true;
            }
            handler.addParameters("--only", "-F", message.getAbsolutePath());
            if (nextCommitAuthor != null) {
                handler.addParameters("--author=" + nextCommitAuthor);
            }
            if (nextCommitAuthorDate != null) {
                handler.addParameters("--date", COMMIT_DATE_FORMAT.format(nextCommitAuthorDate));
            }
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
        if (!project.isDisposed()) {
            GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
            manager.updateRepository(root);
        }
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> sortedFiles;
        ArrayList<VcsException> rc = new ArrayList<VcsException>();
        try {
            sortedFiles = GitUtil.sortFilesByGitRoot(files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
            try {
                VirtualFile root = e.getKey();
                GitFileUtils.addFiles(this.myProject, root, (Collection<VirtualFile>)e.getValue());
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private static Map<VirtualFile, Collection<Change>> sortChangesByGitRoot(@NotNull List<Change> changes, List<VcsException> exceptions) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/checkin/GitCheckinEnvironment", "sortChangesByGitRoot"));
        }
        HashMap<VirtualFile, Collection<Change>> result = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : changes) {
            VirtualFile vcsRoot;
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null || afterRevision != null);
            FilePath filePath = afterRevision != null ? afterRevision.getFile() : beforeRevision.getFile();
            try {
                vcsRoot = GitUtil.getGitRoot(filePath.getParentPath());
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ArrayList<Change> changeList = (ArrayList<Change>)result.get(vcsRoot);
            if (changeList == null) {
                changeList = new ArrayList<Change>();
                result.put(vcsRoot, changeList);
            }
            changeList.add(change);
        }
        return result;
    }

    private void markRootDirty(VirtualFile root) {
        this.myDirtyScopeManager.dirDirtyRecursively(root);
    }

    public void reset() {
        this.myNextCommitAmend = false;
        this.myNextCommitAuthor = null;
        this.myNextCommitIsPushed = null;
        this.myNextCommitAuthorDate = null;
    }

    public void setNextCommitIsPushed(Boolean nextCommitIsPushed) {
        this.myNextCommitIsPushed = nextCommitIsPushed;
    }

    private class GitCheckinOptions
    extends DvcsCommitAdditionalComponent
    implements CheckinChangeListSpecificComponent {
        private final GitVcs myVcs;
        private final ComboBox myAuthorField;
        @Nullable
        private Date myAuthorDate;

        GitCheckinOptions(final @NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "<init>"));
            }
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "<init>"));
            }
            super(project, panel);
            this.myVcs = GitVcs.getInstance(project);
            Insets insets = new Insets(2, 2, 2, 2);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = insets;
            JLabel authorLabel = new JLabel(GitBundle.message("commit.author", new Object[0]));
            this.myPanel.add((Component)authorLabel, c);
            c = new GridBagConstraints();
            c.anchor = 10;
            c.insets = insets;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            HashSet<String> authors = new HashSet<String>(this.getUsersList(project));
            ContainerUtil.addAll(authors, (Object[])GitCheckinEnvironment.this.mySettings.getCommitAuthors());
            ArrayList<String> list = new ArrayList<String>(authors);
            Collections.sort(list);
            this.myAuthorField = new ComboBox(ArrayUtil.toObjectArray(list)){

                public void addNotify() {
                    super.addNotify();
                    StringComboboxEditor comboboxEditor = new StringComboboxEditor(project, (FileType)FileTypes.PLAIN_TEXT, GitCheckinOptions.this.myAuthorField, true);
                    GitCheckinOptions.this.myAuthorField.setEditor((ComboBoxEditor)comboboxEditor);
                    EditorEx editor = (EditorEx)comboboxEditor.getEditor();
                    assert (editor != null);
                    SpellCheckingEditorCustomization.getInstance((boolean)false).customize(editor);
                }
            };
            this.myAuthorField.setMinimumAndPreferredWidth(100);
            this.myAuthorField.setEditable(true);
            authorLabel.setLabelFor((Component)this.myAuthorField);
            this.myAuthorField.setToolTipText(GitBundle.getString("commit.author.tooltip"));
            this.myPanel.add((Component)this.myAuthorField, c);
        }

        @NotNull
        protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> filePaths) {
            if (filePaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getVcsRoots"));
            }
            Set<VirtualFile> set = GitUtil.gitRoots(filePaths);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getVcsRoots"));
            }
            return set;
        }

        @Nullable
        protected String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getLastCommitMessage"));
            }
            GitSimpleHandler h = new GitSimpleHandler(GitCheckinEnvironment.this.myProject, root, GitCommand.LOG);
            h.addParameters("--max-count=1");
            String formatPattern = GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(this.myVcs.getVersion()) ? "%B" : "%s%n%n%-b";
            h.addParameters("--pretty=format:" + formatPattern);
            return h.run();
        }

        @NotNull
        private List<String> getUsersList(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getUsersList"));
            }
            VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
            List list = ContainerUtil.map((Collection)userRegistry.getUsers(), (Function)new Function<VcsUser, String>(){

                public String fun(VcsUser user) {
                    return user.getName() + " <" + user.getEmail() + ">";
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinEnvironment$GitCheckinOptions", "getUsersList"));
            }
            return list;
        }

        public void refresh() {
            super.refresh();
            this.myAuthorField.setSelectedItem(null);
            this.myAuthorDate = null;
            GitCheckinEnvironment.this.reset();
        }

        public void saveState() {
            String author = (String)this.myAuthorField.getEditor().getItem();
            if (StringUtil.isEmptyOrSpaces((String)author)) {
                GitCheckinEnvironment.this.myNextCommitAuthor = null;
            } else {
                GitCheckinEnvironment.this.myNextCommitAuthor = GitCommitAuthorCorrector.correct(author);
                GitCheckinEnvironment.this.mySettings.saveCommitAuthor(GitCheckinEnvironment.this.myNextCommitAuthor);
            }
            GitCheckinEnvironment.this.myNextCommitAmend = this.myAmend.isSelected();
            GitCheckinEnvironment.this.myNextCommitAuthorDate = this.myAuthorDate;
        }

        public void restoreState() {
            this.refresh();
        }

        public void onChangeListSelected(LocalChangeList list) {
            Object data = list.getData();
            if (data instanceof VcsFullCommitDetails) {
                VcsFullCommitDetails commit = (VcsFullCommitDetails)data;
                String author = String.format("%s <%s>", commit.getAuthor().getName(), commit.getAuthor().getEmail());
                this.myAuthorField.setSelectedItem((Object)author);
                this.myAuthorDate = new Date(commit.getAuthorTime());
            } else {
                this.myAuthorField.setSelectedItem(null);
                this.myAuthorDate = null;
            }
        }
    }

    private static enum PartialOperation {
        NONE("none"),
        MERGE("merge"),
        CHERRY_PICK("cherry-pick");

        private final String myName;

        private PartialOperation(String name) {
            this.myName = name;
        }

        String getName() {
            return this.myName;
        }
    }
}

