/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.TestNGConfigurationType;
import com.theoryinpractice.testng.configuration.TestNGPatternConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGRunnableState;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.xml.Parser;

public class TestNGConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    @NonNls
    private static final String PATTERNS_EL_NAME = "patterns";
    @NonNls
    private static final String PATTERN_EL_NAME = "pattern";
    @NonNls
    private static final String TEST_CLASS_ATT_NAME = "testClass";
    protected TestData data;
    protected transient Project project;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    private static final Object PARSE_LOCK = new Object();
    public static final String DEFAULT_PACKAGE_NAME = ExecutionBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);
    public static final String DEFAULT_PACKAGE_CONFIGURATION_NAME = ExecutionBundle.message((String)"default.package.configuration.name", (Object[])new Object[0]);
    private final RefactoringListeners.Accessor<PsiPackage> myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

        public void setName(String qualifiedName) {
            boolean generatedName = TestNGConfiguration.this.isGeneratedName();
            TestNGConfiguration.this.data.PACKAGE_NAME = qualifiedName;
            if (generatedName) {
                TestNGConfiguration.this.setGeneratedName();
            }
        }

        @Nullable
        public PsiPackage getPsiElement() {
            String qualifiedName = TestNGConfiguration.this.data.getPackageName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findPackage(qualifiedName) : null;
        }

        public void setPsiElement(PsiPackage psiPackage) {
            this.setName(psiPackage.getQualifiedName());
        }
    };
    private final RefactoringListeners.Accessor<PsiClass> myClass = new RefactoringListeners.Accessor<PsiClass>(){

        public void setName(String qualifiedName) {
            boolean generatedName = TestNGConfiguration.this.isGeneratedName();
            TestNGConfiguration.this.data.MAIN_CLASS_NAME = qualifiedName;
            if (generatedName) {
                TestNGConfiguration.this.setGeneratedName();
            }
        }

        @Nullable
        public PsiClass getPsiElement() {
            String qualifiedName = TestNGConfiguration.this.data.getMainClassName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)TestNGConfiguration.this.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)TestNGConfiguration.this.project)) : null;
        }

        public void setPsiElement(PsiClass psiClass) {
            this.setName(psiClass.getQualifiedName());
        }
    };

    public TestNGConfiguration(String s, Project project, ConfigurationFactory factory) {
        this(s, project, new TestData(), factory);
    }

    private TestNGConfiguration(String s, Project project, TestData data, ConfigurationFactory factory) {
        super(s, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.data = data;
        this.project = project;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/theoryinpractice/testng/configuration/TestNGConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/theoryinpractice/testng/configuration/TestNGConfiguration", "getState"));
        }
        return new TestNGRunnableState(env, this);
    }

    public TestData getPersistantData() {
        return this.data;
    }

    protected ModuleBasedConfiguration createInstance() {
        try {
            return new TestNGConfiguration(this.getName(), this.getProject(), (TestData)this.data.clone(), TestNGConfigurationType.getInstance().getConfigurationFactories()[0]);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.data.getMainClassName());
    }

    public String suggestedName() {
        return this.data.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public String getActionName() {
        if (TestType.CLASS.getType().equals(this.data.TEST_OBJECT)) {
            String shortName = JavaExecutionUtil.getShortClassName((String)this.data.MAIN_CLASS_NAME);
            return ProgramRunnerUtil.shortenName((String)shortName, (int)0);
        }
        if (TestType.PACKAGE.getType().equals(this.data.TEST_OBJECT)) {
            String s = this.getName();
            if (!this.isGeneratedName()) {
                return '\"' + s + '\"';
            }
            if (this.data.getPackageName().trim().length() > 0) {
                return "Tests in \"" + this.data.getPackageName() + '\"';
            }
            return "All Tests";
        }
        if (TestType.METHOD.getType().equals(this.data.TEST_OBJECT)) {
            return this.data.getMethodName() + "()";
        }
        if (TestType.SUITE.getType().equals(this.data.TEST_OBJECT)) {
            return this.data.getSuiteName();
        }
        return this.data.getGroupName();
    }

    public void setVMParameters(String value) {
        this.data.setVMParameters(value);
    }

    public String getVMParameters() {
        return this.data.getVMParameters();
    }

    public void setProgramParameters(String value) {
        this.data.setProgramParameters(value);
    }

    public String getProgramParameters() {
        return this.data.getProgramParameters();
    }

    public void setWorkingDirectory(String value) {
        this.data.setWorkingDirectory(value);
    }

    public String getWorkingDirectory() {
        return this.data.getWorkingDirectory(this.project);
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/theoryinpractice/testng/configuration/TestNGConfiguration", "setEnvs"));
        }
        this.data.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.data.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.data.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.data.PASS_PARENT_ENVS;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public String getRunClass() {
        return !this.data.TEST_OBJECT.equals(TestType.CLASS.getType()) && !this.data.TEST_OBJECT.equals(TestType.METHOD.getType()) ? null : this.data.getMainClassName();
    }

    public String getPackage() {
        return !this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType()) ? null : this.data.getPackageName();
    }

    public void setClassConfiguration(PsiClass psiclass) {
        this.setModule(this.data.setMainClass(psiclass));
        this.data.TEST_OBJECT = TestType.CLASS.getType();
        this.setGeneratedName();
    }

    public void setPackageConfiguration(Module module, PsiPackage pkg) {
        this.data.setPackage(pkg);
        this.setModule(module);
        this.data.TEST_OBJECT = TestType.PACKAGE.getType();
        this.setGeneratedName();
    }

    public void setMethodConfiguration(Location<PsiMethod> location) {
        this.setModule(this.data.setTestMethod(location));
        this.setGeneratedName();
    }

    public void bePatternConfiguration(List<PsiClass> classes, PsiMethod method) {
        String suffix;
        this.data.TEST_OBJECT = TestType.PATTERN.getType();
        if (method != null) {
            this.data.METHOD_NAME = method.getName();
            suffix = "," + this.data.METHOD_NAME;
        } else {
            suffix = "";
        }
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        for (PsiClass pattern : classes) {
            patterns.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)pattern) + suffix);
        }
        this.data.setPatterns(patterns);
        Module module = TestNGPatternConfigurationProducer.findModule(this, ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), patterns);
        if (module == null) {
            this.data.setScope(TestSearchScope.WHOLE_PROJECT);
            this.setModule(null);
        } else {
            this.setModule(module);
        }
        this.setGeneratedName();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new TestNGConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConfiguration() throws RuntimeConfigurationException {
        block17: {
            if (this.data.TEST_OBJECT.equals(TestType.CLASS.getType()) || this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
                SourceScope scope = this.data.getScope().getSourceScope((ModuleBasedConfiguration)this);
                if (scope == null) {
                    throw new RuntimeConfigurationException("Invalid scope specified");
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.project).findClass(this.data.getMainClassName(), scope.getGlobalSearchScope());
                if (psiClass == null) {
                    throw new RuntimeConfigurationException("Class '" + this.data.getMainClassName() + "' not found");
                }
                if (this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
                    PsiMethod[] methods = psiClass.findMethodsByName(this.data.getMethodName(), true);
                    if (methods.length == 0) {
                        throw new RuntimeConfigurationException("Method '" + this.data.getMethodName() + "' not found");
                    }
                    for (PsiMethod method : methods) {
                        if (method.hasModifierProperty("public")) continue;
                        throw new RuntimeConfigurationException("Non public method '" + this.data.getMethodName() + "'specified");
                    }
                }
            } else if (this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
                PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.project).findPackage(this.data.getPackageName());
                if (psiPackage == null) {
                    throw new RuntimeConfigurationException("Package '" + this.data.getPackageName() + "' not found");
                }
            } else {
                Set<String> patterns;
                if (this.data.TEST_OBJECT.equals(TestType.SUITE.getType())) {
                    try {
                        Parser parser = new Parser(this.data.getSuiteName());
                        parser.setLoadClasses(false);
                        Object object = PARSE_LOCK;
                        synchronized (object) {
                            parser.parse();
                            break block17;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeConfigurationException("Unable to parse '" + this.data.getSuiteName() + "' specified");
                    }
                }
                if (this.data.TEST_OBJECT.equals(TestType.PATTERN.getType()) && (patterns = this.data.getPatterns()).isEmpty()) {
                    throw new RuntimeConfigurationWarning("No pattern selected");
                }
            }
        }
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element patternsElement;
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistantData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistantData().getEnvs());
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        properties.clear();
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            List children = propertiesElement.getChildren("property");
            for (Element property : children) {
                properties.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        listeners.clear();
        Element listenersElement = element.getChild("listeners");
        if (listenersElement != null) {
            List children = listenersElement.getChildren("listener");
            for (Element listenerClassName : children) {
                listeners.add(listenerClassName.getAttributeValue("class"));
            }
        }
        if ((patternsElement = element.getChild(PATTERNS_EL_NAME)) != null) {
            LinkedHashSet<String> tests = new LinkedHashSet<String>();
            Iterator i$ = patternsElement.getChildren(PATTERN_EL_NAME).iterator();
            while (i$.hasNext()) {
                Element o;
                Element patternElement = o = (Element)i$.next();
                tests.add(patternElement.getAttributeValue(TEST_CLASS_ATT_NAME));
            }
            this.getPersistantData().setPatterns(tests);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.writeExternal((Object)this.getPersistantData(), (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getPersistantData().getEnvs());
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement == null) {
            propertiesElement = new Element("properties");
            element.addContent(propertiesElement);
        }
        Map<String, String> properties = this.getPersistantData().TEST_PROPERTIES;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Element property = new Element("property");
            property.setAttribute("name", entry.getKey());
            property.setAttribute("value", entry.getValue());
            propertiesElement.addContent(property);
        }
        Element listenersElement = element.getChild("listeners");
        if (listenersElement == null) {
            listenersElement = new Element("listeners");
            element.addContent(listenersElement);
        }
        List<String> listeners = this.getPersistantData().TEST_LISTENERS;
        for (String listener : listeners) {
            Element listenerElement = new Element("listener");
            listenerElement.setAttribute("class", listener);
            listenersElement.addContent(listenerElement);
        }
        Set<String> patterns = this.getPersistantData().getPatterns();
        if (!patterns.isEmpty()) {
            Element patternsElement = new Element(PATTERNS_EL_NAME);
            for (String o : patterns) {
                Element patternElement = new Element(PATTERN_EL_NAME);
                patternElement.setAttribute(TEST_CLASS_ATT_NAME, o);
                patternsElement.addContent(patternElement);
            }
            element.addContent(patternsElement);
        }
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.data.TEST_OBJECT.equals(TestType.PACKAGE.getType())) {
            if (!(element instanceof PsiPackage)) {
                return null;
            }
            RefactoringElementListener listener = RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), this.myPackage);
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
        }
        if (this.data.TEST_OBJECT.equals(TestType.CLASS.getType())) {
            if (!(element instanceof PsiClass) && !(element instanceof PsiPackage)) {
                return null;
            }
            RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
        }
        if (this.data.TEST_OBJECT.equals(TestType.METHOD.getType())) {
            if (!(element instanceof PsiMethod)) {
                RefactoringElementListener listener = RefactoringListeners.getClassOrPackageListener((PsiElement)element, this.myClass);
                return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
            }
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(this.data.getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(this.myClass.getPsiElement())) {
                return null;
            }
            class Listener
            extends RefactoringElementAdapter
            implements UndoRefactoringElementListener {
                Listener() {
                }

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/theoryinpractice/testng/configuration/TestNGConfiguration$1Listener", "elementRenamedOrMoved"));
                    }
                    TestNGConfiguration.this.data.setTestMethod((Location<PsiMethod>)PsiLocation.fromPsiElement((PsiElement)((PsiMethod)newElement)));
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/theoryinpractice/testng/configuration/TestNGConfiguration$1Listener", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/theoryinpractice/testng/configuration/TestNGConfiguration$1Listener", "undoElementMovedOrRenamed"));
                    }
                    int methodIdx = oldQualifiedName.indexOf("#") + 1;
                    if (methodIdx <= 0 || methodIdx >= oldQualifiedName.length()) {
                        return;
                    }
                    TestNGConfiguration.this.data.METHOD_NAME = oldQualifiedName.substring(methodIdx);
                }
            }
            return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)new Listener());
        }
        return null;
    }

    public boolean collectOutputFromProcessHandler() {
        return false;
    }
}

