/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.findUsages.PropertySearcher;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedPropertyInspection
extends PropertySuppressableInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("unused.property.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedProperty" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getShortName"));
        }
        return "UnusedProperty";
    }

    @Nullable
    private static GlobalSearchScope getWidestUseScope(@Nullable String key, @NotNull Project project, @NotNull Module ownModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getWidestUseScope"));
        }
        if (ownModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownModule", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "getWidestUseScope"));
        }
        if (key == null) {
            return null;
        }
        LinkedHashSet modules = ContainerUtil.newLinkedHashSet();
        for (IProperty property : PropertiesImplUtil.findPropertiesByKey(project, key)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)property.getPsiElement());
            if (module == null) {
                return GlobalSearchScope.allScope((Project)project);
            }
            if (module == ownModule) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            return null;
        }
        ArrayList list = ContainerUtil.newArrayList((Iterable)modules);
        GlobalSearchScope result = GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            result = result.uniteWith(GlobalSearchScope.moduleWithDependentsScope((Module)((Module)list.get(i))));
        }
        return result;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        final PsiFile file = session.getFile();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        final GlobalSearchScope ownUseScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
        Object[] extensions = Extensions.getExtensions((String)"com.intellij.referencesSearch");
        final PropertySearcher searcher = (PropertySearcher)ContainerUtil.find((Object[])extensions, (Condition)new FilteringIterator.InstanceOf(PropertySearcher.class));
        final PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)file.getProject());
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
                if (original != null) {
                    if (original.isCanceled()) {
                        return;
                    }
                    original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
                }
                if (ImplicitPropertyUsageProvider.isImplicitlyUsed(property)) {
                    return;
                }
                String name = property.getName();
                if (name == null) {
                    return;
                }
                if (searcher != null && (name = searcher.getKeyToSearch(name, element.getProject())) == null) {
                    return;
                }
                if (this.mayHaveUsages(property, original, name, ownUseScope)) {
                    return;
                }
                GlobalSearchScope widerScope = UnusedPropertyInspection.getWidestUseScope(property.getKey(), element.getProject(), module);
                if (widerScope != null && this.mayHaveUsages(property, original, name, widerScope)) {
                    return;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                String description = PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]);
                LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createRemovePropertyLocalFix();
                holder.registerProblem((PsiElement)key, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
            }

            private boolean mayHaveUsages(Property property, ProgressIndicator original, String name, GlobalSearchScope searchScope) {
                PsiSearchHelper.SearchCostResult cheapEnough = searchHelper.isCheapEnoughToSearch(name, searchScope, file, original);
                if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
                return cheapEnough != PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && ReferencesSearch.search((PsiElement)property, (SearchScope)searchScope, (boolean)false).findFirst() != null;
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unused/UnusedPropertyInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

