/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.spellchecker;

import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.PropertiesSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import org.jetbrains.annotations.NotNull;

public class PropertiesSpellcheckingStrategy
extends SpellcheckingStrategy {
    private Tokenizer<PropertyValueImpl> myPropertyValueTokenizer = TokenizerBase.create((Splitter)PlainTextSplitter.getInstance());
    private Tokenizer<PropertyImpl> myPropertyTokenizer = new MyPropertyTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PropertyValueImpl) {
            Tokenizer<PropertyValueImpl> tokenizer = this.myPropertyValueTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof PropertyImpl) {
            Tokenizer<PropertyImpl> tokenizer = this.myPropertyTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    private static class MyPropertyTokenizer
    extends Tokenizer<PropertyImpl> {
        private MyPropertyTokenizer() {
        }

        public void tokenize(@NotNull PropertyImpl element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy$MyPropertyTokenizer", "tokenize"));
            }
            String key = element.getKey();
            consumer.consumeToken((PsiElement)element, key, true, 0, TextRange.allOf((String)key), (Splitter)PropertiesSplitter.getInstance());
        }
    }
}

