/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.optinstructions;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.java.decompiler.code.Instruction;

public class BIPUSH
extends Instruction {
    private static int[] opcodes = new int[]{2, 3, 4, 5, 6, 7, 8};

    @Override
    public void writeToStream(DataOutputStream out, int offset) throws IOException {
        int value = this.getOperand(0);
        if (value < -1 || value > 5) {
            out.writeByte(16);
            out.writeByte(value);
        } else {
            out.writeByte(opcodes[value + 1]);
        }
    }

    @Override
    public int length() {
        int value = this.getOperand(0);
        if (value < -1 || value > 5) {
            return 2;
        }
        return 1;
    }
}

