/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.VcsBackgroundTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;

public class AddAction
extends BasicAction {
    static final Logger log = Logger.getInstance((String)"org.jetbrains.idea.svn.action.AddAction");

    @Override
    protected String getActionName(AbstractVcs vcs) {
        log.debug("enter: getActionName");
        return SvnBundle.message("action.name.add.files", vcs.getName());
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        return SvnStatusUtil.fileCanBeAdded(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        log.debug("enter: batchPerform");
        this.addFiles(project, activeVcs, files);
    }

    private void addFiles(final Project project, final SvnVcs activeVcs, VirtualFile[] files) {
        VcsBackgroundTask<VirtualFile[]> task = new VcsBackgroundTask<VirtualFile[]>(project, this.getActionName(activeVcs), BackgroundFromStartOption.getInstance(), Collections.singleton(files), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void process(VirtualFile[] items) throws VcsException {
                ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
                manager.startBackgroundVcsOperation();
                try {
                    HashSet<VirtualFile> additionallyDirty = new HashSet<VirtualFile>();
                    FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
                    for (VirtualFile item : items) {
                        FileStatus fs;
                        for (VirtualFile current = item.getParent(); current != null && FileStatus.UNKNOWN.equals(fs = fileStatusManager.getStatus(current)); current = current.getParent()) {
                            additionallyDirty.add(current);
                        }
                    }
                    List<VcsException> exceptions = SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(activeVcs, Arrays.asList(items), true);
                    additionallyDirty.addAll(Arrays.asList(items));
                    AddAction.this.markDirty(project, additionallyDirty);
                    if (!exceptions.isEmpty()) {
                        ArrayList<String> messages = new ArrayList<String>(exceptions.size());
                        for (VcsException exception : exceptions) {
                            messages.add(exception.getMessage());
                        }
                        throw new VcsException(messages);
                    }
                }
                finally {
                    manager.stopBackgroundVcsOperation();
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void markDirty(Project project, Collection<VirtualFile> items) {
        ArrayList<VirtualFile> vDirs = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : items) {
            if (file.isDirectory()) {
                vDirs.add(file);
                continue;
            }
            vFiles.add(file);
        }
        VcsDirtyScopeManager.getInstance((Project)project).filesDirty(vFiles, vDirs);
    }

    @Override
    protected boolean witeLocalHistory() {
        return false;
    }

    @Override
    protected boolean isBatchAction() {
        log.debug("enter: isBatchAction");
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.addFiles(project, activeVcs, new VirtualFile[]{file});
    }
}

