/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.revert;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdRevertClient
extends BaseSvnClient
implements RevertClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final String OPTIONAL_COMMENT = "(.*)";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*(.*)");

    @Override
    public void revert(@NotNull File[] paths, @Nullable Depth depth, @Nullable ProgressTracker handler) throws VcsException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/revert/CmdRevertClient", "revert"));
        }
        if (paths.length > 0) {
            List<String> parameters = CmdRevertClient.prepareParameters(paths, depth);
            CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)paths[0]), CommandUtil.getHomeDirectory(), SvnCommandName.revert, parameters, null);
            FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new RevertStatusConvertor());
            parser.parse(command.getOutput());
        }
    }

    private static List<String> prepareParameters(File[] paths, Depth depth) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, paths);
        CommandUtil.put(parameters, depth);
        return parameters;
    }

    private static class RevertStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        private RevertStatusConvertor() {
        }

        public ProgressEvent convert(@NotNull Matcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "org/jetbrains/idea/svn/revert/CmdRevertClient$RevertStatusConvertor", "convert"));
            }
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdRevertClient.createEvent(new File(path), RevertStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static EventAction createAction(@NotNull String code) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "org/jetbrains/idea/svn/revert/CmdRevertClient$RevertStatusConvertor", "createAction"));
            }
            EventAction result = null;
            if ("Reverted".equals(code)) {
                result = EventAction.REVERT;
            } else if ("Failed to revert".equals(code)) {
                result = EventAction.FAILED_REVERT;
            } else if ("Skipped".equals(code)) {
                result = EventAction.SKIP;
            }
            return result;
        }
    }
}

