/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class ScopeColorsPageFactory
implements ColorAndFontPanelFactory {
    ScopeColorsPageFactory() {
    }

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ScopeColorsPageFactory", "createPanel"));
        }
        final JPanel scopePanel = ScopeColorsPageFactory.createChooseScopePanel();
        NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create(new PreviewPanel.Empty(){

            @Override
            public Component getPanel() {
                return scopePanel;
            }
        }, ColorAndFontOptions.SCOPES_GROUP, options, null, null);
        if (newColorAndFontPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ScopeColorsPageFactory", "createPanel"));
        }
        return newColorAndFontPanel;
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        String string = ColorAndFontOptions.SCOPES_GROUP;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ScopeColorsPageFactory", "getPanelDisplayName"));
        }
        return string;
    }

    private static JPanel createChooseScopePanel() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        JPanel panel = new JPanel(new GridBagLayout());
        if (projects.length == 0) {
            return panel;
        }
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        Project contextProject = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        final Project project = contextProject != null ? contextProject : projects[0];
        JButton button = new JButton("Manage Scopes...");
        button.setPreferredSize(new Dimension(230, button.getPreferredSize().height));
        panel.add((Component)button, gc);
        gc.gridx = 0;
        gc.weightx = 1.0;
        panel.add((Component)new JPanel(), gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weighty = 1.0;
        panel.add((Component)new JPanel(), gc);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/ScopeColorsPageFactory$2", "actionPerformed"));
                }
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext());
                if (settings != null) {
                    try {
                        if (settings.select(settings.find("project.scopes")).isRejected()) {
                            EditScopesDialog.showDialog(project, null);
                        }
                    }
                    catch (IllegalStateException ex) {
                        EditScopesDialog.showDialog(project, null);
                    }
                }
            }
        });
        return panel;
    }
}

