/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.PropertyClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldMember
extends PsiElementClassMember<PsiField>
implements PropertyClassMember {
    private static final int FIELD_OPTIONS = 7;

    public PsiFieldMember(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/generation/PsiFieldMember", "<init>"));
        }
        super(field, PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY));
    }

    public PsiFieldMember(@NotNull PsiField psiMember, PsiSubstitutor substitutor) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/codeInsight/generation/PsiFieldMember", "<init>"));
        }
        super(psiMember, substitutor, PsiFormatUtil.formatVariable((PsiVariable)psiMember, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY));
    }

    @Override
    @Nullable
    public GenerationInfo generateGetter() throws IncorrectOperationException {
        GenerationInfo[] infos = this.generateGetters(((PsiField)this.getElement()).getContainingClass());
        return infos != null && infos.length > 0 ? infos[0] : null;
    }

    @Override
    @Nullable
    public GenerationInfo[] generateGetters(PsiClass aClass) throws IncorrectOperationException {
        return PsiFieldMember.createGenerateInfos(aClass, GetterSetterPrototypeProvider.generateGetterSetters((PsiField)this.getElement(), true));
    }

    @Override
    @Nullable
    public GenerationInfo generateSetter() throws IncorrectOperationException {
        GenerationInfo[] infos = this.generateSetters(((PsiField)this.getElement()).getContainingClass());
        return infos != null && infos.length > 0 ? infos[0] : null;
    }

    @Override
    @Nullable
    public GenerationInfo[] generateSetters(PsiClass aClass) {
        PsiField field = (PsiField)this.getElement();
        if (GetterSetterPrototypeProvider.isReadOnlyProperty(field)) {
            return null;
        }
        return PsiFieldMember.createGenerateInfos(aClass, GetterSetterPrototypeProvider.generateGetterSetters(field, false));
    }

    private static GenerationInfo[] createGenerateInfos(PsiClass aClass, PsiMethod[] prototypes) {
        ArrayList<PsiGenerationInfo<PsiMethod>> methods = new ArrayList<PsiGenerationInfo<PsiMethod>>();
        for (PsiMethod prototype : prototypes) {
            PsiMethod method = PsiFieldMember.createMethodIfNotExists(aClass, prototype);
            if (method == null) continue;
            methods.add(new PsiGenerationInfo<PsiMethod>(method));
        }
        return methods.isEmpty() ? null : methods.toArray(new GenerationInfo[methods.size()]);
    }

    @Nullable
    private static PsiMethod createMethodIfNotExists(PsiClass aClass, PsiMethod template) {
        PsiMethod existing = aClass.findMethodBySignature(template, false);
        return existing == null ? template : null;
    }
}

