/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement> {
    private final String myPopupTitle;
    private final String myEmptyText;
    private final Computable<PsiElementListCellRenderer> myCellRenderer;
    private final NotNullLazyValue<List<SmartPsiElementPointer>> myPointers;

    protected NavigationGutterIconRenderer(String popupTitle, String emptyText, @NotNull Computable<PsiElementListCellRenderer> cellRenderer, @NotNull NotNullLazyValue<List<SmartPsiElementPointer>> pointers) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer", "<init>"));
        }
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer", "<init>"));
        }
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers;
    }

    public boolean isNavigateAction() {
        return true;
    }

    public List<PsiElement> getTargetElements() {
        return ContainerUtil.mapNotNull((Collection)((Collection)this.myPointers.getValue()), (Function)new NullableFunction<SmartPsiElementPointer, PsiElement>(){

            public PsiElement fun(SmartPsiElementPointer smartPsiElementPointer) {
                return smartPsiElementPointer.getElement();
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer = (NavigationGutterIconRenderer)((Object)o);
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer.myEmptyText) : renderer.myEmptyText != null) {
            return false;
        }
        if (!((Object)((List)this.myPointers.getValue())).equals(renderer.myPointers.getValue())) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer.myPopupTitle) : renderer.myPopupTitle != null);
    }

    public int hashCode() {
        int result = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result = 31 * result + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result = 31 * result + ((Object)((List)this.myPointers.getValue())).hashCode();
        return result;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                NavigationGutterIconRenderer.this.navigate(e == null ? null : (MouseEvent)e.getInputEvent(), null);
            }
        };
    }

    public void navigate(@Nullable MouseEvent event, @Nullable PsiElement elt) {
        List<PsiElement> list = this.getTargetElements();
        if (list.isEmpty()) {
            if (this.myEmptyText != null && event != null) {
                JComponent label = HintUtil.createErrorLabel(this.myEmptyText);
                label.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)7, (int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.ERROR_COLOR).createBalloon().show(new RelativePoint(event), Balloon.Position.above);
            }
            return;
        }
        if (list.size() == 1) {
            PsiNavigateUtil.navigate((PsiElement)list.iterator().next());
        } else if (event != null) {
            JBPopup popup = NavigationUtil.getPsiElementPopup(PsiUtilCore.toPsiElementArray(list), (PsiElementListCellRenderer)this.myCellRenderer.compute(), this.myPopupTitle);
            popup.show(new RelativePoint(event));
        }
    }
}

