/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateSettingsEditor;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateListPanel
extends JPanel
implements Disposable {
    private static final String NO_SELECTION = "NoSelection";
    private static final String TEMPLATE_SETTINGS = "TemplateSettings";
    private static final TemplateImpl MOCK_TEMPLATE = new TemplateImpl("mockTemplate-xxx", "mockTemplateGroup-yyy");
    public static final String ABBREVIATION = "<abbreviation>";
    public static final Comparator<TemplateImpl> TEMPLATE_COMPARATOR = new Comparator<TemplateImpl>(){

        @Override
        public int compare(TemplateImpl o1, TemplateImpl o2) {
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        }
    };
    private CheckboxTree myTree;
    private final List<TemplateGroup> myTemplateGroups = new ArrayList<TemplateGroup>();
    private JComboBox myExpandByCombo;
    private HyperlinkLabel myOpenKeymapLabel;
    private static final String SPACE;
    private static final String TAB;
    private static final String ENTER;
    private static final String CUSTOM = "Custom";
    private CheckedTreeNode myTreeRoot = new CheckedTreeNode(null);
    private final Alarm myAlarm = new Alarm();
    private boolean myUpdateNeeded = false;
    private static final Logger LOG;
    private final Map<Integer, Map<TemplateOptionalProcessor, Boolean>> myTemplateOptions = new LinkedHashMap<Integer, Map<TemplateOptionalProcessor, Boolean>>();
    private final Map<Integer, TemplateContext> myTemplateContext = ContainerUtil.newLinkedHashMap();
    private final JPanel myDetailsPanel = new JPanel(new CardLayout());
    private LiveTemplateSettingsEditor myCurrentTemplateEditor;
    private final boolean isTest = ApplicationManager.getApplication().isUnitTestMode();

    public TemplateListPanel() {
        super(new BorderLayout());
        this.myDetailsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JLabel label = new JLabel("No live template is selected");
        label.setHorizontalAlignment(0);
        this.myDetailsPanel.add((Component)label, NO_SELECTION);
        this.createTemplateEditor(MOCK_TEMPLATE, "Tab", MOCK_TEMPLATE.createOptions(), MOCK_TEMPLATE.createContext());
        this.add((Component)this.createExpandByPanel(), "North");
        Splitter splitter = new Splitter(true, 0.9f);
        splitter.setFirstComponent((JComponent)this.createTable());
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)splitter, "Center");
    }

    public void dispose() {
        this.myCurrentTemplateEditor.dispose();
        this.myAlarm.cancelAllRequests();
    }

    public void reset() {
        this.myTemplateOptions.clear();
        this.myTemplateContext.clear();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        ArrayList<TemplateGroup> groups = new ArrayList<TemplateGroup>(templateSettings.getTemplateGroups());
        Collections.sort(groups, new Comparator<TemplateGroup>(){

            @Override
            public int compare(TemplateGroup o1, TemplateGroup o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.initTemplates(groups, templateSettings.getLastSelectedTemplateGroup(), templateSettings.getLastSelectedTemplateKey());
        char shortcutChar = templateSettings.getDefaultShortcutChar();
        this.myExpandByCombo.setSelectedItem(shortcutChar == 'C' ? CUSTOM : (shortcutChar == '\t' ? TAB : (shortcutChar == '\n' ? ENTER : SPACE)));
        UiNotifyConnector.doWhenFirstShown((JComponent)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                TemplateListPanel.this.updateTemplateDetails(false, false);
            }
        });
        this.myUpdateNeeded = true;
    }

    public void apply() throws ConfigurationException {
        List<TemplateGroup> templateGroups = this.getTemplateGroups();
        for (TemplateGroup templateGroup : templateGroups) {
            HashSet names = ContainerUtil.newHashSet();
            List templates = templateGroup.getElements();
            for (TemplateImpl template : templates) {
                if (StringUtil.isEmptyOrSpaces((String)template.getKey())) {
                    throw new ConfigurationException("A live template with an empty key has been found in " + templateGroup.getName() + " group, such live templates cannot be invoked");
                }
                if (StringUtil.isEmptyOrSpaces((String)template.getString())) {
                    throw new ConfigurationException("A live template with an empty text has been found in " + templateGroup.getName() + " group, such live templates cannot be invoked");
                }
                if (names.add(template.getKey())) continue;
                throw new ConfigurationException("Duplicate " + template.getKey() + " live templates in " + templateGroup.getName() + " group");
            }
        }
        for (TemplateGroup templateGroup : templateGroups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                template.applyOptions(this.getTemplateOptions(template));
                template.applyContext(this.getTemplateContext(template));
            }
        }
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        templateSettings.setTemplates(templateGroups);
        templateSettings.setDefaultShortcutChar(this.getDefaultShortcutChar());
        this.reset();
    }

    public boolean isModified() {
        List<TemplateImpl> newGroup;
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        if (templateSettings.getDefaultShortcutChar() != this.getDefaultShortcutChar()) {
            if (this.isTest) {
                System.err.println("LiveTemplatesConfig: templateSettings.getDefaultShortcutChar()=" + templateSettings.getDefaultShortcutChar() + "; getDefaultShortcutChar()=" + this.getDefaultShortcutChar());
            }
            return true;
        }
        List<TemplateGroup> originalGroups = templateSettings.getTemplateGroups();
        List<TemplateGroup> newGroups = this.getTemplateGroups();
        List<TemplateImpl> originalGroup = TemplateListPanel.collectTemplates(originalGroups);
        if (this.checkAreEqual(originalGroup, newGroup = TemplateListPanel.collectTemplates(newGroups))) {
            return false;
        }
        if (this.isTest) {
            System.err.println("LiveTemplatesConfig: originalGroups=" + originalGroups + "; collectTemplates(originalGroups)=" + originalGroup + ";\n newGroups=" + newGroups + "; collectTemplates(newGroups)=" + newGroup);
        }
        return true;
    }

    public void editTemplate(TemplateImpl template) {
        this.selectTemplate(template.getGroupName(), template.getKey());
        this.updateTemplateDetails(true, false);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.getTemplate(this.getSingleSelectedIndex()) != null) {
            return this.myCurrentTemplateEditor.getKeyField();
        }
        return null;
    }

    private static List<TemplateImpl> collectTemplates(List<TemplateGroup> groups) {
        ArrayList<TemplateImpl> result = new ArrayList<TemplateImpl>();
        for (TemplateGroup group : groups) {
            result.addAll(group.getElements());
        }
        Collections.sort(result, new Comparator<TemplateImpl>(){

            @Override
            public int compare(TemplateImpl o1, TemplateImpl o2) {
                int groupsEqual = o1.getGroupName().compareToIgnoreCase(o2.getGroupName());
                if (groupsEqual != 0) {
                    return groupsEqual;
                }
                return o1.getKey().compareToIgnoreCase(o2.getKey());
            }
        });
        return result;
    }

    private boolean checkAreEqual(List<TemplateImpl> originalGroup, List<TemplateImpl> newGroup) {
        if (originalGroup.size() != newGroup.size()) {
            return false;
        }
        for (int i = 0; i < newGroup.size(); ++i) {
            if (!this.templatesDiffer(newGroup.get(i), originalGroup.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areOptionsEqual(TemplateImpl newTemplate, TemplateImpl originalTemplate) {
        Map<TemplateOptionalProcessor, Boolean> templateOptions = this.getTemplateOptions(newTemplate);
        for (TemplateOptionalProcessor processor : templateOptions.keySet()) {
            if (processor.isEnabled(originalTemplate) == templateOptions.get(processor).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private TemplateContext getTemplateContext(TemplateImpl newTemplate) {
        return this.myTemplateContext.get(TemplateListPanel.getKey(newTemplate));
    }

    private Map<TemplateOptionalProcessor, Boolean> getTemplateOptions(TemplateImpl newTemplate) {
        return this.myTemplateOptions.get(TemplateListPanel.getKey(newTemplate));
    }

    private char getDefaultShortcutChar() {
        Object selectedItem = this.myExpandByCombo.getSelectedItem();
        if (TAB.equals(selectedItem)) {
            return '\t';
        }
        if (ENTER.equals(selectedItem)) {
            return '\n';
        }
        if (SPACE.equals(selectedItem)) {
            return ' ';
        }
        return 'C';
    }

    private List<TemplateGroup> getTemplateGroups() {
        return this.myTemplateGroups;
    }

    private void createTemplateEditor(final TemplateImpl template, String shortcut, Map<TemplateOptionalProcessor, Boolean> options, TemplateContext context) {
        this.myCurrentTemplateEditor = new LiveTemplateSettingsEditor(template, shortcut, options, context, new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node = TemplateListPanel.this.getNode(TemplateListPanel.this.getSingleSelectedIndex());
                if (node != null) {
                    ((DefaultTreeModel)TemplateListPanel.this.myTree.getModel()).nodeChanged(node);
                    TemplateSettings.getInstance().setLastSelectedTemplate(template.getGroupName(), template.getKey());
                }
            }
        }, TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName()) != null);
        for (Component component : this.myDetailsPanel.getComponents()) {
            if (!(component instanceof LiveTemplateSettingsEditor)) continue;
            this.myDetailsPanel.remove(component);
        }
        this.myDetailsPanel.add((Component)this.myCurrentTemplateEditor, TEMPLATE_SETTINGS);
    }

    private Iterable<? extends TemplateImpl> collectAllTemplates() {
        ArrayList result = new ArrayList();
        for (TemplateGroup templateGroup : this.myTemplateGroups) {
            result.addAll(templateGroup.getElements());
        }
        return result;
    }

    private void exportCurrentGroup() {
        int selected = this.getSingleSelectedIndex();
        if (selected < 0) {
            return;
        }
        ExportSchemeAction.doExport(this.getGroup(selected), TemplateListPanel.getSchemesManager());
    }

    private static SchemesManager<TemplateGroup, TemplateGroup> getSchemesManager() {
        return TemplateSettings.getInstance().getSchemesManager();
    }

    private JPanel createExpandByPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"templates.dialog.shortcut.chooser.label", (Object[])new Object[0])), gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.insets = new Insets(0, 4, 0, 0);
        this.myExpandByCombo = new ComboBox();
        panel.add((Component)this.myExpandByCombo, gbConstraints);
        this.myOpenKeymapLabel = new HyperlinkLabel("Change");
        gbConstraints.gridx = 2;
        panel.add((Component)this.myOpenKeymapLabel, gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 1.0;
        panel.add((Component)new JPanel(), gbConstraints);
        panel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.myExpandByCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TemplateListPanel.this.myOpenKeymapLabel.setVisible(TemplateListPanel.this.myExpandByCombo.getSelectedItem() == TemplateListPanel.CUSTOM);
            }
        });
        for (String s : (String[])ContainerUtil.ar((Object[])new String[]{SPACE, TAB, ENTER, CUSTOM})) {
            this.myExpandByCombo.addItem(s);
        }
        this.myExpandByCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == TemplateListPanel.CUSTOM) {
                    Shortcut[] shortcuts = this.getCurrentCustomShortcuts();
                    String shortcutText = shortcuts.length == 0 ? "" : KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
                    this.setText(StringUtil.isEmpty((String)shortcutText) ? "Custom..." : "Custom (" + shortcutText + ")");
                }
            }

            private Shortcut[] getCurrentCustomShortcuts() {
                Shortcut[] shortcuts;
                Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)TemplateListPanel.this.myOpenKeymapLabel));
                KeymapPanel keymapPanel = allSettings == null ? null : allSettings.find(KeymapPanel.class);
                Shortcut[] shortcutArray = shortcuts = keymapPanel == null ? null : keymapPanel.getCurrentShortcuts("ExpandLiveTemplateCustom");
                if (shortcuts == null) {
                    Shortcut[] shortcutArray2;
                    KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("ExpandLiveTemplateCustom");
                    if (shortcut == null) {
                        shortcutArray2 = Shortcut.EMPTY_ARRAY;
                    } else {
                        Shortcut[] shortcutArray3 = new Shortcut[1];
                        shortcutArray2 = shortcutArray3;
                        shortcutArray3[0] = shortcut;
                    }
                    shortcuts = shortcutArray2;
                }
                return shortcuts;
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.isConfigurableOpenEvent(evt)) {
                    this.resizeComboToFitCustomShortcut();
                }
            }

            private boolean isConfigurableOpenEvent(PropertyChangeEvent evt) {
                return evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null;
            }

            private void resizeComboToFitCustomShortcut() {
                TemplateListPanel.this.myExpandByCombo.setPrototypeDisplayValue(null);
                TemplateListPanel.this.myExpandByCombo.setPrototypeDisplayValue(TemplateListPanel.CUSTOM);
            }
        });
        this.myOpenKeymapLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                KeymapPanel keymapPanel;
                Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)TemplateListPanel.this.myOpenKeymapLabel));
                KeymapPanel keymapPanel2 = keymapPanel = allSettings == null ? null : allSettings.find(KeymapPanel.class);
                if (keymapPanel != null) {
                    allSettings.select((Configurable)keymapPanel).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            keymapPanel.selectAction("ExpandLiveTemplateCustom");
                        }
                    });
                }
            }
        });
        return panel;
    }

    @Nullable
    private TemplateImpl getTemplate(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateImpl) {
            return (TemplateImpl)node.getUserObject();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getGroup(int row) {
        DefaultMutableTreeNode node;
        TreePath path = this.myTree.getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateGroup) {
            return (TemplateGroup)((Object)node.getUserObject());
        }
        return null;
    }

    private void moveTemplates(Map<TemplateImpl, DefaultMutableTreeNode> map, @NotNull String newGroupName) {
        if (newGroupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newGroupName", "com/intellij/codeInsight/template/impl/TemplateListPanel", "moveTemplates"));
        }
        ArrayList<TreePath> toSelect = new ArrayList<TreePath>();
        for (TemplateImpl template : map.keySet()) {
            DefaultMutableTreeNode oldTemplateNode = map.get(template);
            TemplateGroup oldGroup = this.getTemplateGroup(template.getGroupName());
            if (oldGroup != null) {
                oldGroup.removeElement(template);
            }
            template.setGroupName(newGroupName);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)oldTemplateNode.getParent();
            this.removeNodeFromParent(oldTemplateNode);
            if (parent.getChildCount() == 0) {
                this.removeNodeFromParent(parent);
            }
            toSelect.add(new TreePath(this.registerTemplate(template).getPath()));
        }
        this.myTree.getSelectionModel().clearSelection();
        for (TreePath path : toSelect) {
            this.myTree.expandPath(path.getParentPath());
            this.myTree.addSelectionPath(path);
            this.myTree.scrollRowToVisible(this.myTree.getRowForPath(path));
        }
    }

    @Nullable
    private DefaultMutableTreeNode getNode(int row) {
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getTemplateGroup(String groupName) {
        for (TemplateGroup group : this.myTemplateGroups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    private void addTemplate() {
        String defaultGroup = "user";
        DefaultMutableTreeNode node = this.getNode(this.getSingleSelectedIndex());
        if (node != null) {
            if (node.getUserObject() instanceof TemplateImpl) {
                defaultGroup = ((TemplateImpl)node.getUserObject()).getGroupName();
            } else if (node.getUserObject() instanceof TemplateGroup) {
                defaultGroup = ((TemplateGroup)((Object)node.getUserObject())).getName();
            }
        }
        this.addTemplate(new TemplateImpl(ABBREVIATION, "", defaultGroup));
    }

    public void addTemplate(TemplateImpl template) {
        this.myTemplateOptions.put(TemplateListPanel.getKey(template), template.createOptions());
        this.myTemplateContext.put(TemplateListPanel.getKey(template), template.createContext());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private static int getKey(TemplateImpl template) {
        return System.identityHashCode(template);
    }

    private void copyRow() {
        int selected = this.getSingleSelectedIndex();
        if (selected < 0) {
            return;
        }
        TemplateImpl orTemplate = this.getTemplate(selected);
        LOG.assertTrue(orTemplate != null);
        TemplateImpl template = orTemplate.copy();
        template.setKey(ABBREVIATION);
        this.myTemplateOptions.put(TemplateListPanel.getKey(template), new HashMap<TemplateOptionalProcessor, Boolean>(this.getTemplateOptions(orTemplate)));
        this.myTemplateContext.put(TemplateListPanel.getKey(template), this.getTemplateContext(orTemplate).createCopy());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private int getSingleSelectedIndex() {
        int[] rows = this.myTree.getSelectionRows();
        return rows != null && rows.length == 1 ? rows[0] : -1;
    }

    private void removeRows() {
        TreeNode toSelect = null;
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            TemplateImpl template;
            TemplateGroup templateGroup;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof TemplateGroup) {
                this.myTemplateGroups.remove(o);
                this.removeNodeFromParent(node);
                continue;
            }
            if (!(o instanceof TemplateImpl) || (templateGroup = this.getTemplateGroup((template = (TemplateImpl)o).getGroupName())) == null) continue;
            templateGroup.removeElement(template);
            toSelect = ((DefaultMutableTreeNode)node.getParent()).getChildAfter(node);
            this.removeNodeFromParent(node);
        }
        if (toSelect instanceof DefaultMutableTreeNode) {
            this.setSelectedNode((DefaultMutableTreeNode)toSelect);
        }
    }

    private JPanel createTable() {
        this.myTreeRoot = new CheckedTreeNode(null);
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof TemplateImpl) {
                    TemplateImpl template = (TemplateImpl)value;
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    JBColor fgColor = defaultTemplate != null && TemplateListPanel.this.templatesDiffer(template, defaultTemplate) ? JBColor.BLUE : null;
                    this.getTextRenderer().append(template.getKey(), new SimpleTextAttributes(0, (Color)fgColor));
                    String description = template.getDescription();
                    if (StringUtil.isNotEmpty((String)description)) {
                        this.getTextRenderer().append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else if (value instanceof TemplateGroup) {
                    this.getTextRenderer().append(((TemplateGroup)((Object)value)).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, this.myTreeRoot){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                Object obj = node.getUserObject();
                if (obj instanceof TemplateImpl) {
                    ((TemplateImpl)obj).setDeactivated(!node.isChecked());
                }
            }

            @Override
            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, new Convertor<TreePath, String>(){

                    public String convert(TreePath o) {
                        Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
                        if (object instanceof TemplateGroup) {
                            return ((TemplateGroup)((Object)object)).getName();
                        }
                        if (object instanceof TemplateImpl) {
                            TemplateImpl template = (TemplateImpl)object;
                            return StringUtil.notNullize((String)template.getKey()) + " " + StringUtil.notNullize((String)template.getDescription()) + " " + template.getTemplateText();
                        }
                        return "";
                    }
                }, true);
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TemplateSettings templateSettings = TemplateSettings.getInstance();
                TemplateImpl template = TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex());
                if (template != null) {
                    templateSettings.setLastSelectedTemplate(template.getGroupName(), template.getKey());
                } else {
                    templateSettings.setLastSelectedTemplate(null, null);
                    ((CardLayout)TemplateListPanel.this.myDetailsPanel.getLayout()).show(TemplateListPanel.this.myDetailsPanel, TemplateListPanel.NO_SELECTION);
                }
                if (TemplateListPanel.this.myUpdateNeeded) {
                    TemplateListPanel.this.myAlarm.cancelAllRequests();
                    TemplateListPanel.this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            TemplateListPanel.this.updateTemplateDetails(false, false);
                        }
                    }, 100);
                }
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.myCurrentTemplateEditor.focusKey();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.installPopup();
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider((Function)new NullableFunction<DnDActionInfo, DnDDragStartBean>(){

            public DnDDragStartBean fun(DnDActionInfo dnDActionInfo) {
                Point point = dnDActionInfo.getPoint();
                if (TemplateListPanel.this.myTree.getPathForLocation(point.x, point.y) == null) {
                    return null;
                }
                Map templates = TemplateListPanel.this.getSelectedTemplates();
                return !templates.isEmpty() ? new DnDDragStartBean((Object)templates) : null;
            }
        }).setDisposableParent((Disposable)this).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Set oldGroupNames = TemplateListPanel.getAllGroups((Map)event.getAttachedObject());
                TemplateGroup group = TemplateListPanel.this.getDropGroup(event);
                boolean differentGroup = group != null && !oldGroupNames.contains(group.getName());
                boolean possible = differentGroup && !TemplateListPanel.getSchemesManager().isShared((Scheme)group);
                event.setDropPossible(possible, differentGroup && !possible ? "Cannot modify a shared group" : "");
                return true;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                TemplateListPanel.this.moveTemplates((Map)event.getAttachedObject(), ((TemplateGroup)((Object)ObjectUtils.assertNotNull((Object)((Object)TemplateListPanel.this.getDropGroup(event))))).getName());
            }
        }).setImageProvider((Function)new NullableFunction<DnDActionInfo, DnDImage>(){

            public DnDImage fun(DnDActionInfo dnDActionInfo) {
                Point point = dnDActionInfo.getPoint();
                TreePath path = TemplateListPanel.this.myTree.getPathForLocation(point.x, point.y);
                return path == null ? null : new DnDImage((Image)DnDAwareTree.getDragImage((Tree)((TemplateListPanel)TemplateListPanel.this).myTree, (TreePath)path, (Point)point).first);
            }
        }).install();
        if (this.myTemplateGroups.size() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        }
        return this.initToolbar().createPanel();
    }

    private boolean templatesDiffer(@NotNull TemplateImpl template, @NotNull TemplateImpl defaultTemplate) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateListPanel", "templatesDiffer"));
        }
        if (defaultTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplate", "com/intellij/codeInsight/template/impl/TemplateListPanel", "templatesDiffer"));
        }
        template.parseSegments();
        defaultTemplate.parseSegments();
        return !template.equals(defaultTemplate) || !template.getVariables().equals(defaultTemplate.getVariables()) || !this.areOptionsEqual(template, defaultTemplate) || !this.getTemplateContext(template).getDifference(defaultTemplate.getTemplateContext()).isEmpty();
    }

    private ToolbarDecorator initToolbar() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TemplateListPanel.this.addTemplateOrGroup(button);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TemplateListPanel.this.removeRows();
            }
        }).disableDownAction().disableUpAction().addExtraAction(new AnActionButton("Copy", PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                TemplateListPanel.this.copyRow();
            }

            public void updateButton(AnActionEvent e) {
                e.getPresentation().setEnabled(TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex()) != null);
            }
        }).addExtraAction(new AnActionButton("Restore deleted defaults", AllIcons.General.TodoDefault){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$18", "actionPerformed"));
                }
                TemplateSettings.getInstance().reset();
                TemplateListPanel.this.reset();
            }

            public boolean isEnabled() {
                return super.isEnabled() && !TemplateSettings.getInstance().getDeletedTemplates().isEmpty();
            }
        });
        if (TemplateListPanel.getSchemesManager().isExportAvailable()) {
            decorator.addExtraAction(new AnActionButton("Share...", PlatformIcons.EXPORT_ICON){

                public void actionPerformed(AnActionEvent e) {
                    TemplateListPanel.this.exportCurrentGroup();
                }

                public void updateButton(AnActionEvent e) {
                    TemplateGroup group = TemplateListPanel.this.getGroup(TemplateListPanel.this.getSingleSelectedIndex());
                    e.getPresentation().setEnabled(group != null && !TemplateListPanel.getSchemesManager().isShared((Scheme)group));
                }
            });
        }
        if (TemplateListPanel.getSchemesManager().isImportAvailable()) {
            decorator.addExtraAction(new AnActionButton("Import Shared...", PlatformIcons.IMPORT_ICON){

                public void actionPerformed(AnActionEvent e) {
                    new SchemesToImportPopup<TemplateGroup, TemplateGroup>((Component)TemplateListPanel.this){

                        @Override
                        protected void onSchemeSelected(TemplateGroup scheme) {
                            for (TemplateImpl newTemplate : scheme.getElements()) {
                                for (TemplateImpl existingTemplate : TemplateListPanel.this.collectAllTemplates()) {
                                    if (!existingTemplate.getKey().equals(newTemplate.getKey())) continue;
                                    Messages.showMessageDialog((Component)TemplateListPanel.this, (String)CodeInsightBundle.message((String)"dialog.edit.template.error.already.exists", (Object[])new Object[]{existingTemplate.getKey(), existingTemplate.getGroupName()}), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                                    return;
                                }
                            }
                            TemplateListPanel.this.insertNewGroup(scheme);
                            for (TemplateImpl template : scheme.getElements()) {
                                TemplateListPanel.this.registerTemplate(template);
                            }
                        }
                    }.show(TemplateListPanel.getSchemesManager(), TemplateListPanel.this.myTemplateGroups);
                }
            });
        }
        return decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
    }

    private void addTemplateOrGroup(AnActionButton button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new DumbAwareAction("Live Template"){

            public void actionPerformed(AnActionEvent e) {
                TemplateListPanel.this.addTemplate();
            }
        });
        group.add((AnAction)new DumbAwareAction("Template Group..."){

            public void actionPerformed(AnActionEvent e) {
                String newName = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)"Enter the new group name:", (String)"Create New Group", null, (String)"", (InputValidator)new TemplateGroupInputValidator(null));
                if (newName != null) {
                    TemplateGroup newGroup = new TemplateGroup(newName);
                    TemplateListPanel.this.setSelectedNode(TemplateListPanel.this.insertNewGroup(newGroup));
                }
            }
        });
        DataContext context = DataManager.getInstance().getDataContext((Component)button.getContextComponent());
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup.show(button.getPreferredPopupPoint());
    }

    @Nullable
    private TemplateGroup getDropGroup(DnDEvent event) {
        Point point = event.getPointOn((Component)((Object)this.myTree));
        return this.getGroup(this.myTree.getRowForLocation(point.x, point.y));
    }

    private void installPopup() {
        final DumbAwareAction rename = new DumbAwareAction("Rename"){

            public void update(AnActionEvent e) {
                int selected = TemplateListPanel.this.getSingleSelectedIndex();
                TemplateGroup templateGroup = TemplateListPanel.this.getGroup(selected);
                boolean enabled = templateGroup != null;
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                TemplateListPanel.this.renameGroup();
            }
        };
        rename.registerCustomShortcutSet(ActionManager.getInstance().getAction("RenameElement").getShortcutSet(), (JComponent)((Object)this.myTree));
        final DefaultActionGroup move = new DefaultActionGroup("Move", true){

            public void update(AnActionEvent e) {
                final Map templates = TemplateListPanel.this.getSelectedTemplates();
                boolean enabled = !templates.isEmpty();
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                if (enabled) {
                    Set oldGroups = TemplateListPanel.getAllGroups(templates);
                    this.removeAll();
                    SchemesManager<TemplateGroup, TemplateGroup> schemesManager = TemplateSettings.getInstance().getSchemesManager();
                    for (TemplateGroup group : TemplateListPanel.this.getTemplateGroups()) {
                        final String newGroupName = group.getName();
                        if (oldGroups.contains(newGroupName) || schemesManager.isShared((Scheme)group)) continue;
                        this.add((AnAction)new DumbAwareAction(newGroupName){

                            public void actionPerformed(AnActionEvent e) {
                                TemplateListPanel.this.moveTemplates(templates, newGroupName);
                            }
                        });
                    }
                    this.addSeparator();
                    this.add((AnAction)new DumbAwareAction("New group..."){

                        public void actionPerformed(AnActionEvent e) {
                            String newName = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)"Enter the new group name:", (String)"Move to a New Group", null, (String)"", (InputValidator)new TemplateGroupInputValidator(null));
                            if (newName != null) {
                                TemplateListPanel.this.moveTemplates(templates, newName);
                            }
                        }
                    });
                }
            }
        };
        final DumbAwareAction changeContext = new DumbAwareAction("Change context..."){

            public void update(AnActionEvent e) {
                boolean enabled = !TemplateListPanel.this.getSelectedTemplates().isEmpty();
                e.getPresentation().setEnabled(enabled);
                super.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                Map templates = TemplateListPanel.this.getSelectedTemplates();
                TemplateContext context = new TemplateContext();
                JPanel contextPanel = LiveTemplateSettingsEditor.createPopupContextPanel(EmptyRunnable.INSTANCE, context);
                DialogBuilder builder = new DialogBuilder((Component)TemplateListPanel.this);
                builder.setCenterPanel((JComponent)contextPanel);
                builder.setTitle("Change Context Type For Selected Templates");
                int result = builder.show();
                if (result == 0) {
                    for (TemplateImpl template : templates.keySet()) {
                        TemplateListPanel.this.myTemplateContext.put(TemplateListPanel.getKey(template), context);
                    }
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }
        };
        final DumbAwareAction revert = new DumbAwareAction("Restore defaults", "Restore default setting for the selected templates", null){

            public void update(AnActionEvent e) {
                boolean enabled = false;
                Map templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null || !TemplateListPanel.this.templatesDiffer(template, defaultTemplate)) continue;
                    enabled = true;
                }
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(AnActionEvent e) {
                Map templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null) continue;
                    TemplateListPanel.this.myTemplateOptions.put(TemplateListPanel.getKey(template), defaultTemplate.createOptions());
                    TemplateListPanel.this.myTemplateContext.put(TemplateListPanel.getKey(template), defaultTemplate.createContext());
                    template.resetFrom(defaultTemplate);
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }
        };
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)rename);
                group.add((AnAction)move);
                group.add((AnAction)changeContext);
                group.add((AnAction)revert);
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(comp, x, y);
            }
        });
    }

    private static Set<String> getAllGroups(Map<TemplateImpl, DefaultMutableTreeNode> templates) {
        HashSet<String> oldGroups = new HashSet<String>();
        for (TemplateImpl template : templates.keySet()) {
            oldGroups.add(template.getGroupName());
        }
        return oldGroups;
    }

    private Map<TemplateImpl, DefaultMutableTreeNode> getSelectedTemplates() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<TemplateImpl, DefaultMutableTreeNode> templates = new LinkedHashMap<TemplateImpl, DefaultMutableTreeNode>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (!(o instanceof TemplateImpl)) {
                return Collections.emptyMap();
            }
            templates.put((TemplateImpl)o, node);
        }
        return templates;
    }

    private void renameGroup() {
        int selected = this.getSingleSelectedIndex();
        TemplateGroup templateGroup = this.getGroup(selected);
        if (templateGroup == null) {
            return;
        }
        String oldName = templateGroup.getName();
        String newName = Messages.showInputDialog((Component)((Object)this.myTree), (String)"Enter the new group name:", (String)"Rename", null, (String)oldName, (InputValidator)new TemplateGroupInputValidator(oldName));
        if (newName != null && !newName.equals(oldName)) {
            templateGroup.setName(newName);
            ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(this.getNode(selected));
        }
    }

    private void updateTemplateDetails(boolean focusKey, boolean forceReload) {
        int selected = this.getSingleSelectedIndex();
        CardLayout layout = (CardLayout)this.myDetailsPanel.getLayout();
        if (selected < 0 || this.getTemplate(selected) == null) {
            layout.show(this.myDetailsPanel, NO_SELECTION);
        } else {
            TemplateImpl newTemplate = this.getTemplate(selected);
            if (this.myCurrentTemplateEditor == null || forceReload || this.myCurrentTemplateEditor.getTemplate() != newTemplate) {
                if (this.myCurrentTemplateEditor != null) {
                    this.myCurrentTemplateEditor.dispose();
                }
                this.createTemplateEditor(newTemplate, (String)this.myExpandByCombo.getSelectedItem(), this.getTemplateOptions(newTemplate), this.getTemplateContext(newTemplate));
                this.myCurrentTemplateEditor.resetUi();
                if (focusKey) {
                    this.myCurrentTemplateEditor.focusKey();
                }
            }
            layout.show(this.myDetailsPanel, TEMPLATE_SETTINGS);
        }
    }

    private CheckedTreeNode registerTemplate(TemplateImpl template) {
        TemplateGroup newGroup = this.getTemplateGroup(template.getGroupName());
        if (newGroup == null) {
            newGroup = new TemplateGroup(template.getGroupName());
            this.insertNewGroup(newGroup);
        }
        if (!newGroup.contains(template)) {
            newGroup.addElement(template);
        }
        CheckedTreeNode node = new CheckedTreeNode((Object)template);
        node.setChecked(!template.isDeactivated());
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.myTreeRoot.getFirstChild();
        while (child != null) {
            if (((TemplateGroup)((Object)child.getUserObject())).getName().equals(template.getGroupName())) {
                int index = TemplateListPanel.getIndexToInsert(child, template.getKey());
                child.insert((MutableTreeNode)node, index);
                ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted(child, new int[]{index});
                this.setSelectedNode((DefaultMutableTreeNode)node);
            }
            child = (DefaultMutableTreeNode)this.myTreeRoot.getChildAfter((TreeNode)child);
        }
        return node;
    }

    private DefaultMutableTreeNode insertNewGroup(TemplateGroup newGroup) {
        this.myTemplateGroups.add(newGroup);
        int index = TemplateListPanel.getIndexToInsert((DefaultMutableTreeNode)this.myTreeRoot, newGroup.getName());
        CheckedTreeNode groupNode = new CheckedTreeNode((Object)newGroup);
        this.myTreeRoot.insert((MutableTreeNode)groupNode, index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myTreeRoot, new int[]{index});
        return groupNode;
    }

    private static int getIndexToInsert(DefaultMutableTreeNode parent, String key) {
        if (parent.getChildCount() == 0) {
            return 0;
        }
        int res = 0;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getFirstChild();
        while (child != null) {
            String key1;
            Object o = child.getUserObject();
            String string = key1 = o instanceof TemplateImpl ? ((TemplateImpl)o).getKey() : ((TemplateGroup)((Object)o)).getName();
            if (key1.compareToIgnoreCase(key) > 0) {
                return res;
            }
            ++res;
            child = (DefaultMutableTreeNode)parent.getChildAfter(child);
        }
        return res;
    }

    private void setSelectedNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.myTree.expandPath(path.getParentPath());
        int row = this.myTree.getRowForPath(path);
        this.myTree.setSelectionRow(row);
        this.myTree.scrollRowToVisible(row);
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void initTemplates(List<TemplateGroup> groups, String lastSelectedGroup, String lastSelectedKey) {
        this.myTreeRoot.removeAllChildren();
        this.myTemplateGroups.clear();
        for (TemplateGroup group : groups) {
            this.myTemplateGroups.add((TemplateGroup)group.copy());
        }
        for (TemplateGroup group : this.myTemplateGroups) {
            CheckedTreeNode groupNode = new CheckedTreeNode((Object)group);
            this.addTemplateNodes(group, groupNode);
            this.myTreeRoot.add((MutableTreeNode)groupNode);
        }
        this.fireStructureChange();
        this.selectTemplate(lastSelectedGroup, lastSelectedKey);
    }

    private void selectTemplate(final String lastSelectedGroup, final String lastSelectedKey) {
        TreeUtil.traverseDepth((TreeNode)this.myTreeRoot, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                Object o = ((DefaultMutableTreeNode)node).getUserObject();
                if (lastSelectedKey == null && o instanceof TemplateGroup && Comparing.equal((String)lastSelectedGroup, (String)((TemplateGroup)((Object)o)).getName()) || o instanceof TemplateImpl && Comparing.equal((String)lastSelectedKey, (String)((TemplateImpl)o).getKey()) && Comparing.equal((String)lastSelectedGroup, (String)((TemplateImpl)o).getGroupName())) {
                    TemplateListPanel.this.setSelectedNode((DefaultMutableTreeNode)node);
                    return false;
                }
                return true;
            }
        });
    }

    private void fireStructureChange() {
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged((TreeNode)this.myTreeRoot);
    }

    private void addTemplateNodes(TemplateGroup group, CheckedTreeNode groupNode) {
        ArrayList templates = new ArrayList(group.getElements());
        Collections.sort(templates, TEMPLATE_COMPARATOR);
        for (TemplateImpl template : templates) {
            this.myTemplateOptions.put(TemplateListPanel.getKey(template), template.createOptions());
            this.myTemplateContext.put(TemplateListPanel.getKey(template), template.createContext());
            CheckedTreeNode node = new CheckedTreeNode((Object)template);
            node.setChecked(!template.isDeactivated());
            groupNode.add((MutableTreeNode)node);
        }
    }

    static {
        MOCK_TEMPLATE.setString("");
        SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
        TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
        ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
        LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateListPanel");
    }

    private class TemplateGroupInputValidator
    implements InputValidator {
        private final String myOldName;

        public TemplateGroupInputValidator(String oldName) {
            this.myOldName = oldName;
        }

        public boolean checkInput(String inputString) {
            return StringUtil.isNotEmpty((String)inputString) && (TemplateListPanel.this.getTemplateGroup(inputString) == null || inputString.equals(this.myOldName));
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }
}

