/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.AbstractBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.codeInsight.template.impl.ExportableTemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateSettings", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class TemplateSettings
implements PersistentStateComponent<Element>,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateSettings");
    @NonNls
    public static final String USER_GROUP_NAME = "user";
    @NonNls
    private static final String TEMPLATE_SET = "templateSet";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String TEMPLATE = "template";
    @NonNls
    private static final String DELETED_TEMPLATES = "deleted_templates";
    private final List<TemplateKey> myDeletedTemplates = new ArrayList<TemplateKey>();
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    public static final char ENTER_CHAR = '\n';
    public static final char DEFAULT_CHAR = 'D';
    public static final char CUSTOM_CHAR = 'C';
    @NonNls
    private static final String SPACE = "SPACE";
    @NonNls
    private static final String TAB = "TAB";
    @NonNls
    private static final String ENTER = "ENTER";
    @NonNls
    private static final String CUSTOM = "CUSTOM";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String EXPRESSION = "expression";
    @NonNls
    private static final String DEFAULT_VALUE = "defaultValue";
    @NonNls
    private static final String ALWAYS_STOP_AT = "alwaysStopAt";
    @NonNls
    private static final String CONTEXT = "context";
    @NonNls
    private static final String TO_REFORMAT = "toReformat";
    @NonNls
    private static final String TO_SHORTEN_FQ_NAMES = "toShortenFQNames";
    @NonNls
    private static final String USE_STATIC_IMPORT = "useStaticImport";
    @NonNls
    private static final String DEFAULT_SHORTCUT = "defaultShortcut";
    @NonNls
    private static final String DEACTIVATED = "deactivated";
    @NonNls
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String TEMPLATES_CONFIG_FOLDER = "templates";
    private final MultiMap<String, TemplateImpl> myTemplates = MultiMap.createLinked();
    private final Map<String, Template> myTemplatesById = new LinkedHashMap<String, Template>();
    private final Map<TemplateKey, TemplateImpl> myDefaultTemplates = new LinkedHashMap<TemplateKey, TemplateImpl>();
    private int myMaxKeyLength = 0;
    private char myDefaultShortcutChar = (char)9;
    private final SchemesManager<TemplateGroup, TemplateGroup> mySchemesManager;
    private static final String FILE_SPEC = "$ROOT_CONFIG$/templates";
    private TemplateKey myLastSelectedTemplate;

    public TemplateSettings(SchemesManagerFactory schemesManagerFactory) {
        BaseSchemeProcessor<TemplateGroup> processor = new BaseSchemeProcessor<TemplateGroup>(){

            @Nullable
            public TemplateGroup readScheme(@NotNull Document schemeContent) throws InvalidDataException, IOException, JDOMException {
                if (schemeContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeContent", "com/intellij/codeInsight/template/impl/TemplateSettings$1", "readScheme"));
                }
                return TemplateSettings.this.readTemplateFile(schemeContent, schemeContent.getRootElement().getAttributeValue(TemplateSettings.GROUP), false, false, ((Object)((Object)this)).getClass().getClassLoader());
            }

            public boolean shouldBeSaved(@NotNull TemplateGroup template) {
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TemplateSettings.TEMPLATE, "com/intellij/codeInsight/template/impl/TemplateSettings$1", "shouldBeSaved"));
                }
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(t)) continue;
                    return true;
                }
                return false;
            }

            public Element writeScheme(@NotNull TemplateGroup template) throws WriteExternalException {
                if (template == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TemplateSettings.TEMPLATE, "com/intellij/codeInsight/template/impl/TemplateSettings$1", "writeScheme"));
                }
                Element templateSetElement = new Element(TemplateSettings.TEMPLATE_SET);
                templateSetElement.setAttribute(TemplateSettings.GROUP, template.getName());
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(t)) continue;
                    TemplateSettings.this.saveTemplate(t, templateSetElement);
                }
                return templateSetElement;
            }

            public void initScheme(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/codeInsight/template/impl/TemplateSettings$1", "initScheme"));
                }
                List templates = scheme.getElements();
                for (TemplateImpl template : templates) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            public void onSchemeAdded(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/codeInsight/template/impl/TemplateSettings$1", "onSchemeAdded"));
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            public void onSchemeDeleted(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/codeInsight/template/impl/TemplateSettings$1", "onSchemeDeleted"));
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.removeTemplate(template);
                }
            }
        };
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)processor, RoamingType.PER_USER);
        this.loadTemplates();
    }

    private boolean differsFromDefault(TemplateImpl t) {
        TemplateImpl def = this.getDefaultTemplate(t);
        if (def == null) {
            return true;
        }
        return !t.equals(def) || !t.contextsEqual(def);
    }

    @Nullable
    public TemplateImpl getDefaultTemplate(TemplateImpl t) {
        return this.myDefaultTemplates.get(TemplateKey.keyOf(t));
    }

    @NotNull
    public File[] getExportFiles() {
        File exportableSettingsFile = new File(PathManager.getOptionsPath() + File.separator + "template.settings.xml");
        File[] fileArray = new File[]{TemplateSettings.getTemplateDirectory(true), exportableSettingsFile};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateSettings", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = CodeInsightBundle.message((String)"templates.export.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateSettings", "getPresentableName"));
        }
        return string;
    }

    public static TemplateSettings getInstance() {
        return (TemplateSettings)ServiceManager.getService(TemplateSettings.class);
    }

    public void loadState(Element parentNode) {
        Element element = parentNode.getChild(DEFAULT_SHORTCUT);
        if (element != null) {
            String shortcut = element.getAttributeValue(SHORTCUT);
            this.myDefaultShortcutChar = (char)(TAB.equals(shortcut) ? 9 : (ENTER.equals(shortcut) ? 10 : (CUSTOM.equals(shortcut) ? 67 : 32)));
        }
        ExportableTemplateSettings exportableSettings = (ExportableTemplateSettings)ServiceManager.getService(ExportableTemplateSettings.class);
        assert (exportableSettings != null) : "Can't find required ExportableTemplateSettings service.";
        exportableSettings.setParentSettings(this);
        if (exportableSettings.isLoaded()) {
            this.myDeletedTemplates.addAll(exportableSettings.getDeletedKeys());
        } else {
            Element deleted = parentNode.getChild(DELETED_TEMPLATES);
            if (deleted != null) {
                List children = deleted.getChildren();
                for (Object aChildren : children) {
                    Element child = (Element)aChildren;
                    this.myDeletedTemplates.add(new TemplateKey(child.getAttributeValue(GROUP), child.getAttributeValue(NAME)));
                }
            }
        }
        for (TemplateKey templateKey : this.myDeletedTemplates) {
            if (templateKey.groupName == null) {
                ArrayList templates = new ArrayList(this.myTemplates.get((Object)templateKey.key));
                for (TemplateImpl template : templates) {
                    this.removeTemplate(template);
                }
                continue;
            }
            TemplateImpl toDelete = this.getTemplate(templateKey.key, templateKey.groupName);
            if (toDelete == null) continue;
            this.removeTemplate(toDelete);
        }
    }

    public Element getState() {
        Element parentNode = new Element("TemplateSettings");
        Element element = new Element(DEFAULT_SHORTCUT);
        element.setAttribute(SHORTCUT, this.myDefaultShortcutChar == '\t' ? TAB : (this.myDefaultShortcutChar == '\n' ? ENTER : (this.myDefaultShortcutChar == 'C' ? CUSTOM : SPACE)));
        parentNode.addContent(element);
        return parentNode;
    }

    @Nullable
    public String getLastSelectedTemplateKey() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.key : null;
    }

    @Nullable
    public String getLastSelectedTemplateGroup() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.groupName : null;
    }

    public void setLastSelectedTemplate(@Nullable String group, @Nullable String key) {
        this.myLastSelectedTemplate = group == null ? null : new TemplateKey(group, key);
    }

    public Collection<? extends TemplateImpl> getTemplatesAsList() {
        return this.myTemplates.values();
    }

    public TemplateImpl[] getTemplates() {
        Collection all = this.myTemplates.values();
        return all.toArray(new TemplateImpl[all.size()]);
    }

    public char getDefaultShortcutChar() {
        return this.myDefaultShortcutChar;
    }

    public void setDefaultShortcutChar(char defaultShortcutChar) {
        this.myDefaultShortcutChar = defaultShortcutChar;
    }

    public Collection<TemplateImpl> getTemplates(@NonNls String key) {
        return this.myTemplates.get((Object)key);
    }

    @Nullable
    public TemplateImpl getTemplate(@NonNls String key, String group) {
        Collection templates = this.myTemplates.get((Object)key);
        for (TemplateImpl template : templates) {
            if (!template.getGroupName().equals(group)) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateById(@NonNls String id) {
        return this.myTemplatesById.get(id);
    }

    public int getMaxKeyLength() {
        return this.myMaxKeyLength;
    }

    public void addTemplate(Template template) {
        this.clearPreviouslyRegistered(template);
        this.addTemplateImpl(template);
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group = (TemplateGroup)this.mySchemesManager.findSchemeByName(groupName);
        if (group == null) {
            group = new TemplateGroup(groupName);
            this.mySchemesManager.addNewScheme((Scheme)group, true);
        }
        group.addElement(templateImpl);
    }

    private void clearPreviouslyRegistered(Template template) {
        TemplateImpl existing = this.getTemplate(template.getKey(), ((TemplateImpl)template).getGroupName());
        if (existing != null) {
            LOG.info("Template with key " + template.getKey() + " and id " + template.getId() + " already registered");
            TemplateGroup group = (TemplateGroup)this.mySchemesManager.findSchemeByName(existing.getGroupName());
            if (group != null) {
                group.removeElement(existing);
                if (group.isEmpty()) {
                    this.mySchemesManager.removeScheme((Scheme)group);
                }
            }
            this.myTemplates.remove((Object)template.getKey(), (Object)existing);
        }
    }

    private void addTemplateImpl(Template template) {
        TemplateImpl templateImpl = (TemplateImpl)template;
        if (this.getTemplate(templateImpl.getKey(), templateImpl.getGroupName()) == null) {
            this.myTemplates.putValue((Object)template.getKey(), (Object)templateImpl);
        }
        this.myMaxKeyLength = Math.max(this.myMaxKeyLength, template.getKey().length());
        this.myDeletedTemplates.remove(TemplateKey.keyOf((TemplateImpl)template));
    }

    private void addTemplateById(Template template) {
        String id;
        if (!this.myTemplatesById.containsKey(template.getId()) && (id = template.getId()) != null) {
            this.myTemplatesById.put(id, template);
        }
    }

    public void removeTemplate(Template template) {
        this.myTemplates.remove((Object)template.getKey(), (Object)((TemplateImpl)template));
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group = (TemplateGroup)this.mySchemesManager.findSchemeByName(groupName);
        if (group != null) {
            group.removeElement((TemplateImpl)template);
            if (group.isEmpty()) {
                this.mySchemesManager.removeScheme((Scheme)group);
            }
        }
    }

    private TemplateImpl addTemplate(String key, String string, String group, String description, String shortcut, boolean isDefault, String id) {
        TemplateImpl template = new TemplateImpl(key, string, group);
        template.setId(id);
        template.setDescription(description);
        if (TAB.equals(shortcut)) {
            template.setShortcutChar('\t');
        } else if (ENTER.equals(shortcut)) {
            template.setShortcutChar('\n');
        } else if (SPACE.equals(shortcut)) {
            template.setShortcutChar(' ');
        } else {
            template.setShortcutChar('D');
        }
        if (isDefault) {
            this.myDefaultTemplates.put(TemplateKey.keyOf(template), template);
        }
        return template;
    }

    @Nullable
    private static File getTemplateDirectory(boolean toCreate) {
        String directoryPath = PathManager.getConfigPath() + File.separator + TEMPLATES_CONFIG_FOLDER;
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!toCreate) {
                return null;
            }
            if (!directory.mkdir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cannot create directory: " + directory.getAbsolutePath());
                }
                return null;
            }
        }
        return directory;
    }

    private void loadTemplates() {
        Collection loaded = this.mySchemesManager.loadSchemes();
        for (TemplateGroup group : loaded) {
            List templates = group.getElements();
            for (TemplateImpl template : templates) {
                this.addTemplateImpl(template);
            }
        }
        this.loadDefaultLiveTemplates();
    }

    private void loadDefaultLiveTemplates() {
        try {
            for (DefaultLiveTemplatesProvider provider : (DefaultLiveTemplatesProvider[])Extensions.getExtensions(DefaultLiveTemplatesProvider.EP_NAME)) {
                for (String defTemplate : provider.getDefaultLiveTemplateFiles()) {
                    this.readDefTemplate(provider, defTemplate, true);
                }
                try {
                    String[] hidden = provider.getHiddenLiveTemplateFiles();
                    if (hidden == null) continue;
                    for (String s : hidden) {
                        this.readDefTemplate(provider, s, false);
                    }
                }
                catch (AbstractMethodError ignore) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void readDefTemplate(DefaultLiveTemplatesProvider provider, String defTemplate, boolean registerTemplate) throws JDOMException, InvalidDataException, IOException {
        TemplateGroup group;
        String templateName = TemplateSettings.getDefaultTemplateName(defTemplate);
        InputStream inputStream = DecodeDefaultsUtil.getDefaultsInputStream(provider, defTemplate);
        if (inputStream != null && (group = this.readTemplateFile(JDOMUtil.loadDocument((InputStream)inputStream), templateName, true, registerTemplate, provider.getClass().getClassLoader())) != null && group.getReplace() != null) {
            Collection templates = this.myTemplates.get((Object)group.getReplace());
            for (TemplateImpl template : templates) {
                this.removeTemplate(template);
            }
        }
    }

    private static String getDefaultTemplateName(String defTemplate) {
        return defTemplate.substring(defTemplate.lastIndexOf("/") + 1);
    }

    @Nullable
    private TemplateGroup readTemplateFile(Document document, @NonNls String defGroupName, boolean isDefault, boolean registerTemplate, ClassLoader classLoader) throws InvalidDataException {
        TemplateGroup existingScheme;
        if (document == null) {
            throw new InvalidDataException();
        }
        Element root = document.getRootElement();
        if (root == null || !TEMPLATE_SET.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String groupName = root.getAttributeValue(GROUP);
        if (groupName == null || groupName.isEmpty()) {
            groupName = defGroupName;
        }
        TemplateGroup result = new TemplateGroup(groupName, root.getAttributeValue("REPLACE"));
        LinkedHashMap<String, TemplateImpl> created = new LinkedHashMap<String, TemplateImpl>();
        Iterator<Object> i$ = root.getChildren(TEMPLATE).iterator();
        while (i$.hasNext()) {
            boolean defaultTemplateModified;
            Element o1;
            Element element = o1 = (Element)i$.next();
            TemplateImpl template = this.readTemplateFromElement(isDefault, groupName, element, classLoader);
            TemplateImpl existing = this.getTemplate(template.getKey(), template.getGroupName());
            boolean bl = defaultTemplateModified = isDefault && (this.myDeletedTemplates.contains(TemplateKey.keyOf(template)) || this.myTemplatesById.containsKey(template.getId()) || existing != null);
            if (!defaultTemplateModified) {
                created.put(template.getKey(), template);
            }
            if (!isDefault || existing == null) continue;
            existing.getTemplateContext().setDefaultContext(template.getTemplateContext());
        }
        if (registerTemplate && (existingScheme = (TemplateGroup)this.mySchemesManager.findSchemeByName(result.getName())) != null) {
            result = existingScheme;
        }
        for (TemplateImpl template : created.values()) {
            if (registerTemplate) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
            this.addTemplateById(template);
            result.addElement(template);
        }
        if (registerTemplate && (existingScheme = (TemplateGroup)this.mySchemesManager.findSchemeByName(result.getName())) == null && !result.isEmpty()) {
            this.mySchemesManager.addNewScheme((Scheme)result, false);
        }
        return result.isEmpty() ? null : result;
    }

    private TemplateImpl readTemplateFromElement(boolean isDefault, String groupName, Element element, ClassLoader classLoader) throws InvalidDataException {
        String description;
        String name = element.getAttributeValue(NAME);
        String value = element.getAttributeValue(VALUE);
        String resourceBundle = element.getAttributeValue(RESOURCE_BUNDLE);
        String key = element.getAttributeValue(KEY);
        String id = element.getAttributeValue(ID);
        if (resourceBundle != null && key != null) {
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            ResourceBundle bundle = AbstractBundle.getResourceBundle((String)resourceBundle, (ClassLoader)classLoader);
            description = bundle.getString(key);
        } else {
            description = element.getAttributeValue(DESCRIPTION);
        }
        String shortcut = element.getAttributeValue(SHORTCUT);
        TemplateImpl template = this.addTemplate(name, value, groupName, description, shortcut, isDefault, id);
        template.setToReformat(Boolean.parseBoolean(element.getAttributeValue(TO_REFORMAT)));
        template.setToShortenLongNames(Boolean.parseBoolean(element.getAttributeValue(TO_SHORTEN_FQ_NAMES)));
        template.setDeactivated(Boolean.parseBoolean(element.getAttributeValue(DEACTIVATED)));
        String useStaticImport = element.getAttributeValue(USE_STATIC_IMPORT);
        if (useStaticImport != null) {
            template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, Boolean.parseBoolean(useStaticImport));
        }
        Iterator i$ = element.getChildren(VARIABLE).iterator();
        while (i$.hasNext()) {
            Element o;
            Element e = o = (Element)i$.next();
            String variableName = e.getAttributeValue(NAME);
            String expression = e.getAttributeValue(EXPRESSION);
            String defaultValue = e.getAttributeValue(DEFAULT_VALUE);
            boolean isAlwaysStopAt = Boolean.parseBoolean(e.getAttributeValue(ALWAYS_STOP_AT));
            template.addVariable(variableName, expression, defaultValue, isAlwaysStopAt);
        }
        Element context = element.getChild(CONTEXT);
        if (context != null) {
            template.getTemplateContext().readTemplateContext(context);
        }
        return template;
    }

    private void saveTemplate(TemplateImpl template, Element templateSetElement) {
        Element element = new Element(TEMPLATE);
        String id = template.getId();
        if (id != null) {
            element.setAttribute(ID, id);
        }
        element.setAttribute(NAME, template.getKey());
        element.setAttribute(VALUE, template.getString());
        if (template.getShortcutChar() == '\t') {
            element.setAttribute(SHORTCUT, TAB);
        } else if (template.getShortcutChar() == '\n') {
            element.setAttribute(SHORTCUT, ENTER);
        } else if (template.getShortcutChar() == ' ') {
            element.setAttribute(SHORTCUT, SPACE);
        }
        if (template.getDescription() != null) {
            element.setAttribute(DESCRIPTION, template.getDescription());
        }
        element.setAttribute(TO_REFORMAT, Boolean.toString(template.isToReformat()));
        element.setAttribute(TO_SHORTEN_FQ_NAMES, Boolean.toString(template.isToShortenLongNames()));
        if (template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE) != Template.getDefaultValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            element.setAttribute(USE_STATIC_IMPORT, Boolean.toString(template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)));
        }
        if (template.isDeactivated()) {
            element.setAttribute(DEACTIVATED, Boolean.toString(true));
        }
        for (int i = 0; i < template.getVariableCount(); ++i) {
            Element variableElement = new Element(VARIABLE);
            variableElement.setAttribute(NAME, template.getVariableNameAt(i));
            variableElement.setAttribute(EXPRESSION, template.getExpressionStringAt(i));
            variableElement.setAttribute(DEFAULT_VALUE, template.getDefaultValueStringAt(i));
            variableElement.setAttribute(ALWAYS_STOP_AT, Boolean.toString(template.isAlwaysStopAt(i)));
            element.addContent(variableElement);
        }
        try {
            Element contextElement = new Element(CONTEXT);
            TemplateImpl def = this.getDefaultTemplate(template);
            template.getTemplateContext().writeTemplateContext(contextElement, def == null ? null : def.getTemplateContext());
            element.addContent(contextElement);
        }
        catch (WriteExternalException ignore) {
            // empty catch block
        }
        templateSetElement.addContent(element);
    }

    public void setTemplates(List<TemplateGroup> newGroups) {
        this.myTemplates.clear();
        this.myDeletedTemplates.clear();
        for (TemplateImpl template : this.myDefaultTemplates.values()) {
            this.myDeletedTemplates.add(TemplateKey.keyOf(template));
        }
        this.mySchemesManager.clearAllSchemes();
        this.myMaxKeyLength = 0;
        for (TemplateGroup group : newGroups) {
            if (group.isEmpty()) continue;
            this.mySchemesManager.addNewScheme((Scheme)group, true);
            for (TemplateImpl template : group.getElements()) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
        }
    }

    public SchemesManager<TemplateGroup, TemplateGroup> getSchemesManager() {
        return this.mySchemesManager;
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.mySchemesManager.getAllSchemes();
    }

    public List<TemplateImpl> collectMatchingCandidates(String key, @Nullable Character shortcutChar, boolean hasArgument) {
        Collection<TemplateImpl> templates = this.getTemplates(key);
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : templates) {
            if (template.isDeactivated() || shortcutChar != null && this.getShortcutChar(template) != shortcutChar.charValue() || hasArgument && !template.hasArgument()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    public char getShortcutChar(TemplateImpl template) {
        char c = template.getShortcutChar();
        if (c == 'D') {
            return this.getDefaultShortcutChar();
        }
        return c;
    }

    public List<TemplateKey> getDeletedTemplates() {
        return this.myDeletedTemplates;
    }

    public void reset() {
        this.myDeletedTemplates.clear();
        this.loadDefaultLiveTemplates();
    }

    public static class TemplateKey {
        private String groupName;
        private String key;

        public TemplateKey() {
        }

        private TemplateKey(String groupName, String key) {
            this.groupName = groupName;
            this.key = key;
        }

        public static TemplateKey keyOf(TemplateImpl template) {
            return new TemplateKey(template.getGroupName(), template.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
                return false;
            }
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        public int hashCode() {
            int result = this.groupName != null ? this.groupName.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.getKey() + "@" + this.getGroupName();
        }
    }
}

