/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundPositionManager
extends PositionManagerEx {
    private static final Logger LOG = Logger.getInstance(CompoundPositionManager.class);
    private final ArrayList<PositionManager> myPositionManagers = new ArrayList();

    public CompoundPositionManager() {
    }

    public CompoundPositionManager(PositionManager manager) {
        this.appendPositionManager(manager);
    }

    public void appendPositionManager(PositionManager manager) {
        this.myPositionManagers.remove(manager);
        this.myPositionManagers.add(0, manager);
    }

    public SourcePosition getSourcePosition(Location location) {
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                return positionManager.getSourcePosition(location);
            }
            catch (NoDataException ignored) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            List list;
            try {
                list = positionManager.getAllClasses(classPosition);
            }
            catch (NoDataException ignored) {
                continue;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
            }
            return list;
        }
        List<ReferenceType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "getAllClasses"));
        }
        return list;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            List list;
            try {
                list = positionManager.locationsOfLine(type, position);
            }
            catch (NoDataException ignored) {
                continue;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (InternalException ignored) {
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/CompoundPositionManager", "locationsOfLine"));
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/CompoundPositionManager", "createPrepareRequest"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            try {
                return positionManager.createPrepareRequest(requestor, position);
            }
            catch (NoDataException ignored) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error((Throwable)((Object)e));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "createStackFrame"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                XStackFrame xStackFrame = ((PositionManagerEx)positionManager).createStackFrame(frame, debugProcess, location);
                if (xStackFrame == null) continue;
                return xStackFrame;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return null;
    }

    @Override
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/engine/CompoundPositionManager", "evaluateCondition"));
        }
        for (PositionManager positionManager : this.myPositionManagers) {
            if (!(positionManager instanceof PositionManagerEx)) continue;
            try {
                ThreeState result = ((PositionManagerEx)positionManager).evaluateCondition(context, frame, location, expression);
                if (result == ThreeState.UNSURE) continue;
                return result;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return ThreeState.UNSURE;
    }
}

