/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutableValidator {
    private static final Logger LOG = Logger.getInstance(ExecutableValidator.class);
    private static final NotificationGroup ourNotificationGroup = new NotificationGroup("External Executable Critical Failures", NotificationDisplayType.STICKY_BALLOON, true);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final NotificationsManager myNotificationManager;
    @NotNull
    private final String myNotificationErrorTitle;
    @NotNull
    private String myNotificationErrorDescription;

    public ExecutableValidator(@NotNull Project project, @NotNull String notificationErrorTitle, @NotNull String notificationErrorDescription) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        if (notificationErrorTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationErrorTitle", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        if (notificationErrorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationErrorDescription", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        this.myProject = project;
        this.myNotificationErrorTitle = notificationErrorTitle;
        this.myNotificationErrorDescription = notificationErrorDescription;
        this.myNotificationManager = NotificationsManager.getNotificationsManager();
    }

    protected abstract String getCurrentExecutable();

    @NotNull
    protected abstract String getConfigurableDisplayName();

    protected boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/execution/ExecutableValidator", "isExecutableValid"));
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(60000);
            boolean timeout = result.isTimeout();
            int exitCode = result.getExitCode();
            String stderr = result.getStderr();
            if (timeout) {
                LOG.warn("Validation of " + executable + " failed with a timeout");
            }
            if (exitCode != 0) {
                LOG.warn("Validation of " + executable + " failed with non-zero exit code: " + exitCode);
            }
            if (!stderr.isEmpty()) {
                LOG.warn("Validation of " + executable + " failed with a non-empty error output: " + stderr);
            }
            return !timeout && exitCode == 0 && stderr.isEmpty();
        }
        catch (Throwable t) {
            LOG.warn(t);
            return false;
        }
    }

    public void setNotificationErrorDescription(@NotNull String notificationErrorDescription) {
        if (notificationErrorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationErrorDescription", "com/intellij/execution/ExecutableValidator", "setNotificationErrorDescription"));
        }
        this.myNotificationErrorDescription = notificationErrorDescription;
    }

    private void showExecutableNotConfiguredNotification() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        LOG.info("Executable is not valid: " + this.getCurrentExecutable());
        if (((ExecutableNotValidNotification[])this.myNotificationManager.getNotificationsOfType(ExecutableNotValidNotification.class, this.myProject)).length == 0) {
            new ExecutableNotValidNotification().notify(this.myProject.isDefault() ? null : this.myProject);
        }
    }

    @NotNull
    private String prepareDescription() {
        String executable = this.getCurrentExecutable();
        if (executable.isEmpty()) {
            String string = String.format("<b>%s</b>%s <a href=''>Fix it.</a>", this.myNotificationErrorTitle, this.myNotificationErrorDescription);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutableValidator", "prepareDescription"));
            }
            return string;
        }
        String string = String.format("<b>%s:</b> <code>%s</code><br/>%s <a href=''>Fix it.</a>", this.myNotificationErrorTitle, executable, this.myNotificationErrorDescription);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutableValidator", "prepareDescription"));
        }
        return string;
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/execution/ExecutableValidator", "showSettingsAndExpireIfFixed"));
        }
        this.showSettings();
        if (this.isExecutableValid(this.getCurrentExecutable())) {
            notification.expire();
        }
    }

    protected void showSettings() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.getConfigurableDisplayName());
    }

    public boolean checkExecutableAndNotifyIfNeeded() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!this.isExecutableValid(this.getCurrentExecutable())) {
            this.showExecutableNotConfiguredNotification();
            return false;
        }
        return true;
    }

    public boolean checkExecutableAndShowMessageIfNeeded(@Nullable Component parentComponent) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!this.isExecutableValid(this.getCurrentExecutable())) {
            if (0 == this.showMessage(parentComponent)) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExecutableValidator.this.showSettings();
                    }
                });
            }
            return false;
        }
        return true;
    }

    private int showMessage(@Nullable Component parentComponent) {
        String okText = "Fix it";
        String cancelText = CommonBundle.getCancelButtonText();
        Icon icon = Messages.getErrorIcon();
        String title = this.myNotificationErrorTitle;
        String description = this.myNotificationErrorDescription;
        return parentComponent != null ? Messages.showOkCancelDialog((Component)parentComponent, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon) : Messages.showOkCancelDialog((Project)this.myProject, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon);
    }

    public boolean isExecutableValid() {
        return this.isExecutableValid(this.getCurrentExecutable());
    }

    private class ExecutableNotValidNotification
    extends Notification {
        private ExecutableNotValidNotification() {
            super(ourNotificationGroup.getDisplayId(), "", ExecutableValidator.this.prepareDescription(), NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification$1", "hyperlinkActivated"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification$1", "hyperlinkActivated"));
                    }
                    ExecutableValidator.this.showSettingsAndExpireIfFixed(notification);
                }
            });
        }
    }
}

