/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryImpl
extends LocalHistory
implements ApplicationComponent {
    private ChangeList myChangeList;
    private LocalHistoryFacade myVcs;
    private IdeaGateway myGateway;
    private LocalHistoryEventDispatcher myEventDispatcher;
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private Runnable myShutdownTask;

    public static LocalHistoryImpl getInstanceImpl() {
        return (LocalHistoryImpl)LocalHistoryImpl.getInstance();
    }

    public void initComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myShutdownTask = new Runnable(){

            @Override
            public void run() {
                LocalHistoryImpl.this.disposeComponent();
            }
        };
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutdownTask);
        this.initHistory();
        this.isInitialized.set(true);
    }

    protected void initHistory() {
        ChangeListStorage storage;
        try {
            storage = new ChangeListStorageImpl(this.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage = new InMemoryChangeListStorage();
        }
        this.myChangeList = new ChangeList(storage);
        this.myVcs = new LocalHistoryFacade(this.myChangeList);
        this.myGateway = new IdeaGateway();
        this.myEventDispatcher = new LocalHistoryEventDispatcher(this.myVcs, this.myGateway);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this.myEventDispatcher);
        VirtualFileManager fm = VirtualFileManager.getInstance();
        fm.addVirtualFileListener((VirtualFileListener)this.myEventDispatcher);
        fm.addVirtualFileManagerListener((VirtualFileManagerListener)this.myEventDispatcher);
        if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    LocalHistoryImpl.this.validateStorage();
                }
            });
        }
    }

    private void validateStorage() {
        if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LocalHistoryLog.LOG.info("Checking local history storage...");
            try {
                long before = Clock.getTime();
                this.myVcs.getChangeListInTests().getChangesInTests();
                LocalHistoryLog.LOG.info("Local history storage seems to be ok (took " + (Clock.getTime() - before) / 1000L + " sec)");
            }
            catch (Exception e) {
                LocalHistoryLog.LOG.error((Throwable)e);
            }
        }
    }

    public File getStorageDir() {
        return new File(this.getSystemPath(), "LocalHistory");
    }

    protected String getSystemPath() {
        return PathManager.getSystemPath();
    }

    public void disposeComponent() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        long period = (long)Registry.intValue((String)"localHistory.daysToKeep") * 1000L * 60L * 60L * 24L;
        VirtualFileManager fm = VirtualFileManager.getInstance();
        fm.removeVirtualFileListener((VirtualFileListener)this.myEventDispatcher);
        fm.removeVirtualFileManagerListener((VirtualFileManagerListener)this.myEventDispatcher);
        CommandProcessor.getInstance().removeCommandListener((CommandListener)this.myEventDispatcher);
        this.validateStorage();
        LocalHistoryLog.LOG.info("Purging local history...");
        this.myChangeList.purgeObsolete(period);
        this.validateStorage();
        this.myChangeList.close();
        LocalHistoryLog.LOG.info("Local history storage successfully closed.");
        ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutdownTask);
    }

    public void cleanupForNextTest() {
        this.disposeComponent();
        FileUtil.delete((File)this.getStorageDir());
        this.initComponent();
    }

    public LocalHistoryAction startAction(String name) {
        if (!this.isInitialized()) {
            return LocalHistoryAction.NULL;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.myEventDispatcher, name);
        a.start();
        return a;
    }

    public Label putUserLabel(Project p, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/history/integration/LocalHistoryImpl", "putUserLabel"));
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putUserLabel(name, this.getProjectId(p)));
    }

    private String getProjectId(Project p) {
        return p.getLocationHash();
    }

    public Label putSystemLabel(Project p, @NotNull String name, int color) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/history/integration/LocalHistoryImpl", "putSystemLabel"));
        }
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putSystemLabel(name, this.getProjectId(p), color));
    }

    private Label label(final LabelImpl impl) {
        return new Label(){

            public ByteContent getByteContent(final String path) {
                return (ByteContent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ByteContent>(){

                    public ByteContent compute() {
                        RootEntry root = LocalHistoryImpl.this.myGateway.createTransientRootEntryForPathOnly(path);
                        return impl.getByteContent(root, path);
                    }
                });
            }
        };
    }

    @Nullable
    public byte[] getByteContent(final VirtualFile f, final FileRevisionTimestampComparator c) {
        if (!this.isInitialized()) {
            return null;
        }
        if (!this.myGateway.areContentChangesVersioned(f)) {
            return null;
        }
        return (byte[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<byte[]>(){

            public byte[] compute() {
                return new ByteContentRetriever(LocalHistoryImpl.this.myGateway, LocalHistoryImpl.this.myVcs, f, c).getResult();
            }
        });
    }

    public boolean isUnderControl(VirtualFile f) {
        return this.isInitialized() && this.myGateway.isVersioned(f);
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("Local History" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/LocalHistoryImpl", "getComponentName"));
        }
        return "Local History";
    }

    @Nullable
    public LocalHistoryFacade getFacade() {
        return this.myVcs;
    }

    @Nullable
    public IdeaGateway getGateway() {
        return this.myGateway;
    }
}

