/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class QuickChangeKeymapAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeKeymapAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeKeymapAction", "fillActions"));
        }
        KeymapManagerEx manager = (KeymapManagerEx)KeymapManager.getInstance();
        Keymap current = manager.getActiveKeymap();
        for (Keymap keymap : manager.getAllKeymaps()) {
            this.addKeymapAction(group, manager, current, keymap, false);
        }
        Collection sharedSchemes = ((KeymapManagerEx)KeymapManagerEx.getInstance()).getSchemesManager().loadSharedSchemes();
        if (!sharedSchemes.isEmpty()) {
            group.add((AnAction)Separator.getInstance());
            for (SharedScheme sharedScheme : sharedSchemes) {
                this.addKeymapAction(group, manager, current, (Keymap)sharedScheme.getScheme(), true);
            }
        }
    }

    private void addKeymapAction(DefaultActionGroup group, final KeymapManagerEx manager, Keymap current, final Keymap keymap, final boolean addScheme) {
        group.add(new AnAction(keymap.getPresentableName(), "", keymap == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(AnActionEvent e) {
                if (addScheme) {
                    manager.getSchemesManager().addNewScheme((Scheme)keymap, false);
                }
                manager.setActiveKeymap(keymap);
            }
        });
    }

    protected boolean isEnabled() {
        return ((KeymapManagerEx)KeymapManager.getInstance()).getAllKeymaps().length > 1;
    }
}

