/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistenceComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApplicationUsagesCollector
extends UsagesCollector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.statistic.AbstractApplicationUsagesCollector");

    public void persistProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        try {
            Set<UsageDescriptor> projectUsages = this.getProjectUsages(project);
            this.persistProjectUsages(project, projectUsages);
        }
        catch (CollectUsagesException e) {
            LOG.info((Throwable)e);
        }
    }

    public void persistProjectUsages(@NotNull Project project, @NotNull Set<UsageDescriptor> usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        this.persistProjectUsages(project, usages, ApplicationStatisticsPersistenceComponent.getInstance());
    }

    public void persistProjectUsages(@NotNull Project project, @NotNull Set<UsageDescriptor> usages, @NotNull ApplicationStatisticsPersistence persistence) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "persistProjectUsages"));
        }
        persistence.persistUsages(this.getGroupId(), project, usages);
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages() {
        Set<UsageDescriptor> set = this.getApplicationUsages(ApplicationStatisticsPersistenceComponent.getInstance());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return set;
    }

    @NotNull
    public Set<UsageDescriptor> getApplicationUsages(@NotNull ApplicationStatisticsPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistence", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        HashMap result = new HashMap();
        for (Set<UsageDescriptor> usageDescriptors : persistence.getApplicationData(this.getGroupId()).values()) {
            for (UsageDescriptor usageDescriptor : usageDescriptors) {
                String key;
                Integer count = (Integer)result.get(key = usageDescriptor.getKey());
                result.put(key, count == null ? 1 : count + 1);
            }
        }
        Set set = ContainerUtil.map2Set(result.entrySet(), (Function)new Function<Map.Entry<String, Integer>, UsageDescriptor>(){

            public UsageDescriptor fun(Map.Entry<String, Integer> entry) {
                return new UsageDescriptor(entry.getKey(), entry.getValue());
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getApplicationUsages"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@Nullable Project project) throws CollectUsagesException {
        if (project != null) {
            Set<UsageDescriptor> projectUsages = this.getProjectUsages(project);
            this.persistProjectUsages(project, projectUsages);
        }
        Set<UsageDescriptor> set = this.getApplicationUsages();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/AbstractApplicationUsagesCollector", "getUsages"));
        }
        return set;
    }

    @NotNull
    public abstract Set<UsageDescriptor> getProjectUsages(@NotNull Project var1) throws CollectUsagesException;
}

