/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsStatisticsService
extends SettingsConnectionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.statistic.ideSettings.IdeSettingsUsagesCollector");
    private static final String FILE_NAME = "ide-settings-statistics.xml";
    private static final IdeSettingsStatisticsService myInstance = new IdeSettingsStatisticsService();
    private IdeSettingsDescriptor[] myDescriptors;

    public static IdeSettingsStatisticsService getInstance() {
        return myInstance;
    }

    private IdeSettingsStatisticsService() {
        super("http://jetbrains.com/idea/ide-settings-statistics.xml", "http://frameworks.jetbrains.com/statistics");
    }

    @NotNull
    public IdeSettingsDescriptor[] getSettingDescriptors() {
        if (this.myDescriptors == null) {
            URL url = this.createVersionsUrl();
            if (url == null) {
                IdeSettingsDescriptor[] ideSettingsDescriptorArray = new IdeSettingsDescriptor[]{};
                if (ideSettingsDescriptorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsService", "getSettingDescriptors"));
                }
                return ideSettingsDescriptorArray;
            }
            IdeSettingsDescriptors descriptors = IdeSettingsStatisticsService.deserialize(url);
            IdeSettingsDescriptor[] ideSettingsDescriptorArray = this.myDescriptors = descriptors == null ? new IdeSettingsDescriptor[]{} : descriptors.getDescriptors();
        }
        if (this.myDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsStatisticsService", "getSettingDescriptors"));
        }
        return this.myDescriptors;
    }

    @Nullable
    private static IdeSettingsDescriptors deserialize(@Nullable URL url) {
        IdeSettingsDescriptors ideSettingsDescriptor;
        block3: {
            if (url == null) {
                return null;
            }
            ideSettingsDescriptor = null;
            try {
                ideSettingsDescriptor = (IdeSettingsDescriptors)XmlSerializer.deserialize((URL)url, IdeSettingsDescriptors.class);
            }
            catch (XmlSerializationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) break block3;
                LOG.error((Throwable)e);
            }
        }
        return ideSettingsDescriptor;
    }

    @Nullable
    private URL createVersionsUrl() {
        String serviceUrl = this.getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

