/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class DiffOptionsPanel
implements OptionsPanel {
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    private LabeledComponent<ColorPanel> myBackgoundColorPanelComponent;
    private JList myOptionsList;
    private JPanel myWholePanel;
    private LabeledComponent<ColorPanel> myStripeMarkColorComponent;
    private static final Comparator<TextDiffType> TEXT_DIFF_TYPE_COMPARATOR = new Comparator<TextDiffType>(){

        @Override
        public int compare(TextDiffType textDiffType, TextDiffType textDiffType1) {
            return textDiffType.getDisplayName().compareToIgnoreCase(textDiffType1.getDisplayName());
        }
    };
    private final SortedListModel<TextDiffType> myOptionsModel;
    private final HashMap<String, MyColorAndFontDescription> myDescriptions;

    public DiffOptionsPanel(ColorAndFontOptions options) {
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myOptionsModel = new SortedListModel(TEXT_DIFF_TYPE_COMPARATOR);
        this.myDescriptions = new HashMap();
        this.myOptions = options;
        this.myOptionsList.setCellRenderer(new OptionsReneder());
        this.myOptionsList.setModel(this.myOptionsModel);
        ListSelectionModel selectionModel = this.myOptionsList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TextDiffType selection = DiffOptionsPanel.this.getSelectedOption();
                ColorPanel background = DiffOptionsPanel.this.getBackgroundColorPanel();
                ColorPanel stripeMark = DiffOptionsPanel.this.getStripeMarkColorPanel();
                if (selection == null) {
                    background.setEnabled(false);
                    stripeMark.setEnabled(false);
                } else {
                    background.setEnabled(true);
                    stripeMark.setEnabled(true);
                    MyColorAndFontDescription description = DiffOptionsPanel.this.getSelectedDescription();
                    if (description != null) {
                        background.setSelectedColor(description.getBackgroundColor());
                        stripeMark.setSelectedColor(description.getStripeMarkColor());
                    }
                }
                ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).selectedOptionChanged(selection);
            }
        });
        this.getBackgroundColorPanel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorAndFontDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                ColorPanel colorPanel = DiffOptionsPanel.this.getBackgroundColorPanel();
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    colorPanel.setSelectedColor(selectedDescription.getBackgroundColor());
                    return;
                }
                selectedDescription.setBackgroundColor(colorPanel.getSelectedColor());
                ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
            }
        });
        this.getStripeMarkColorPanel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorAndFontDescription selectedDescription = DiffOptionsPanel.this.getSelectedDescription();
                ColorPanel colorPanel = DiffOptionsPanel.this.getStripeMarkColorPanel();
                if (!DiffOptionsPanel.this.checkModifiableScheme()) {
                    colorPanel.setSelectedColor(selectedDescription.getStripeMarkColor());
                    return;
                }
                selectedDescription.setStripeMarkColor(colorPanel.getSelectedColor());
                ((ColorAndFontSettingsListener)DiffOptionsPanel.this.myDispatcher.getMulticaster()).settingsChanged();
            }
        });
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public JPanel getPanel() {
        return this.myWholePanel;
    }

    @Override
    public void updateOptionsList() {
        this.myOptionsModel.clear();
        this.myDescriptions.clear();
        Map typesByKey = ContainerUtil.newMapFromValues(TextDiffType.MERGE_TYPES.iterator(), TextDiffType.ATTRIBUTES_KEY);
        for (int i = 0; i < this.myOptions.getCurrentDescriptions().length; ++i) {
            EditorSchemeAttributeDescriptor description = this.myOptions.getCurrentDescriptions()[i];
            TextAttributesKey type = TextAttributesKey.find((String)description.getType());
            if (description.getGroup() != ColorAndFontOptions.DIFF_GROUP || !typesByKey.keySet().contains(type)) continue;
            this.myOptionsModel.add(typesByKey.get(type));
            this.myDescriptions.put((Object)type.getExternalName(), (Object)((MyColorAndFontDescription)description));
        }
        ListScrollingUtil.ensureSelectionExists((JList)this.myOptionsList);
    }

    @Override
    public Runnable showOption(String option) {
        AbstractListModel model = (AbstractListModel)this.myOptionsList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String type;
            Object o = model.getElementAt(i);
            if (!(o instanceof TextDiffType) || !(type = ((TextDiffType)o).getDisplayName()).toLowerCase().contains(option.toLowerCase())) continue;
            final int i1 = i;
            return new Runnable(){

                @Override
                public void run() {
                    ListScrollingUtil.selectItem((JList)DiffOptionsPanel.this.myOptionsList, (int)i1);
                }
            };
        }
        return null;
    }

    @Override
    public Set<String> processListOptions() {
        HashSet result = ContainerUtil.newHashSet();
        Map typesByKey = ContainerUtil.newMapFromValues(TextDiffType.MERGE_TYPES.iterator(), TextDiffType.ATTRIBUTES_KEY);
        for (int i = 0; i < this.myOptions.getCurrentDescriptions().length; ++i) {
            EditorSchemeAttributeDescriptor description = this.myOptions.getCurrentDescriptions()[i];
            TextAttributesKey type = TextAttributesKey.find((String)description.getType());
            if (description.getGroup() != ColorAndFontOptions.DIFF_GROUP || !typesByKey.keySet().contains(type)) continue;
            result.add(type.getExternalName());
        }
        return result;
    }

    @Override
    public void applyChangesToScheme() {
        MyColorAndFontDescription description = this.getSelectedDescription();
        if (description != null) {
            description.apply(this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String typeToSelect) {
        for (int i = 0; i < this.myOptionsModel.getItems().size(); ++i) {
            Object o = this.myOptionsModel.get(i);
            if (!(o instanceof TextDiffType) || !typeToSelect.equals(((TextDiffType)o).getDisplayName())) continue;
            ListScrollingUtil.selectItem((JList)this.myOptionsList, (int)i);
            return;
        }
    }

    private TextDiffType getSelectedOption() {
        return (TextDiffType)this.myOptionsList.getSelectedValue();
    }

    private boolean checkModifiableScheme() {
        boolean isReadOnly = this.myOptions.currentSchemeIsReadOnly();
        if (isReadOnly) {
            FontOptions.showReadOnlyMessage(this.myWholePanel, this.myOptions.currentSchemeIsShared());
        }
        return !isReadOnly;
    }

    private MyColorAndFontDescription getSelectedDescription() {
        TextDiffType selection = this.getSelectedOption();
        if (selection == null) {
            return null;
        }
        return (MyColorAndFontDescription)this.myDescriptions.get((Object)selection.getAttributesKey().getExternalName());
    }

    private ColorPanel getBackgroundColorPanel() {
        return (ColorPanel)this.myBackgoundColorPanelComponent.getComponent();
    }

    private ColorPanel getStripeMarkColorPanel() {
        return (ColorPanel)this.myStripeMarkColorComponent.getComponent();
    }

    public static void addSchemeDescriptions(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull EditorColorsScheme scheme) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel", "addSchemeDescriptions"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel", "addSchemeDescriptions"));
        }
        for (TextDiffType diffType : TextDiffType.MERGE_TYPES) {
            descriptions.add(new MyColorAndFontDescription(diffType, scheme));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myOptionsList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 9, 1, 3, 3, null, null, null));
        this.myBackgoundColorPanelComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/DiffBundle").getString("merge.color.options.background.color.label"));
        labeledComponent2.setComponentClass("com.intellij.ui.ColorPanel");
        jPanel3.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myStripeMarkColorComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/DiffBundle").getString("merge.color.options.stripe.mark.color.label"));
        labeledComponent.setComponentClass("com.intellij.ui.ColorPanel");
        jPanel3.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static class MyColorAndFontDescription
    implements EditorSchemeAttributeDescriptor {
        private Color myBackgroundColor;
        private Color myStripebarColor;
        private final Color myOriginalBackground;
        private final Color myOriginalStripebar;
        private final EditorColorsScheme myScheme;
        private final TextDiffType myDiffType;

        public MyColorAndFontDescription(@NotNull TextDiffType diffType, @NotNull EditorColorsScheme scheme) {
            if (diffType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyColorAndFontDescription", "<init>"));
            }
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/diff/impl/settings/DiffOptionsPanel$MyColorAndFontDescription", "<init>"));
            }
            this.myScheme = scheme;
            this.myDiffType = diffType;
            TextAttributes attrs = diffType.getTextAttributes(this.myScheme);
            this.myBackgroundColor = attrs.getBackgroundColor();
            this.myStripebarColor = attrs.getErrorStripeColor();
            this.myOriginalBackground = this.myBackgroundColor;
            this.myOriginalStripebar = this.myStripebarColor;
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
            TextAttributesKey key = this.myDiffType.getAttributesKey();
            TextAttributes attrs = new TextAttributes(null, this.myBackgroundColor, null, EffectType.BOXED, 0);
            attrs.setErrorStripeColor(this.myStripebarColor);
            scheme.setAttributes(key, attrs);
        }

        @Override
        public String getGroup() {
            return ColorAndFontOptions.DIFF_GROUP;
        }

        @Override
        public EditorColorsScheme getScheme() {
            return this.myScheme;
        }

        @Override
        public String getType() {
            return this.myDiffType.getAttributesKey().getExternalName();
        }

        @Override
        public boolean isModified() {
            TextAttributes attrs = this.myDiffType.getTextAttributes(this.myScheme);
            return !Comparing.equal((Object)this.myOriginalBackground, (Object)attrs.getBackgroundColor()) || !Comparing.equal((Object)this.myOriginalStripebar, (Object)attrs.getErrorStripeColor());
        }

        public void setBackgroundColor(Color selectedColor) {
            this.myBackgroundColor = selectedColor;
        }

        public Color getBackgroundColor() {
            return this.myBackgroundColor;
        }

        public void setStripeMarkColor(Color selectedColor) {
            this.myStripebarColor = selectedColor;
        }

        public Color getStripeMarkColor() {
            return this.myStripebarColor;
        }
    }

    private static class OptionsReneder
    extends ColoredListCellRenderer {
        private OptionsReneder() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            TextDiffType diffType = (TextDiffType)value;
            this.append(diffType.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

