/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DelayedRemovalMap<T> {
    private final TIntObjectHashMap<T> myMap = new TIntObjectHashMap();
    private final TIntHashSet myKeysToRemove = new TIntHashSet();
    private final TIntProcedure myRemoveEntriesProcedure = new TIntProcedure(){

        public boolean execute(int value) {
            DelayedRemovalMap.this.myMap.remove(value);
            return true;
        }
    };

    DelayedRemovalMap() {
    }

    @Nullable
    public T get(int key) {
        return (T)this.myMap.get(key);
    }

    public void put(int key, @NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/editor/impl/softwrap/mapping/DelayedRemovalMap", "put"));
        }
        this.myMap.put(key, value);
        this.myKeysToRemove.remove(key);
    }

    public void markForDeletion(int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (!this.myMap.containsKey(i)) continue;
            this.myKeysToRemove.add(i);
        }
    }

    public void deleteMarked() {
        this.myKeysToRemove.forEach(this.myRemoveEntriesProcedure);
    }

    public void deleteFrom(final int key) {
        this.myMap.retainEntries(new TIntObjectProcedure<T>(){

            public boolean execute(int a, T b) {
                if (a >= key) {
                    DelayedRemovalMap.this.myKeysToRemove.remove(a);
                    return false;
                }
                return true;
            }
        });
    }

    public void clear() {
        this.myMap.clear();
        this.myKeysToRemove.clear();
    }

    public int size() {
        return this.myMap.size();
    }
}

