/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationEditor;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalSystemRunConfiguration.class.getName()));
    private ExternalSystemTaskExecutionSettings mySettings;

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId externalSystemId, Project project, ConfigurationFactory factory, String name) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.mySettings = new ExternalSystemTaskExecutionSettings();
        this.mySettings.setExternalSystemIdString(externalSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.mySettings);
    }

    public RunConfiguration clone() {
        ExternalSystemRunConfiguration result = (ExternalSystemRunConfiguration)super.clone();
        result.mySettings = this.mySettings.clone();
        return result;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element e = element.getChild("ExternalSystemSettings");
        if (e != null) {
            this.mySettings = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)e, ExternalSystemTaskExecutionSettings.class);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.mySettings;
        if (externalSystemTaskExecutionSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getSettings"));
        }
        return externalSystemTaskExecutionSettings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        ExternalSystemRunConfigurationEditor externalSystemRunConfigurationEditor = new ExternalSystemRunConfigurationEditor(this.getProject(), this.mySettings.getExternalSystemId());
        if (externalSystemRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConfigurationEditor"));
        }
        return externalSystemRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getState"));
        }
        return new MyRunnableState(this.mySettings, this.getProject(), DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId()), this, env);
    }

    @NotNull
    private static ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration> getConsoleManagerFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
        }
        for (ExternalSystemExecutionConsoleManager executionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!executionConsoleManager.isApplicableFor(task)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager = executionConsoleManager;
            if (externalSystemExecutionConsoleManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
            }
            return externalSystemExecutionConsoleManager;
        }
        DefaultExternalSystemExecutionConsoleManager defaultExternalSystemExecutionConsoleManager = new DefaultExternalSystemExecutionConsoleManager();
        if (defaultExternalSystemExecutionConsoleManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
        }
        return defaultExternalSystemExecutionConsoleManager;
    }

    private static class MyProcessHandler
    extends ProcessHandler {
        private final ExternalSystemExecuteTaskTask myTask;
        @Nullable
        private volatile OutputStream myOutputStream;

        public MyProcessHandler(ExternalSystemExecuteTaskTask task) {
            this.myTask = task;
        }

        protected void destroyProcessImpl() {
        }

        protected void detachProcessImpl() {
            this.myTask.cancel(new ExternalSystemTaskNotificationListener[0]);
            this.notifyProcessDetached();
        }

        public boolean detachIsDefault() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
        }
    }

    public static class MyRunnableState
    implements RunProfileState {
        @NotNull
        private final ExternalSystemTaskExecutionSettings mySettings;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ExternalSystemRunConfiguration myConfiguration;
        @NotNull
        private final ExecutionEnvironment myEnv;
        private final int myDebugPort;

        public MyRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
            int port;
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            this.mySettings = settings;
            this.myProject = project;
            this.myConfiguration = configuration;
            this.myEnv = env;
            if (debug) {
                try {
                    port = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)e);
                    port = 0;
                }
            } else {
                port = 0;
            }
            this.myDebugPort = port;
        }

        public int getDebugPort() {
            return this.myDebugPort;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "execute"));
            }
            if (this.myProject.isDisposed()) {
                return null;
            }
            ExternalSystemUtil.updateRecentTasks(new ExternalTaskExecutionInfo(this.mySettings.clone(), executor.getId()), this.myProject);
            ArrayList tasks = ContainerUtilRt.newArrayList();
            for (String taskName : this.mySettings.getTaskNames()) {
                tasks.add(new ExternalTaskPojo(taskName, this.mySettings.getExternalProjectPath(), null));
            }
            if (tasks.isEmpty()) {
                throw new ExecutionException(ExternalSystemBundle.message((String)"run.error.undefined.task", (Object[])new Object[0]));
            }
            String debuggerSetup = null;
            if (this.myDebugPort > 0) {
                debuggerSetup = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + this.myDebugPort;
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileDocumentManager.getInstance().saveAllDocuments();
            final ExternalSystemExecuteTaskTask task = new ExternalSystemExecuteTaskTask(this.mySettings.getExternalSystemId(), this.myProject, tasks, this.mySettings.getVmOptions(), this.mySettings.getScriptParameters(), debuggerSetup);
            final MyProcessHandler processHandler = new MyProcessHandler(task);
            final ExternalSystemExecutionConsoleManager consoleManager = ExternalSystemRunConfiguration.getConsoleManagerFor(task);
            ExecutionConsole consoleView = consoleManager.attachExecutionConsole((ExternalSystemTask)task, this.myProject, (RunConfiguration)this.myConfiguration, executor, this.myEnv, (ProcessHandler)processHandler);
            Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    String startDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                    String greeting = MyRunnableState.this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.starting.multiple.task", (Object[])new Object[]{startDateTime, StringUtil.join((Collection)MyRunnableState.this.mySettings.getTaskNames(), (String)" ")}) : ExternalSystemBundle.message((String)"run.text.starting.single.task", (Object[])new Object[]{startDateTime, StringUtil.join((Collection)MyRunnableState.this.mySettings.getTaskNames(), (String)" ")});
                    processHandler.notifyTextAvailable(greeting, ProcessOutputTypes.SYSTEM);
                    task.execute(new ExternalSystemTaskNotificationListener[]{new ExternalSystemTaskNotificationListenerAdapter(){
                        private boolean myResetGreeting = true;

                        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                            if (id == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1$1", "onTaskOutput"));
                            }
                            if (text == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1$1", "onTaskOutput"));
                            }
                            if (this.myResetGreeting) {
                                processHandler.notifyTextAvailable("\r", ProcessOutputTypes.SYSTEM);
                                this.myResetGreeting = false;
                            }
                            consoleManager.onOutput(text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                        }

                        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                            if (id == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1$1", "onFailure"));
                            }
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1$1", "onFailure"));
                            }
                            String exceptionMessage = ExceptionUtil.getMessage((Throwable)e);
                            String text = exceptionMessage == null ? e.toString() : exceptionMessage;
                            processHandler.notifyTextAvailable(text + '\n', ProcessOutputTypes.STDERR);
                            processHandler.notifyProcessTerminated(1);
                        }

                        public void onEnd(@NotNull ExternalSystemTaskId id) {
                            if (id == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1$1", "onEnd"));
                            }
                            String endDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                            String farewell = MyRunnableState.this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.ended.multiple.task", (Object[])new Object[]{endDateTime, StringUtil.join((Collection)MyRunnableState.this.mySettings.getTaskNames(), (String)" ")}) : ExternalSystemBundle.message((String)"run.text.ended.single.task", (Object[])new Object[]{endDateTime, StringUtil.join((Collection)MyRunnableState.this.mySettings.getTaskNames(), (String)" ")});
                            processHandler.notifyTextAvailable(farewell, ProcessOutputTypes.SYSTEM);
                            processHandler.notifyProcessTerminated(0);
                        }
                    }});
                }
            });
            DefaultExecutionResult result = new DefaultExecutionResult(consoleView, (ProcessHandler)processHandler);
            result.setRestartActions(consoleManager.getRestartActions());
            return result;
        }
    }
}

