/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableTitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportFromExternalSystemControl<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>> {
    @NotNull
    private final SystemSettings mySystemSettings;
    @NotNull
    private final ProjectSettings myProjectSettings;
    @NotNull
    private final PaintAwarePanel myComponent;
    @NotNull
    private final TextFieldWithBrowseButton myLinkedProjectPathField;
    @Nullable
    private final HideableTitledPanel hideableSystemSettingsPanel;
    @Nullable
    private final ProjectFormatPanel myProjectFormatPanel;
    @NotNull
    private final ExternalSystemSettingsControl<ProjectSettings> myProjectSettingsControl;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @Nullable
    private final ExternalSystemSettingsControl<SystemSettings> mySystemSettingsControl;
    @Nullable
    Project myCurrentProject;

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId externalSystemId, @NotNull SystemSettings systemSettings, @NotNull ProjectSettings projectSettings) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        if (systemSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        this(externalSystemId, systemSettings, projectSettings, false);
    }

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId externalSystemId, @NotNull SystemSettings systemSettings, @NotNull ProjectSettings projectSettings, boolean showProjectFormatPanel) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        if (systemSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "<init>"));
        }
        this.myComponent = new PaintAwarePanel(new GridBagLayout());
        this.myLinkedProjectPathField = new TextFieldWithBrowseButton();
        this.myExternalSystemId = externalSystemId;
        this.mySystemSettings = systemSettings;
        this.myProjectSettings = projectSettings;
        this.myProjectSettingsControl = this.createProjectSettingsControl(projectSettings);
        this.mySystemSettingsControl = this.createSystemSettingsControl(systemSettings);
        JLabel linkedProjectPathLabel = new JLabel(ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{externalSystemId.getReadableName()}));
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        FileChooserDescriptor fileChooserDescriptor = manager.getExternalProjectDescriptor();
        this.myLinkedProjectPathField.addBrowseFolderListener("", ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{externalSystemId.getReadableName()}), null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myLinkedProjectPathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.myLinkedProjectPathField.getText());
            }
        });
        this.myComponent.add((Component)linkedProjectPathLabel, ExternalSystemUiUtil.getLabelConstraints(0));
        this.myComponent.add((Component)this.myLinkedProjectPathField, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.myProjectSettingsControl.fillUi(this.myComponent, 0);
        if (showProjectFormatPanel) {
            this.myProjectFormatPanel = new ProjectFormatPanel();
            JLabel myProjectFormatLabel = new JLabel(ExternalSystemBundle.message((String)"settings.label.project.format", (Object[])new Object[0]));
            this.myComponent.add((Component)myProjectFormatLabel, ExternalSystemUiUtil.getLabelConstraints(0));
            this.myComponent.add((Component)this.myProjectFormatPanel.getStorageFormatComboBox(), ExternalSystemUiUtil.getFillLineConstraints(0));
        } else {
            this.myProjectFormatPanel = null;
        }
        if (this.mySystemSettingsControl != null) {
            PaintAwarePanel mySystemSettingsControlPanel = new PaintAwarePanel();
            this.mySystemSettingsControl.fillUi(mySystemSettingsControlPanel, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)mySystemSettingsControlPanel, "Center");
            this.hideableSystemSettingsPanel = new HideableTitledPanel(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}), false);
            this.hideableSystemSettingsPanel.setContentComponent(panel);
            this.hideableSystemSettingsPanel.setOn(false);
            this.myComponent.add((Component)this.hideableSystemSettingsPanel, ExternalSystemUiUtil.getFillLineConstraints(0));
        } else {
            this.hideableSystemSettingsPanel = null;
        }
        ExternalSystemUiUtil.fillBottom(this.myComponent);
    }

    public void setCurrentProject(@Nullable Project currentProject) {
        this.myCurrentProject = currentProject;
    }

    protected abstract void onLinkedProjectPathChange(@NotNull String var1);

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    @NotNull
    public JComponent getComponent() {
        PaintAwarePanel paintAwarePanel = this.myComponent;
        if (paintAwarePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "getComponent"));
        }
        return paintAwarePanel;
    }

    @NotNull
    public ExternalSystemSettingsControl<ProjectSettings> getProjectSettingsControl() {
        ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl = this.myProjectSettingsControl;
        if (externalSystemSettingsControl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "getProjectSettingsControl"));
        }
        return externalSystemSettingsControl;
    }

    @Nullable
    public ExternalSystemSettingsControl<SystemSettings> getSystemSettingsControl() {
        return this.mySystemSettingsControl;
    }

    public void setLinkedProjectPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "setLinkedProjectPath"));
        }
        this.myProjectSettings.setExternalProjectPath(path);
        this.myLinkedProjectPathField.setText(path);
    }

    @NotNull
    public SystemSettings getSystemSettings() {
        SystemSettings SystemSettings = this.mySystemSettings;
        if (SystemSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "getSystemSettings"));
        }
        return SystemSettings;
    }

    @NotNull
    public ProjectSettings getProjectSettings() {
        ProjectSettings ProjectSettings2 = this.myProjectSettings;
        if (ProjectSettings2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl", "getProjectSettings"));
        }
        return ProjectSettings2;
    }

    public void reset() {
        this.myLinkedProjectPathField.setText("");
        this.myProjectSettingsControl.reset();
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.reset();
        }
        if (this.hideableSystemSettingsPanel != null) {
            this.hideableSystemSettingsPanel.setOn(false);
        }
    }

    public void apply() throws ConfigurationException {
        String linkedProjectPath = this.myLinkedProjectPathField.getText();
        if (StringUtil.isEmpty((String)linkedProjectPath)) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        if (this.myCurrentProject != null) {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
            assert (manager != null);
            AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myCurrentProject);
            if (settings.getLinkedProjectSettings(linkedProjectPath) != null) {
                throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
            }
        }
        this.myProjectSettings.setExternalProjectPath(ExternalSystemApiUtil.normalizePath((String)linkedProjectPath));
        this.myProjectSettingsControl.validate(this.myProjectSettings);
        this.myProjectSettingsControl.apply(this.myProjectSettings);
        if (this.mySystemSettingsControl != null) {
            this.mySystemSettingsControl.validate(this.mySystemSettings);
            this.mySystemSettingsControl.apply(this.mySystemSettings);
        }
    }

    @Nullable
    public ProjectFormatPanel getProjectFormatPanel() {
        return this.myProjectFormatPanel;
    }
}

