/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonCodeUsageInfoFactory
implements UsageInfoFactory {
    private final PsiElement myElement;
    private final String myStringToReplace;

    public NonCodeUsageInfoFactory(PsiElement element, String stringToReplace) {
        this.myElement = element;
        this.myStringToReplace = stringToReplace;
    }

    @Nullable
    public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/rename/NonCodeUsageInfoFactory", "createUsageInfo"));
        }
        PsiElement namedElement = TargetElementUtilBase.getInstance().getNamedElement(usage, startOffset);
        if (namedElement != null) {
            return null;
        }
        int start = usage.getTextRange().getStartOffset();
        return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)this.myElement, (String)this.myStringToReplace);
    }
}

