/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerSettingsEditor;
import com.intellij.remoteServer.impl.runtime.DeployToServerState;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerRunConfiguration<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends RunConfigurationBase {
    private static final Logger LOG = Logger.getInstance(DeployToServerRunConfiguration.class);
    private static final String DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String SETTINGS_ELEMENT = "settings";
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private final ServerType<S> myServerType;
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private String myServerName;
    private DeploymentSource myDeploymentSource;
    private D myDeploymentConfiguration;

    public DeployToServerRunConfiguration(Project project, ConfigurationFactory factory, String name, ServerType<S> serverType, DeploymentConfigurator<D, S> deploymentConfigurator) {
        super(project, factory, name);
        this.myServerType = serverType;
        this.myDeploymentConfigurator = deploymentConfigurator;
    }

    @NotNull
    public ServerType<S> getServerType() {
        ServerType<S> serverType = this.myServerType;
        if (serverType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration", "getServerType"));
        }
        return serverType;
    }

    public String getServerName() {
        return this.myServerName;
    }

    @NotNull
    public DeploymentConfigurator<D, S> getDeploymentConfigurator() {
        DeploymentConfigurator<D, S> deploymentConfigurator = this.myDeploymentConfigurator;
        if (deploymentConfigurator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration", "getDeploymentConfigurator"));
        }
        return deploymentConfigurator;
    }

    @NotNull
    public SettingsEditor<DeployToServerRunConfiguration> getConfigurationEditor() {
        DeployToServerSettingsEditor<S, D> deployToServerSettingsEditor = new DeployToServerSettingsEditor<S, D>(this.myServerType, this.myDeploymentConfigurator, this.getProject());
        if (deployToServerSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration", "getConfigurationEditor"));
        }
        return deployToServerSettingsEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration", "getState"));
        }
        String serverName = this.getServerName();
        if (serverName == null) {
            throw new ExecutionException("Server is not specified");
        }
        RemoteServer<S> server = this.findServer();
        if (server == null) {
            throw new ExecutionException("Server '" + serverName + " not found");
        }
        if (this.myDeploymentSource == null) {
            throw new ExecutionException("Deployment is not selected");
        }
        return new DeployToServerState<S, D>(server, this.myDeploymentSource, this.myDeploymentConfiguration, env);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        RemoteServer<S> server = this.findServer();
        if (server == null) {
            return;
        }
        if (this.myDeploymentSource == null) {
            return;
        }
        this.myDeploymentConfiguration.checkConfiguration(server, this.myDeploymentSource);
    }

    private RemoteServer<S> findServer() {
        String serverName = this.getServerName();
        if (serverName == null) {
            return null;
        }
        return RemoteServersManager.getInstance().findByName(serverName, this.myServerType);
    }

    public void setServerName(String serverName) {
        this.myServerName = serverName;
    }

    public DeploymentSource getDeploymentSource() {
        return this.myDeploymentSource;
    }

    public void setDeploymentSource(DeploymentSource deploymentSource) {
        this.myDeploymentSource = deploymentSource;
    }

    public D getDeploymentConfiguration() {
        return this.myDeploymentConfiguration;
    }

    public void setDeploymentConfiguration(D deploymentConfiguration) {
        this.myDeploymentConfiguration = deploymentConfiguration;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        ConfigurationState state = (ConfigurationState)XmlSerializer.deserialize((Element)element, ConfigurationState.class);
        this.myServerName = null;
        this.myDeploymentSource = null;
        if (state != null) {
            this.myServerName = state.myServerName;
            Element deploymentTag = state.myDeploymentTag;
            if (deploymentTag != null) {
                String typeId = deploymentTag.getAttributeValue(DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE);
                DeploymentSourceType<?> type = DeployToServerRunConfiguration.findDeploymentSourceType(typeId);
                if (type != null) {
                    this.myDeploymentSource = type.load(deploymentTag, this.getProject());
                    this.myDeploymentConfiguration = this.myDeploymentConfigurator.createDefaultConfiguration(this.myDeploymentSource);
                    ComponentSerializationUtil.loadComponentState(this.myDeploymentConfiguration.getSerializer(), deploymentTag.getChild(SETTINGS_ELEMENT));
                } else {
                    LOG.warn("Cannot load deployment source for '" + this.getName() + "' run configuration: unknown deployment type '" + typeId + "'");
                }
            }
        }
    }

    @Nullable
    private static DeploymentSourceType<?> findDeploymentSourceType(@Nullable String id) {
        for (DeploymentSourceType type : (DeploymentSourceType[])DeploymentSourceType.EP_NAME.getExtensions()) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        ConfigurationState state = new ConfigurationState();
        state.myServerName = this.myServerName;
        if (this.myDeploymentSource != null) {
            Object configurationState;
            DeploymentSourceType type = this.myDeploymentSource.getType();
            Element deploymentTag = new Element("deployment").setAttribute(DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE, type.getId());
            type.save(this.myDeploymentSource, deploymentTag);
            if (this.myDeploymentConfiguration != null && (configurationState = this.myDeploymentConfiguration.getSerializer().getState()) != null) {
                Element settingsTag = new Element(SETTINGS_ELEMENT);
                XmlSerializer.serializeInto((Object)configurationState, (Element)settingsTag, (SerializationFilter)SERIALIZATION_FILTERS);
                deploymentTag.addContent(settingsTag);
            }
            state.myDeploymentTag = deploymentTag;
        }
        XmlSerializer.serializeInto((Object)state, (Element)element, (SerializationFilter)SERIALIZATION_FILTERS);
        super.writeExternal(element);
    }

    public static class ConfigurationState {
        @Attribute(value="server-name")
        public String myServerName;
        @Tag(value="deployment")
        public Element myDeploymentTag;
    }
}

