/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Set;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private PsiSearchHelper helper;
    private THashMap<PsiFile, PsiFile> filesToScan;
    private THashMap<PsiFile, PsiFile> filesToScan2;
    private final boolean findMatchingFiles;

    FindInFilesOptimizingSearchHelper(CompileContext _context, boolean _findMatchngFiles, Project project) {
        super(_context);
        this.findMatchingFiles = _findMatchngFiles;
        if (this.findMatchingFiles) {
            this.helper = PsiSearchHelper.SERVICE.getInstance((Project)project);
            if (this.filesToScan == null) {
                this.filesToScan = new THashMap();
                this.filesToScan2 = new THashMap();
            }
        }
    }

    @Override
    public boolean doOptimizing() {
        return this.findMatchingFiles;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
            this.helper = null;
        }
    }

    @Override
    protected void doAddSearchWordInCode(String refname) {
        FileType fileType = this.context.getOptions().getFileType();
        Language language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : Language.ANY;
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language);
        if (namesValidator.isKeyword(refname, this.context.getProject())) {
            this.helper.processAllFilesWithWordInText(refname, (GlobalSearchScope)this.context.getOptions().getScope(), (Processor)new MyFileProcessor(), true);
        } else {
            this.helper.processAllFilesWithWord(refname, (GlobalSearchScope)this.context.getOptions().getScope(), (Processor)new MyFileProcessor(), true);
        }
    }

    @Override
    protected void doAddSearchWordInText(String refname) {
        this.helper.processAllFilesWithWordInText(refname, (GlobalSearchScope)this.context.getOptions().getScope(), (Processor)new MyFileProcessor(), true);
    }

    @Override
    protected void doAddSearchWordInComments(String refname) {
        this.helper.processAllFilesWithWordInComments(refname, (GlobalSearchScope)this.context.getOptions().getScope(), (Processor)new MyFileProcessor());
    }

    @Override
    protected void doAddSearchWordInLiterals(String refname) {
        this.helper.processAllFilesWithWordInLiterals(refname, (GlobalSearchScope)this.context.getOptions().getScope(), (Processor)new MyFileProcessor());
    }

    @Override
    public void endTransaction() {
        super.endTransaction();
        THashMap<PsiFile, PsiFile> map = this.filesToScan;
        if (map.size() > 0) {
            map.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map;
    }

    @Override
    public Set<PsiFile> getFilesSetToScan() {
        return this.filesToScan.keySet();
    }

    private class MyFileProcessor
    implements Processor<PsiFile> {
        private MyFileProcessor() {
        }

        public boolean process(PsiFile file) {
            if (FindInFilesOptimizingSearchHelper.this.scanRequest == 0 || FindInFilesOptimizingSearchHelper.this.filesToScan.get((Object)file) != null) {
                FindInFilesOptimizingSearchHelper.this.filesToScan2.put((Object)file, (Object)file);
            }
            return true;
        }
    }
}

