/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.XmlTextHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.XmlMatchingStrategy;

public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    private final GlobalCompilingVisitor myCompilingVisitor;

    public XmlCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void visitElement(PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitXmlToken(XmlToken token) {
        super.visitXmlToken(token);
        if (token.getParent() instanceof XmlText && this.myCompilingVisitor.getContext().getPattern().isRealTypedVar((PsiElement)token)) {
            MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)token);
            handler.setFilter(TagValueFilter.getInstance());
            XmlTextHandler parentHandler = new XmlTextHandler();
            this.myCompilingVisitor.getContext().getPattern().setHandler(token.getParent(), parentHandler);
            parentHandler.setFilter(TagValueFilter.getInstance());
        }
    }

    public void visitXmlTag(XmlTag xmlTag) {
        this.myCompilingVisitor.setCodeBlockLevel(this.myCompilingVisitor.getCodeBlockLevel() + 1);
        super.visitXmlTag(xmlTag);
        this.myCompilingVisitor.setCodeBlockLevel(this.myCompilingVisitor.getCodeBlockLevel() - 1);
        if (this.myCompilingVisitor.getCodeBlockLevel() == 1) {
            this.myCompilingVisitor.getContext().getPattern().setStrategy(XmlMatchingStrategy.getInstance());
            this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)xmlTag, new TopLevelMatchingHandler(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)xmlTag)));
        }
    }
}

