/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Snappy;

public class CompressionUtil {
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(DataOutput out, byte[] bytes, int length) throws IOException {
        if (length > 64) {
            byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length));
            int compressedSize = Snappy.compress((byte[])bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)(-compressedSize));
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)length);
        out.write(bytes, 0, length);
        return length;
    }

    public static byte[] readCompressed(DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        if (size < 0) {
            byte[] bytes = spareBufferLocal.getBuffer(-size);
            in.readFully(bytes, 0, -size);
            return Snappy.uncompress((byte[])bytes, (int)0, (int)(-size));
        }
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        return bytes;
    }

    public static CharSequence uncompressCharSequence(Object string, Charset charset) {
        if (string instanceof CharSequence) {
            return (CharSequence)string;
        }
        byte[] b = (byte[])string;
        try {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
            byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
            int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
            return new String(bytes, 0, bytesLength, charset);
        }
        catch (CorruptionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object compressCharSequence(CharSequence string, Charset charset) {
        if (string.length() < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = ((Object)string).toString();
            }
            return string;
        }
        try {
            return Snappy.compress((byte[])((Object)string).toString().getBytes(charset));
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            return string;
        }
    }
}

