/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PermanentLinearGraphImpl
implements LinearGraph {
    private final Flags mySimpleNodes;
    private final IntList myNodeToEdgeIndex;
    private final IntList myLongEdges;

    PermanentLinearGraphImpl(Flags simpleNodes, int[] nodeToEdgeIndex, int[] longEdges) {
        this.mySimpleNodes = simpleNodes;
        this.myNodeToEdgeIndex = CompressedIntList.newInstance(nodeToEdgeIndex);
        this.myLongEdges = CompressedIntList.newInstance(longEdges);
    }

    @Override
    public int nodesCount() {
        return this.mySimpleNodes.size();
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        SmartList result = new SmartList();
        if (nodeIndex != 0 && this.mySimpleNodes.get(nodeIndex - 1)) {
            result.add(nodeIndex - 1);
        }
        for (int i = this.myNodeToEdgeIndex.get(nodeIndex); i < this.myNodeToEdgeIndex.get(nodeIndex + 1); ++i) {
            int node = this.myLongEdges.get(i);
            if (node >= nodeIndex) continue;
            result.add(node);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getUpNodes"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        if (this.mySimpleNodes.get(nodeIndex)) {
            List<Integer> list = Collections.singletonList(nodeIndex + 1);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getDownNodes"));
            }
            return list;
        }
        SmartList result = new SmartList();
        for (int i = this.myNodeToEdgeIndex.get(nodeIndex); i < this.myNodeToEdgeIndex.get(nodeIndex + 1); ++i) {
            int node = this.myLongEdges.get(i);
            if (nodeIndex >= node) continue;
            result.add(node);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentLinearGraphImpl", "getDownNodes"));
        }
        return smartList;
    }
}

