/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementsManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrintElement
implements PrintElementWithGraphElement {
    protected final int myRowIndex;
    protected final int myPositionInCurrentRow;
    @NotNull
    protected final GraphElement myGraphElement;
    @NotNull
    protected final PrintElementsManager myPrintElementsManager;

    protected AbstractPrintElement(int rowIndex, int positionInCurrentRow, @NotNull GraphElement graphElement, @NotNull PrintElementsManager printElementsManager) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/print/elements/AbstractPrintElement", "<init>"));
        }
        if (printElementsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementsManager", "com/intellij/vcs/log/graph/impl/print/elements/AbstractPrintElement", "<init>"));
        }
        this.myRowIndex = rowIndex;
        this.myPositionInCurrentRow = positionInCurrentRow;
        this.myGraphElement = graphElement;
        this.myPrintElementsManager = printElementsManager;
    }

    @Override
    @NotNull
    public GraphElement getGraphElement() {
        GraphElement graphElement = this.myGraphElement;
        if (graphElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/AbstractPrintElement", "getGraphElement"));
        }
        return graphElement;
    }

    public int getRowIndex() {
        return this.myRowIndex;
    }

    public int getPositionInCurrentRow() {
        return this.myPositionInCurrentRow;
    }

    public int getColorId() {
        return this.myPrintElementsManager.getColorId(this.myGraphElement);
    }

    public boolean isSelected() {
        return this.myPrintElementsManager.elementIsSelected(this);
    }
}

