/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import org.jetbrains.annotations.NotNull;

class ComplexityVisitor
extends JavaRecursiveElementVisitor {
    private int m_complexity = 1;

    ComplexityVisitor() {
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitAnonymousClass"));
        }
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitForStatement"));
        }
        super.visitForStatement(statement);
        ++this.m_complexity;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitForeachStatement"));
        }
        super.visitForeachStatement(statement);
        ++this.m_complexity;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitIfStatement"));
        }
        super.visitIfStatement(statement);
        ++this.m_complexity;
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitDoWhileStatement"));
        }
        super.visitDoWhileStatement(statement);
        ++this.m_complexity;
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.m_complexity;
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitSwitchStatement"));
        }
        super.visitSwitchStatement(statement);
        PsiCodeBlock body = statement.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean pendingLabel = false;
        for (PsiStatement child : statements) {
            if (child instanceof PsiSwitchLabelStatement) {
                if (!pendingLabel) {
                    ++this.m_complexity;
                }
                pendingLabel = true;
                continue;
            }
            pendingLabel = false;
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/classmetrics/ComplexityVisitor", "visitWhileStatement"));
        }
        super.visitWhileStatement(statement);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }
}

