/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestMethodWithoutAssertionInspectionBase
extends BaseInspection {
    protected final List<String> methodNamePatterns = new ArrayList<String>();
    protected final List<String> classNames = new ArrayList<String>();
    @NonNls
    public String assertionMethods = "org.junit.Assert,assert.*|fail.*,junit.framework.Assert,assert.*|fail.*,org.mockito.Mockito,verify.*,org.mockito.InOrder,verify,org.junit.rules.ExpectedException,expect.*,org.hamcrest.MatcherAssert,assertThat";
    public boolean assertKeywordIsAssertion = false;
    private Map<String, Pattern> patternCache = null;

    public TestMethodWithoutAssertionInspectionBase() {
        TestMethodWithoutAssertionInspectionBase.parseString(this.assertionMethods, this.classNames, this.methodNamePatterns);
    }

    @NotNull
    public String getID() {
        if ("JUnitTestMethodWithNoAssertions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "getID"));
        }
        return "JUnitTestMethodWithNoAssertions";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        TestMethodWithoutAssertionInspectionBase.parseString(this.assertionMethods, this.classNames, this.methodNamePatterns);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase", "writeSettings"));
        }
        this.assertionMethods = TestMethodWithoutAssertionInspectionBase.formatString(this.classNames, this.methodNamePatterns);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodWithoutAssertionVisitor();
    }

    private boolean methodNamesMatch(String methodName, String methodNamePattern) {
        Pattern pattern;
        if (this.patternCache != null) {
            pattern = this.patternCache.get(methodNamePattern);
        } else {
            this.patternCache = new HashMap<String, Pattern>(this.methodNamePatterns.size());
            pattern = null;
        }
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.patternCache.put(methodNamePattern, pattern);
            }
            catch (PatternSyntaxException ignore) {
                return false;
            }
            catch (NullPointerException ignore) {
                return false;
            }
        }
        if (pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(methodName);
        return matcher.matches();
    }

    private class ContainsAssertionVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsAssertion = false;

        private ContainsAssertionVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$ContainsAssertionVisitor", "visitElement"));
            }
            if (!this.containsAssertion) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$ContainsAssertionVisitor", "visitMethodCallExpression"));
            }
            if (this.containsAssertion) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            int methodNamesSize = TestMethodWithoutAssertionInspectionBase.this.methodNamePatterns.size();
            for (int i = 0; i < methodNamesSize; ++i) {
                PsiClass aClass;
                PsiMethod method;
                String pattern = TestMethodWithoutAssertionInspectionBase.this.methodNamePatterns.get(i);
                if (!TestMethodWithoutAssertionInspectionBase.this.methodNamesMatch(methodName, pattern) || (method = call.resolveMethod()) == null || method.isConstructor() || !InheritanceUtil.isInheritor((PsiClass)(aClass = method.getContainingClass()), (String)TestMethodWithoutAssertionInspectionBase.this.classNames.get(i))) continue;
                this.containsAssertion = true;
                break;
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            if (this.containsAssertion) {
                return;
            }
            super.visitAssertStatement(statement);
            if (!TestMethodWithoutAssertionInspectionBase.this.assertKeywordIsAssertion) {
                return;
            }
            this.containsAssertion = true;
        }

        public boolean containsAssertion() {
            return this.containsAssertion;
        }
    }

    private class TestMethodWithoutAssertionVisitor
    extends BaseInspectionVisitor {
        private TestMethodWithoutAssertionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$TestMethodWithoutAssertionVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            if (this.hasExpectedExceptionAnnotation(method)) {
                return;
            }
            if (this.containsAssertion((PsiElement)method)) {
                return;
            }
            if (this.lastStatementIsCallToMethodWithAssertion(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean lastStatementIsCallToMethodWithAssertion(PsiMethod method) {
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length <= 0) {
                return false;
            }
            PsiStatement lastStatement = statements[0];
            if (!(lastStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)lastStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression)) {
                return false;
            }
            PsiMethod targetMethod = methodCallExpression.resolveMethod();
            return this.containsAssertion((PsiElement)targetMethod);
        }

        private boolean containsAssertion(PsiElement element) {
            if (element == null) {
                return false;
            }
            ContainsAssertionVisitor visitor = new ContainsAssertionVisitor();
            element.accept((PsiElementVisitor)visitor);
            return visitor.containsAssertion();
        }

        private boolean hasExpectedExceptionAnnotation(PsiMethod method) {
            PsiNameValuePair[] nameValuePairs;
            PsiModifierList modifierList = method.getModifierList();
            PsiAnnotation testAnnotation = modifierList.findAnnotation("org.junit.Test");
            if (testAnnotation == null) {
                return false;
            }
            PsiAnnotationParameterList parameterList = testAnnotation.getParameterList();
            for (PsiNameValuePair nameValuePair : nameValuePairs = parameterList.getAttributes()) {
                String parameterName = nameValuePair.getName();
                if (!"expected".equals(parameterName)) continue;
                return true;
            }
            return false;
        }
    }
}

