/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.AsyncValueLoaderManager;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

public abstract class ObjectValueBase<VALUE_LOADER extends ValueManager>
extends ValueBase
implements ObjectValue {
    private static final AsyncValueLoaderManager<ObjectValueBase, List<Variable>> PROPERTIES_LOADER = new AsyncValueLoaderManager<ObjectValueBase, List<Variable>>(ObjectValueBase.class){

        public boolean isUpToDate(@NotNull ObjectValueBase host, @NotNull List<Variable> data) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/values/ObjectValueBase$1", "isUpToDate"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/debugger/values/ObjectValueBase$1", "isUpToDate"));
            }
            return ((ValueManager)host.valueManager).getCacheStamp() == host.cacheStamp;
        }

        public void load(@NotNull ObjectValueBase host, @NotNull AsyncResult<List<Variable>> result) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/values/ObjectValueBase$1", "load"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/values/ObjectValueBase$1", "load"));
            }
            host.loadProperties(result);
        }
    };
    private volatile AsyncResult<List<? extends Variable>> properties;
    private volatile int cacheStamp;
    protected final VALUE_LOADER valueManager;

    public ObjectValueBase(@NotNull ValueType type, @NotNull VALUE_LOADER valueManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/debugger/values/ObjectValueBase", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "org/jetbrains/debugger/values/ObjectValueBase", "<init>"));
        }
        super(type);
        this.cacheStamp = -1;
        this.valueManager = valueManager;
    }

    protected abstract void loadProperties(@NotNull AsyncResult<List<Variable>> var1);

    protected final void updateCacheStamp() {
        this.cacheStamp = ((ValueManager)this.valueManager).getCacheStamp();
    }

    @Override
    @NotNull
    public final AsyncResult<List<Variable>> getProperties() {
        AsyncResult asyncResult = PROPERTIES_LOADER.get((Object)this);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getProperties"));
        }
        return asyncResult;
    }

    @Override
    @Nullable
    public String getValueString() {
        return null;
    }

    @Override
    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "hasProperties"));
        }
        return threeState;
    }

    @Override
    @NotNull
    public ThreeState hasIndexedProperties() {
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "hasIndexedProperties"));
        }
        return threeState;
    }

    @Override
    @NotNull
    public ActionCallback getIndexedProperties(int from, int to, int bucketThreshold, @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/debugger/values/ObjectValueBase", "getIndexedProperties"));
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ObjectValueBase", "getIndexedProperties"));
        }
        return actionCallback;
    }

    @Override
    public int getCacheStamp() {
        return this.cacheStamp;
    }

    @Override
    public void clearCaches() {
        this.cacheStamp = -1;
        PROPERTIES_LOADER.reset((Object)this);
    }
}

