/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;

final class SubServer
implements CustomPortServerManager.CustomPortService,
Disposable {
    private final ChannelRegistrar channelRegistrar = new ChannelRegistrar();
    private final CustomPortServerManager user;
    private final ServerBootstrap bootstrap;

    public SubServer(CustomPortServerManager user, EventLoopGroup eventLoopGroup) {
        this.user = user;
        user.setManager((CustomPortServerManager.CustomPortService)this);
        this.bootstrap = BuiltInServer.createServerBootstrap(eventLoopGroup, this.channelRegistrar, user.createXmlRpcHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(int port) {
        if (!this.user.isAvailableExternally() && port == BuiltInServerManager.getInstance().getPort()) {
            return true;
        }
        try {
            this.bootstrap.localAddress((SocketAddress)(this.user.isAvailableExternally() ? new InetSocketAddress(port) : new InetSocketAddress(NetUtils.getLoopbackAddress(), port)));
            this.channelRegistrar.add(this.bootstrap.bind().syncUninterruptibly().channel());
            return true;
        }
        catch (Exception e) {
            try {
                NettyUtil.log(e, BuiltInServer.LOG);
            }
            finally {
                this.user.cannotBind(e, port);
            }
            return false;
        }
    }

    public boolean isBound() {
        return !this.channelRegistrar.isEmpty();
    }

    private void stop() {
        this.channelRegistrar.close(false);
    }

    public boolean rebind() {
        this.stop();
        return this.bind(this.user.getPort());
    }

    public void dispose() {
        this.stop();
        this.user.setManager(null);
    }
}

