/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonWriter;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.jsonProtocol.JsonWriters;
import org.jetbrains.jsonProtocol.StringWriter;

public abstract class OutMessage {
    private final StringWriter stringWriter = new StringWriter();
    public final JsonWriter writer = new JsonWriter((Writer)this.stringWriter);
    private boolean finalized;

    protected OutMessage() {
        try {
            this.writer.beginObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void beginArguments() throws IOException {
    }

    protected final void writeEnum(String name, Enum<?> value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeMap(String name, Map<String, String> value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginObject();
            for (Map.Entry<String, String> entry : value.entrySet()) {
                this.writer.name(entry.getKey()).value(entry.getValue());
            }
            this.writer.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeInt(String name, int value) {
        try {
            this.beginArguments();
            this.writer.name(name).value((long)value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeLongArray(String name, long[] value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (long v : value) {
                this.writer.value(v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeDoubleArray(String name, double[] value) {
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (double v : value) {
                this.writer.value(v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntArray(@NotNull String name, @NotNull int[] value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntArray"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntArray"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (int v : value) {
                this.writer.value((long)v);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntSet(@NotNull String name, @NotNull TIntHashSet value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntSet"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntSet"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            value.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        OutMessage.this.writer.value((long)value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            });
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeIntList(@NotNull String name, @NotNull TIntArrayList value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeIntList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jsonProtocol/OutMessage", "writeIntList"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            for (int i = 0; i < value.size(); ++i) {
                this.writer.value((long)value.getQuick(i));
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeSingletonIntArray(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jsonProtocol/OutMessage", "writeSingletonIntArray"));
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            this.writer.value((long)value);
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final <E extends OutMessage> void writeList(String name, List<E> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            this.beginArguments();
            this.writer.name(name);
            this.writer.beginArray();
            boolean isNotFirst = false;
            for (OutMessage item : value) {
                if (isNotFirst) {
                    this.stringWriter.append(',').append(' ');
                } else {
                    isNotFirst = true;
                }
                StringBuilder buffer = item.stringWriter.getBuffer();
                if (!item.finalized) {
                    item.finalized = true;
                    try {
                        item.writer.endObject();
                    }
                    catch (IllegalStateException e) {
                        if ("Nesting problem.".equals(e.getMessage())) {
                            throw new RuntimeException(item.stringWriter.getBuffer() + "\nparent:\n" + this.stringWriter.getBuffer(), e);
                        }
                        throw e;
                    }
                }
                this.stringWriter.append(buffer);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeStringList(String name, List<String> value) {
        try {
            this.beginArguments();
            JsonWriters.writeStringList(this.writer, name, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void prepareWriteRaw(OutMessage message, String name) throws IOException {
        message.writer.name(name).nullValue();
        StringBuilder myBuffer = message.stringWriter.getBuffer();
        myBuffer.delete(myBuffer.length() - "null".length(), myBuffer.length());
    }

    public static void doWriteRaw(OutMessage message, String rawValue) {
        message.stringWriter.append(rawValue);
    }

    protected final void writeMessage(String name, OutMessage value) {
        try {
            this.beginArguments();
            OutMessage.prepareWriteRaw(this, name);
            StringBuilder buffer = value.stringWriter.getBuffer();
            if (!value.finalized) {
                value.close();
            }
            this.stringWriter.append(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        assert (!this.finalized);
        this.finalized = true;
        this.writer.endObject();
        this.writer.close();
    }

    protected final void writeLong(String name, long value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeDouble(String name, double value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeBoolean(String name, boolean value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void writeString(String name, String value) {
        if (value != null) {
            this.writeNullableString(name, value);
        }
    }

    protected final void writeString(String name, CharSequence value) {
        if (value != null) {
            try {
                OutMessage.prepareWriteRaw(this, name);
                JsonUtil.escape(value, this.stringWriter.getBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected final void writeNullableString(String name, String value) {
        try {
            this.beginArguments();
            this.writer.name(name).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public final CharSequence toJson() {
        StringBuilder stringBuilder = this.stringWriter.getBuffer();
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jsonProtocol/OutMessage", "toJson"));
        }
        return stringBuilder;
    }
}

