/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;

public class AddAntBuildFile
extends AnAction {
    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        AntConfiguration antConfiguration = AntConfiguration.getInstance(project);
        try {
            antConfiguration.addBuildFile(file);
            ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.ANT_BUILD).activate(null);
        }
        catch (AntNoFileException e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = AntBundle.message("cannot.add.build.files.from.excluded.directories.error.message", e.getFile().getPresentableUrl());
            }
            Messages.showWarningDialog((Project)project, (String)message, (String)AntBundle.message("cannot.add.build.file.dialog.title", new Object[0]));
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        if (!"project".equals(rootTag.getName())) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        if (AntConfigurationBase.getInstance(project).getAntBuildFile(psiFile) != null) {
            AddAntBuildFile.disable(presentation);
            return;
        }
        AddAntBuildFile.enable(presentation);
    }

    private static void enable(Presentation presentation) {
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    private static void disable(Presentation presentation) {
        presentation.setEnabled(false);
        presentation.setVisible(false);
    }
}

