/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;

public class TestDataReferenceCollector {
    private static final String TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME = "com.intellij.testFramework.TestDataFile";
    private final String myTestDataPath;
    private final String myTestName;
    private final List<String> myLogMessages = new ArrayList<String>();
    private PsiClass myContainingClass;
    private boolean myFoundTestDataParameters = false;

    public TestDataReferenceCollector(@Nullable String testDataPath, String testName) {
        if (StringUtil.isNotEmpty((String)testDataPath) && !StringUtil.endsWithChar((CharSequence)testDataPath, (char)File.separatorChar)) {
            testDataPath = testDataPath + File.separatorChar;
        }
        this.myTestDataPath = testDataPath;
        this.myTestName = testName;
    }

    @Nullable
    List<String> collectTestDataReferences(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector", "collectTestDataReferences"));
        }
        this.myContainingClass = method.getContainingClass();
        List<String> result = this.collectTestDataReferences(method, new HashMap<String, Computable<String>>());
        if (!this.myFoundTestDataParameters) {
            this.myLogMessages.add("Found no parameters annotated with @TestDataFile");
        }
        if (result == null || result.isEmpty()) {
            result = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method);
        }
        return result;
    }

    private List<String> collectTestDataReferences(PsiMethod method, final Map<String, Computable<String>> argumentMap) {
        final ArrayList<String> result = new ArrayList<String>();
        if (this.myTestDataPath == null) {
            return result;
        }
        method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiMethod implementation;
                PsiClass calleeContainingClass;
                String callText = expression.getMethodExpression().getReferenceName();
                if (callText == null) {
                    return;
                }
                PsiMethod callee = expression.resolveMethod();
                if (callee != null && callee.hasModifierProperty("abstract") && (calleeContainingClass = callee.getContainingClass()) != null && TestDataReferenceCollector.this.myContainingClass.isInheritor(calleeContainingClass, true) && (implementation = TestDataReferenceCollector.this.myContainingClass.findMethodBySignature(callee, true)) != null) {
                    callee = implementation;
                }
                if (callee != null) {
                    boolean haveAnnotatedParameters = false;
                    PsiParameter[] psiParameters = callee.getParameterList().getParameters();
                    int psiParametersLength = psiParameters.length;
                    for (int i = 0; i < psiParametersLength; ++i) {
                        PsiParameter psiParameter = psiParameters[i];
                        PsiModifierList modifierList = psiParameter.getModifierList();
                        if (modifierList == null || modifierList.findAnnotation(TestDataReferenceCollector.TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME) == null) continue;
                        TestDataReferenceCollector.this.myFoundTestDataParameters = true;
                        TestDataReferenceCollector.this.processCallArgument(expression, argumentMap, result, i);
                        haveAnnotatedParameters = true;
                    }
                    if (expression.getMethodExpression().getQualifierExpression() == null && !haveAnnotatedParameters) {
                        result.addAll(TestDataReferenceCollector.this.collectTestDataReferences(callee, TestDataReferenceCollector.this.buildArgumentMap(expression, callee)));
                    }
                }
            }
        });
        return result;
    }

    private void processCallArgument(PsiMethodCallExpression expression, Map<String, Computable<String>> argumentMap, List<String> result, int index) {
        String testDataFile;
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length > index && (testDataFile = this.evaluate(arguments[index], argumentMap)) != null) {
            result.add(this.myTestDataPath + testDataFile);
        }
    }

    private Map<String, Computable<String>> buildArgumentMap(PsiMethodCallExpression expression, PsiMethod method) {
        HashMap<String, Computable<String>> result = new HashMap<String, Computable<String>>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        final PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        for (int i = 0; i < arguments.length && i < parameters.length; ++i) {
            final int finalI = i;
            result.put(parameters[i].getName(), (Computable<String>)new NullableComputable<String>(){

                public String compute() {
                    return TestDataReferenceCollector.this.evaluate(arguments[finalI], Collections.emptyMap());
                }
            });
        }
        return result;
    }

    @Nullable
    private String evaluate(PsiExpression expression, Map<String, Computable<String>> arguments) {
        PsiExpression[] psiExpressions;
        PsiMethodCallExpression methodCall;
        String callText;
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
            if (binaryExpression.getOperationTokenType() == JavaTokenType.PLUS) {
                String r = "";
                for (PsiExpression op : binaryExpression.getOperands()) {
                    String lhs = this.evaluate(op, arguments);
                    if (lhs == null) {
                        return null;
                    }
                    r = r + lhs;
                }
                return r;
            }
        } else if (expression instanceof PsiLiteralExpression) {
            Object value = ((PsiLiteralExpression)expression).getValue();
            if (value instanceof String) {
                return (String)value;
            }
        } else if (expression instanceof PsiReferenceExpression) {
            PsiExpression initializer;
            PsiElement result = ((PsiReferenceExpression)expression).resolve();
            if (result instanceof PsiParameter) {
                String name = ((PsiParameter)result).getName();
                Computable<String> arg = arguments.get(name);
                return arg == null ? null : (String)arg.compute();
            }
            if (result instanceof PsiVariable && (initializer = ((PsiVariable)result).getInitializer()) != null) {
                return this.evaluate(initializer, arguments);
            }
        } else if (expression instanceof PsiMethodCallExpression && (callText = (methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getText()).equals("getTestName") && (psiExpressions = methodCall.getArgumentList().getExpressions()).length == 1) {
            if ("true".equals(psiExpressions[0].getText()) && !StringUtil.isEmpty((String)this.myTestName)) {
                return UsefulTestCase.lowercaseFirstLetter((String)this.myTestName, (boolean)true);
            }
            return this.myTestName;
        }
        if (expression != null) {
            this.myLogMessages.add("Failed to evaluate " + expression.getText());
        }
        return null;
    }

    public String getLog() {
        return StringUtil.join(this.myLogMessages, (String)"\n");
    }
}

