/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;

public class InvocationExprent
extends Exprent {
    public static final int INVOKE_SPECIAL = 1;
    public static final int INVOKE_VIRTUAL = 2;
    public static final int INVOKE_STATIC = 3;
    public static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYP_GENERAL = 1;
    public static final int TYP_INIT = 2;
    public static final int TYP_CLINIT = 3;
    public static final int CONSTRUCTOR_NOT = 0;
    public static final int CONSTRUCTOR_THIS = 1;
    public static final int CONSTRUCTOR_SUPER = 2;
    private String name;
    private String classname;
    private boolean isStatic;
    private int functype = 1;
    private Exprent instance;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invoke_dynamic_classsuffix;
    private int invocationTyp = 2;
    private List<Exprent> lstParameters = new ArrayList<Exprent>();

    public InvocationExprent() {
        this.type = 8;
    }

    public InvocationExprent(int opcode, LinkConstant cn, ListStack<Exprent> stack, int dynamic_invokation_type) {
        this.type = 8;
        this.name = cn.elementname;
        this.classname = cn.classname;
        switch (opcode) {
            case 184: {
                this.invocationTyp = 3;
                break;
            }
            case 183: {
                this.invocationTyp = 1;
                break;
            }
            case 182: {
                this.invocationTyp = 2;
                break;
            }
            case 185: {
                this.invocationTyp = 4;
                break;
            }
            case 186: {
                this.invocationTyp = 5;
                this.classname = "java/lang/Class";
                this.invoke_dynamic_classsuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.functype = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.functype = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (int i = 0; i < this.descriptor.params.length; ++i) {
            this.lstParameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            if (dynamic_invokation_type == 6) {
                this.isStatic = true;
            } else {
                this.instance = this.lstParameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
    }

    private InvocationExprent(InvocationExprent expr) {
        this.type = 8;
        this.name = expr.getName();
        this.classname = expr.getClassname();
        this.isStatic = expr.isStatic();
        this.functype = expr.getFunctype();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationTyp = expr.getInvocationTyp();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        this.lstParameters = new ArrayList<Exprent>(expr.getLstParameters());
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            this.lstParameters.set(i, this.lstParameters.get(i).copy());
        }
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            Exprent parameter = this.lstParameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.type_family));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.lstParameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        int start;
        ClassesProcessor.ClassNode newNode;
        StringBuilder buf = new StringBuilder("");
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.invocationTyp != 5) {
            if (this.isStatic) {
                ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
                if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                    buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
                }
            } else {
                if (this.instance != null && this.instance.type == 12) {
                    MethodWrapper current_meth;
                    VarExprent instvar = (VarExprent)this.instance;
                    VarVersionPaar varpaar = new VarVersionPaar(instvar);
                    VarProcessor vproc = instvar.getProcessor();
                    if (vproc == null && (current_meth = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                        vproc = current_meth.varproc;
                    }
                    String this_classname = null;
                    if (vproc != null) {
                        this_classname = vproc.getThisvars().get(varpaar);
                    }
                    if (this_classname != null) {
                        isInstanceThis = true;
                        if (this.invocationTyp == 1 && !this.classname.equals(this_classname)) {
                            super_qualifier = this_classname;
                        }
                    }
                }
                if (this.functype == 1) {
                    if (super_qualifier != null) {
                        StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                        if (!super_qualifier.equals(current_class.qualifiedName)) {
                            buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(super_qualifier)));
                            buf.append(".");
                        }
                        buf.append("super");
                    } else {
                        String res = this.instance.toJava(indent, tracer);
                        VarType rightType = this.instance.getExprType();
                        VarType leftType = new VarType(8, 0, this.classname);
                        if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                            buf.append("((").append(ExprProcessor.getCastTypeName(leftType)).append(")");
                            if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                                res = "(" + res + ")";
                            }
                            buf.append(res).append(")");
                        } else if (this.instance.getPrecedence() > this.getPrecedence()) {
                            buf.append("(").append(res).append(")");
                        } else {
                            buf.append(res);
                        }
                    }
                }
            }
        }
        switch (this.functype) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new StringBuilder("");
                }
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(this.name);
                if (this.invocationTyp == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicite invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                buf.append(this.instance.toJava(indent, tracer));
                buf.append(".<init>(");
            }
        }
        List<VarVersionPaar> sigFields = null;
        boolean isEnum = false;
        if (this.functype == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname)) != null) {
            if (newNode.wrapper != null) {
                sigFields = newNode.wrapper.getMethodWrapper((String)"<init>", (String)this.stringDescriptor).signatureFields;
            } else if (newNode.type == 1 && (newNode.access & 8) == 0) {
                sigFields = new ArrayList<VarVersionPaar>(Collections.nCopies(this.lstParameters.size(), null));
                sigFields.set(0, new VarVersionPaar(-1, 0));
            }
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        Set<Integer> setAmbiguousParameters = this.getAmbiguousParameters();
        boolean firstpar = true;
        for (int i = start = isEnum ? 2 : 0; i < this.lstParameters.size(); ++i) {
            if (sigFields != null && sigFields.get(i) != null) continue;
            if (!firstpar) {
                buf.append(", ");
            }
            StringBuilder buff = new StringBuilder();
            ExprProcessor.getCastedExprent(this.lstParameters.get(i), this.descriptor.params[i], buff, indent, true, setAmbiguousParameters.contains(i), tracer);
            buf.append((CharSequence)buff);
            firstpar = false;
        }
        buf.append(")");
        return buf.toString();
    }

    private Set<Integer> getAmbiguousParameters() {
        HashSet<Integer> ret = new HashSet<Integer>();
        StructClass cstr = DecompilerContext.getStructContext().getClass(this.classname);
        if (cstr != null) {
            ArrayList<MethodDescriptor> lstMethods = new ArrayList<MethodDescriptor>();
            for (StructMethod meth : cstr.getMethods()) {
                if (!this.name.equals(meth.getName())) continue;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(meth.getDescriptor());
                if (md.params.length != this.descriptor.params.length) continue;
                boolean equals = true;
                for (int i = 0; i < md.params.length; ++i) {
                    if (md.params[i].type_family == this.descriptor.params[i].type_family) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                lstMethods.add(md);
            }
            if (lstMethods.size() > 1) {
                block2: for (int i = 0; i < this.descriptor.params.length; ++i) {
                    VarType partype = this.descriptor.params[i];
                    for (MethodDescriptor md : lstMethods) {
                        if (partype.equals(md.params[i])) continue;
                        ret.add(i);
                        continue block2;
                    }
                }
            }
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return InterpreterUtil.equalObjects(this.name, it.getName()) && InterpreterUtil.equalObjects(this.classname, it.getClassname()) && this.isStatic == it.isStatic() && InterpreterUtil.equalObjects(this.instance, it.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, it.getDescriptor()) && this.functype == it.getFunctype() && InterpreterUtil.equalLists(this.lstParameters, it.getLstParameters());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.instance) {
            this.instance = newexpr;
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            if (oldexpr != this.lstParameters.get(i)) continue;
            this.lstParameters.set(i, newexpr);
        }
    }

    public List<Exprent> getLstParameters() {
        return this.lstParameters;
    }

    public void setLstParameters(List<Exprent> lstParameters) {
        this.lstParameters = lstParameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public int getFunctype() {
        return this.functype;
    }

    public void setFunctype(int functype) {
        this.functype = functype;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationTyp() {
        return this.invocationTyp;
    }

    public void setInvocationTyp(int invocationTyp) {
        this.invocationTyp = invocationTyp;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invoke_dynamic_classsuffix;
    }
}

