/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.renamer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.modules.renamer.ClassWrapperNode;
import org.jetbrains.java.decompiler.modules.renamer.ConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class IdentifierConverter {
    private StructContext context;
    private IIdentifierRenamer helper;
    private PoolInterceptor interceptor;
    private List<ClassWrapperNode> rootClasses = new ArrayList<ClassWrapperNode>();
    private List<ClassWrapperNode> rootInterfaces = new ArrayList<ClassWrapperNode>();
    private HashMap<String, HashMap<String, String>> interfaceNameMaps = new HashMap();

    public void rename(StructContext context) {
        try {
            this.context = context;
            String user_class = (String)DecompilerContext.getProperty("urc");
            if (user_class != null) {
                try {
                    this.helper = (IIdentifierRenamer)IdentifierConverter.class.getClassLoader().loadClass(user_class).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.helper == null) {
                this.helper = new ConverterHelper();
            }
            this.interceptor = new PoolInterceptor(this.helper);
            this.buildInheritanceTree();
            this.renameAllClasses();
            this.renameInterfaces();
            this.renameClasses();
            DecompilerContext.setPoolInterceptor(this.interceptor);
            context.reloadContext();
        }
        catch (IOException ex) {
            throw new RuntimeException("Renaming failed!");
        }
    }

    private void renameClasses() {
        List<ClassWrapperNode> lstClasses = IdentifierConverter.getReversePostOrderListIterative(this.rootClasses);
        HashMap<String, HashMap<String, String>> classNameMaps = new HashMap<String, HashMap<String, String>>();
        for (ClassWrapperNode node : lstClasses) {
            HashMap mapClass;
            StructClass cl = node.getClassStruct();
            HashMap<String, String> names = new HashMap<String, String>();
            if (cl.superClass != null && (mapClass = (HashMap)classNameMaps.get(cl.superClass.getString())) != null) {
                names.putAll(mapClass);
            }
            for (String intrName : cl.getInterfaceNames()) {
                HashMap<String, String> mapInt = this.interfaceNameMaps.get(intrName);
                if (mapInt != null) {
                    names.putAll(mapInt);
                    continue;
                }
                StructClass clintr = this.context.getClass(intrName);
                if (clintr == null) continue;
                names.putAll(this.processExternalInterface(clintr));
            }
            this.renameClassIdentifiers(cl, names);
            if (node.getSubclasses().isEmpty()) continue;
            classNameMaps.put(cl.qualifiedName, names);
        }
    }

    private HashMap<String, String> processExternalInterface(StructClass cl) {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String intrName : cl.getInterfaceNames()) {
            HashMap<String, String> mapInt = this.interfaceNameMaps.get(intrName);
            if (mapInt != null) {
                names.putAll(mapInt);
                continue;
            }
            StructClass clintr = this.context.getClass(intrName);
            if (clintr == null) continue;
            names.putAll(this.processExternalInterface(clintr));
        }
        this.renameClassIdentifiers(cl, names);
        return names;
    }

    private void renameInterfaces() {
        List<ClassWrapperNode> lstInterfaces = IdentifierConverter.getReversePostOrderListIterative(this.rootInterfaces);
        HashMap<String, HashMap<String, String>> interfaceNameMaps = new HashMap<String, HashMap<String, String>>();
        for (ClassWrapperNode node : lstInterfaces) {
            StructClass cl = node.getClassStruct();
            HashMap<String, String> names = new HashMap<String, String>();
            for (String intrName : cl.getInterfaceNames()) {
                HashMap mapInt = (HashMap)interfaceNameMaps.get(intrName);
                if (mapInt == null) continue;
                names.putAll(mapInt);
            }
            this.renameClassIdentifiers(cl, names);
            interfaceNameMaps.put(cl.qualifiedName, names);
        }
        this.interfaceNameMaps = interfaceNameMaps;
    }

    private void renameAllClasses() {
        ArrayList<ClassWrapperNode> lstAllClasses = new ArrayList<ClassWrapperNode>(IdentifierConverter.getReversePostOrderListIterative(this.rootInterfaces));
        lstAllClasses.addAll(IdentifierConverter.getReversePostOrderListIterative(this.rootClasses));
        for (ClassWrapperNode node : lstAllClasses) {
            this.renameClass(node.getClassStruct());
        }
    }

    private void renameClass(StructClass cl) {
        if (!cl.isOwn()) {
            return;
        }
        String classOldFullName = cl.qualifiedName;
        String clsimplename = ConverterHelper.getSimpleClassName(classOldFullName);
        if (this.helper.toBeRenamed(1, clsimplename, null, null)) {
            String classNewFullName;
            do {
                classNewFullName = ConverterHelper.replaceSimpleClassName(classOldFullName, this.helper.getNextClassname(classOldFullName, ConverterHelper.getSimpleClassName(classOldFullName)));
            } while (this.context.getClasses().containsKey(classNewFullName));
            this.interceptor.addName(classOldFullName, classNewFullName);
        }
    }

    private void renameClassIdentifiers(StructClass cl, HashMap<String, String> names) {
        String classOldFullName = cl.qualifiedName;
        String classNewFullName = this.interceptor.getName(classOldFullName);
        if (classNewFullName == null) {
            classNewFullName = classOldFullName;
        }
        HashSet<String> setMethodNames = new HashSet<String>();
        for (StructMethod md : cl.getMethods()) {
            setMethodNames.add(md.getName());
        }
        VBStyleCollection<StructMethod, String> methods = cl.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            StructMethod mt = (StructMethod)methods.get(i);
            String key = methods.getKey(i);
            boolean isPrivate = mt.hasModifier(2);
            String name = mt.getName();
            if (!cl.isOwn() || mt.hasModifier(256)) {
                if (isPrivate) continue;
                names.put(key, name);
                continue;
            }
            if (!this.helper.toBeRenamed(3, classOldFullName, name, mt.getDescriptor())) continue;
            if (isPrivate || !names.containsKey(key)) {
                while (setMethodNames.contains(name = this.helper.getNextMethodname(classOldFullName, name, mt.getDescriptor()))) {
                }
                if (!isPrivate) {
                    names.put(key, name);
                }
            } else {
                name = names.get(key);
            }
            this.interceptor.addName(classOldFullName + " " + mt.getName() + " " + mt.getDescriptor(), classNewFullName + " " + name + " " + this.buildNewDescriptor(false, mt.getDescriptor()));
        }
        if (!cl.isOwn()) {
            return;
        }
        HashSet<String> setFieldNames = new HashSet<String>();
        for (StructField fd : cl.getFields()) {
            setFieldNames.add(fd.getName());
        }
        for (StructField fd : cl.getFields()) {
            String newname;
            if (!this.helper.toBeRenamed(2, classOldFullName, fd.getName(), fd.getDescriptor())) continue;
            while (setFieldNames.contains(newname = this.helper.getNextFieldname(classOldFullName, fd.getName(), fd.getDescriptor()))) {
            }
            this.interceptor.addName(classOldFullName + " " + fd.getName() + " " + fd.getDescriptor(), classNewFullName + " " + newname + " " + this.buildNewDescriptor(true, fd.getDescriptor()));
        }
    }

    private String buildNewDescriptor(boolean isField, String descriptor) {
        boolean updated = false;
        if (isField) {
            String newclname;
            FieldDescriptor fd = FieldDescriptor.parseDescriptor(descriptor);
            VarType ftype = fd.type;
            if (ftype.type == 8 && (newclname = this.interceptor.getName(ftype.value)) != null) {
                ftype.value = newclname;
                updated = true;
            }
            if (updated) {
                return fd.getDescriptor();
            }
        } else {
            String newclname;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(descriptor);
            for (VarType partype : md.params) {
                String newclname2;
                if (partype.type != 8 || (newclname2 = this.interceptor.getName(partype.value)) == null) continue;
                partype.value = newclname2;
                updated = true;
            }
            if (md.ret.type == 8 && (newclname = this.interceptor.getName(md.ret.value)) != null) {
                md.ret.value = newclname;
                updated = true;
            }
            if (updated) {
                return md.getDescriptor();
            }
        }
        return descriptor;
    }

    private static List<ClassWrapperNode> getReversePostOrderListIterative(List<ClassWrapperNode> roots) {
        ArrayList<ClassWrapperNode> res = new ArrayList<ClassWrapperNode>();
        LinkedList<ClassWrapperNode> stackNode = new LinkedList<ClassWrapperNode>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<ClassWrapperNode> setVisited = new HashSet<ClassWrapperNode>();
        for (ClassWrapperNode root : roots) {
            stackNode.add(root);
            stackIndex.add(0);
        }
        while (!stackNode.isEmpty()) {
            int index;
            ClassWrapperNode node = (ClassWrapperNode)stackNode.getLast();
            setVisited.add(node);
            List<ClassWrapperNode> lstSubs = node.getSubclasses();
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstSubs.size(); ++index) {
                ClassWrapperNode sub = lstSubs.get(index);
                if (setVisited.contains(sub)) continue;
                stackIndex.add(index + 1);
                stackNode.add(sub);
                stackIndex.add(0);
                break;
            }
            if (index != lstSubs.size()) continue;
            res.add(0, node);
            stackNode.removeLast();
        }
        return res;
    }

    private void buildInheritanceTree() {
        HashMap<String, ClassWrapperNode> nodes = new HashMap<String, ClassWrapperNode>();
        Map<String, StructClass> classes = this.context.getClasses();
        ArrayList<ClassWrapperNode> rootClasses = new ArrayList<ClassWrapperNode>();
        ArrayList<ClassWrapperNode> rootInterfaces = new ArrayList<ClassWrapperNode>();
        block0: for (StructClass cl : classes.values()) {
            if (!cl.isOwn()) continue;
            LinkedList<StructClass> stack = new LinkedList<StructClass>();
            LinkedList<ClassWrapperNode> stackSubnodes = new LinkedList<ClassWrapperNode>();
            stack.add(cl);
            stackSubnodes.add(null);
            while (!stack.isEmpty()) {
                StructClass clparent;
                boolean isNewNode;
                StructClass clstr = (StructClass)stack.removeFirst();
                ClassWrapperNode child = (ClassWrapperNode)stackSubnodes.removeFirst();
                ClassWrapperNode node = (ClassWrapperNode)nodes.get(clstr.qualifiedName);
                boolean bl = isNewNode = node == null;
                if (isNewNode) {
                    node = new ClassWrapperNode(clstr);
                    nodes.put(clstr.qualifiedName, node);
                }
                if (child != null) {
                    node.addSubclass(child);
                }
                if (!isNewNode) continue block0;
                boolean isInterface = clstr.hasModifier(512);
                boolean found_parent = false;
                if (isInterface) {
                    for (String intrName : clstr.getInterfaceNames()) {
                        StructClass clparent2 = classes.get(intrName);
                        if (clparent2 == null) continue;
                        stack.add(clparent2);
                        stackSubnodes.add(node);
                        found_parent = true;
                    }
                } else if (clstr.superClass != null && (clparent = classes.get(clstr.superClass.getString())) != null) {
                    stack.add(clparent);
                    stackSubnodes.add(node);
                    found_parent = true;
                }
                if (found_parent) continue;
                (isInterface ? rootInterfaces : rootClasses).add(node);
            }
        }
        this.rootClasses = rootClasses;
        this.rootInterfaces = rootInterfaces;
    }
}

