/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.wizard.AssetStudioWizard;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import icons.AndroidIcons;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidAssetStudioAction
extends AnAction {
    public AndroidAssetStudioAction() {
        super("Image Asset", "Open Asset Studio to create an image asset", AndroidIcons.Android);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(AndroidAssetStudioAction.isAvailable(e.getDataContext()));
    }

    private static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return module != null && view != null && view.getDirectories().length != 0 && AndroidFacet.getInstance(module) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile targetFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        AssetStudioWizard dialog = new AssetStudioWizard(project, module, targetFile);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.createAssets();
    }
}

