/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.eclipse.ImportSummary;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;

abstract class ImportModule
implements Comparable<ImportModule> {
    private static final String SHERLOCK_DEP = "com.actionbarsherlock:actionbarsherlock:4.4.0@aar";
    private static final String PLAY_SERVICES_DEP = "com.google.android.gms:play-services:+";
    private static final String SUPPORT_GROUP_ID = "com.android.support";
    public static final String APPCOMPAT_ARTIFACT = "appcompat-v7";
    public static final String SUPPORT_ARTIFACT = "support-v4";
    public static final String GRIDLAYOUT_ARTIFACT = "gridlayout-v7";
    public static final String MEDIA_ROUTER_ARTIFACT = "mediarouter-v7";
    protected final GradleImport myImporter;
    protected final List<GradleCoordinate> myDependencies = Lists.newArrayList();
    protected final List<GradleCoordinate> myTestDependencies = Lists.newArrayList();
    protected final List<File> myJarDependencies = Lists.newArrayList();
    protected final List<File> myTestJarDependencies = Lists.newArrayList();
    protected List<GradleCoordinate> myReplaceWithDependencies;
    private String myModuleName;

    public ImportModule(@NonNull GradleImport importer) {
        this.myImporter = importer;
    }

    protected static File getTestJarOutputRelativePath(File jar) {
        return new File("libs", jar.getName());
    }

    private static void recordCopiedFile(@NonNull Set<File> copied, @NonNull File file) throws IOException {
        copied.add(file);
        copied.add(file.getCanonicalFile());
    }

    protected abstract boolean isLibrary();

    protected abstract boolean isApp();

    protected abstract boolean isAndroidLibrary();

    protected abstract boolean isAndroidProject();

    protected abstract boolean isJavaLibrary();

    protected abstract boolean isNdkProject();

    @NonNull
    protected abstract AndroidVersion getCompileSdkVersion();

    @NonNull
    protected abstract AndroidVersion getMinSdkVersion();

    @NonNull
    protected abstract AndroidVersion getTargetSdkVersion();

    @Nullable
    protected abstract String getAddOn();

    @NonNull
    public abstract File getDir();

    @NonNull
    protected abstract String getOriginalName();

    @NonNull
    protected abstract List<File> getSourcePaths();

    @NonNull
    protected abstract List<File> getJarPaths();

    @NonNull
    protected abstract List<File> getTestJarPaths();

    @NonNull
    protected abstract List<File> getNativeLibs();

    @NonNull
    protected abstract File resolveFile(@NonNull File var1);

    @NonNull
    protected abstract File getCanonicalModuleDir();

    @NonNull
    protected abstract List<File> getLocalProguardFiles();

    @NonNull
    protected abstract List<File> getSdkProguardFiles();

    @NonNull
    protected abstract String getLanguageLevel();

    @NonNull
    protected abstract List<ImportModule> getDirectDependencies();

    @NonNull
    protected abstract List<ImportModule> getAllDependencies();

    @Nullable
    protected abstract String getPackage();

    @Nullable
    protected abstract File getLintXml();

    @Nullable
    protected abstract File getOutputDir();

    @Nullable
    protected abstract File getManifestFile();

    @Nullable
    protected abstract File getResourceDir();

    @Nullable
    protected abstract File getAssetsDir();

    @Nullable
    protected abstract File getNativeSources();

    @Nullable
    protected abstract String getNativeModuleName();

    @Nullable
    protected abstract File getInstrumentationDir();

    @Nullable
    protected abstract Charset getFileEncoding(@NonNull File var1);

    @Nullable
    protected abstract Charset getProjectEncoding(@NonNull File var1);

    public void initialize() {
        this.initDependencies();
        this.initReplaceWithDependency();
    }

    protected void initDependencies() {
    }

    @Nullable
    public GradleCoordinate getLatestVersion(String artifact) {
        int compileVersion = 21;
        AndroidVersion version = this.getCompileSdkVersion();
        if (version != AndroidVersion.DEFAULT) {
            compileVersion = version.getFeatureLevel();
        }
        if (compileVersion < 18) {
            compileVersion = 18;
        }
        String compileVersionString = Integer.toString(compileVersion);
        if (this.myImporter.getSdkLocation() != null) {
            String filter = compileVersionString;
            GradleCoordinate max = SdkMavenRepository.ANDROID.getHighestInstalledVersion(this.myImporter.getSdkLocation(), SUPPORT_GROUP_ID, artifact, filter, true);
            if (max != null) {
                return max;
            }
        }
        String coordinate = "com.android.support:" + artifact + ':' + compileVersionString + ".+";
        return GradleCoordinate.parseCoordinateString((String)coordinate);
    }

    @Nullable
    protected GradleCoordinate getAppCompatDependency() {
        return this.getLatestVersion(APPCOMPAT_ARTIFACT);
    }

    @Nullable
    protected GradleCoordinate getSupportLibDependency() {
        return this.getLatestVersion(SUPPORT_ARTIFACT);
    }

    @Nullable
    protected GradleCoordinate getGridLayoutDependency() {
        return this.getLatestVersion(GRIDLAYOUT_ARTIFACT);
    }

    @Nullable
    protected GradleCoordinate getMediaRouterDependency() {
        return this.getLatestVersion(MEDIA_ROUTER_ARTIFACT);
    }

    @Nullable
    GradleCoordinate guessDependency(@NonNull File jar) {
        String name = jar.getName().toLowerCase(Locale.US);
        if (name.equals("android-support-v4.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getSupportLibDependency();
        }
        if (name.equals("android-support-v7-gridlayout.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getGridLayoutDependency();
        }
        if (name.equals("android-support-v7-appcompat.jar")) {
            this.myImporter.markJarHandled(jar);
            return this.getAppCompatDependency();
        }
        if (name.equals("com_actionbarsherlock.jar") || name.equalsIgnoreCase("actionbarsherlock.jar")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP);
        }
        if (name.equals("guava.jar") || name.startsWith("guava-")) {
            this.myImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "guava-", name, "17.0");
            if (version.startsWith("r")) {
                version = "15.0";
            }
            return GradleCoordinate.parseCoordinateString((String)("com.google.guava:guava:" + version));
        }
        if (name.startsWith("joda-time")) {
            this.myImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "joda-time-", name, "2.4");
            return GradleCoordinate.parseCoordinateString((String)("joda-time:joda-time:" + version));
        }
        if (name.startsWith("robotium-solo-")) {
            this.myImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "robotium-solo-", name, "5.2.1");
            return GradleCoordinate.parseCoordinateString((String)("com.jayway.android.robotium:robotium-solo:" + version));
        }
        if (name.startsWith("protobuf-java-")) {
            this.myImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "protobuf-java-", name, "2.5");
            return GradleCoordinate.parseCoordinateString((String)("com.google.protobuf:protobuf-java:" + version));
        }
        if (name.startsWith("gson-")) {
            this.myImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "gson-", name, "2.3");
            return GradleCoordinate.parseCoordinateString((String)("com.google.code.gson:gson:" + version));
        }
        if (name.startsWith("google-http-client-gson-")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.google.http-client:google-http-client-gson:1.19.0");
        }
        if (name.startsWith("svg-android")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.github.japgolly.android:svg-android:2.0.5");
        }
        if (name.equals("gcm.jar")) {
            this.myImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP);
        }
        return null;
    }

    private String getVersion(File jar, String prefix, String jarName, String defaultVersion) {
        if (jarName.matches(prefix + "([\\d\\.]+)\\.jar")) {
            String version = jarName.substring(prefix.length(), jarName.length() - 4);
            if (!defaultVersion.equals(version)) {
                this.myImporter.getSummary().reportGuessedVersion(jar);
            }
            return version;
        }
        return defaultVersion;
    }

    private void initReplaceWithDependency() {
        String pkg;
        if (this.isLibrary() && this.myImporter.isReplaceLibs() && (pkg = this.getPackage()) != null) {
            if (pkg.equals("com.actionbarsherlock")) {
                this.myReplaceWithDependencies = Arrays.asList(GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP), this.getSupportLibDependency());
            } else if (pkg.equals("android.support.v7.gridlayout")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getGridLayoutDependency());
            } else if (pkg.equals("com.google.android.gms")) {
                this.myReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP));
            } else if (pkg.equals("android.support.v7.appcompat")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getAppCompatDependency());
            } else if (pkg.equals("android.support.v7.mediarouter")) {
                this.myReplaceWithDependencies = Collections.singletonList(this.getMediaRouterDependency());
            }
            if (this.myReplaceWithDependencies != null) {
                this.myImporter.getSummary().reportReplacedLib(this.getOriginalName(), this.myReplaceWithDependencies);
            }
        }
    }

    public boolean isReplacedWithDependency() {
        return this.myReplaceWithDependencies != null && !this.myReplaceWithDependencies.isEmpty();
    }

    public List<GradleCoordinate> getReplaceWithDependencies() {
        return this.myReplaceWithDependencies;
    }

    public String getModuleName() {
        if (this.myModuleName == null) {
            if (this.myImporter.isGradleNameStyle() && !this.myImporter.isImportIntoExisting() && this.myImporter.getModuleCount() == 1) {
                this.myModuleName = "app";
                return this.myModuleName;
            }
            String string = this.getOriginalName();
            StringBuilder sb = new StringBuilder(string.length());
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) continue;
                sb.append(c);
            }
            String moduleName = sb.toString();
            if (!moduleName.isEmpty() && !Character.isJavaIdentifierStart(moduleName.charAt(0))) {
                moduleName = '_' + moduleName;
            }
            if (this.myImporter.isGradleNameStyle() && !moduleName.isEmpty()) {
                moduleName = Character.toLowerCase(moduleName.charAt(0)) + moduleName.substring(1);
            }
            this.myModuleName = moduleName;
        }
        return this.myModuleName;
    }

    public void setModuleName(String name) {
        this.myModuleName = name;
    }

    public void pickUniqueName(@NonNull File projectDir) {
        String name;
        int length;
        assert (projectDir.exists()) : projectDir;
        String preferredName = this.getModuleName();
        int lastDigit = length = preferredName.length();
        int i = length - 1;
        while (i >= 1 && Character.isDigit(preferredName.charAt(i))) {
            lastDigit = i--;
        }
        int startingNumber = 2;
        if (lastDigit < length) {
            startingNumber = Integer.parseInt(preferredName.substring(lastDigit)) + 1;
            preferredName = preferredName.substring(0, lastDigit);
        }
        int i2 = startingNumber;
        while (true) {
            if (!new File(projectDir, name = preferredName + i2).exists()) break;
            ++i2;
        }
        this.myModuleName = name;
    }

    public String getModuleReference() {
        String moduleName = this.getModuleName();
        StringBuilder builder = new StringBuilder(moduleName.length() + 1);
        for (File file = new File(moduleName); file != null; file = file.getParentFile()) {
            builder.insert(0, file.getName());
            builder.insert(0, ':');
        }
        return builder.toString();
    }

    protected File getJarOutputRelativePath(File jar) {
        if (jar.isAbsolute()) {
            File relative;
            try {
                relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), jar);
            }
            catch (IOException ioe) {
                relative = null;
            }
            jar = relative != null ? relative : new File("libs", jar.getName());
        }
        return jar;
    }

    public void copyInto(@NonNull File destDir) throws IOException {
        File instrumentation;
        ImportSummary summary = this.myImporter.getSummary();
        HashSet copied = Sets.newHashSet();
        final File main = new File(destDir, "src" + File.separator + "main");
        this.myImporter.mkdirs(main);
        if (this.isAndroidProject()) {
            File lintXml;
            File srcAssets;
            File srcRes;
            File srcManifest = this.getManifestFile();
            if (srcManifest != null && srcManifest.exists()) {
                File destManifest = new File(main, "AndroidManifest.xml");
                this.myImporter.copyTextFile(this, srcManifest, destManifest);
                summary.reportMoved(this, srcManifest, destManifest);
                ImportModule.recordCopiedFile(copied, srcManifest);
            }
            if ((srcRes = this.getResourceDir()) != null && srcRes.exists()) {
                File destRes = new File(main, "res");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcRes, destRes, new GradleImport.CopyHandler(){

                    @Override
                    public boolean handle(@NonNull File source, @NonNull File dest, boolean updateEncoding, @Nullable ImportModule sourceModule) throws IOException {
                        String name;
                        int dot;
                        ResourceFolderType folderType;
                        File parentFile;
                        if (ImportModule.hasUpperCaseExtension(dest) && !GradleImport.isIgnoredFile(source) && (parentFile = source.getParentFile()) != null && (folderType = ResourceFolderType.getFolderType((String)parentFile.getName())) != ResourceFolderType.VALUES && (dot = (name = dest.getName()).indexOf(46)) != -1) {
                            name = name.substring(0, dot) + name.substring(dot).toLowerCase(Locale.US);
                            File destParent = dest.getParentFile();
                            File file = dest = destParent != null ? new File(destParent, name) : new File(name);
                            if (updateEncoding && GradleImport.isTextFile(source)) {
                                ImportModule.this.myImporter.copyTextFile(sourceModule, source, dest);
                            } else {
                                Files.copy((File)source, (File)dest);
                            }
                            if (sourceModule != null) {
                                ImportModule.this.myImporter.getSummary().reportMoved(sourceModule, new File(source.getName()), new File(name));
                            }
                            return true;
                        }
                        return false;
                    }
                }, true, this);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcAssets = this.getAssetsDir()) != null && srcAssets.exists()) {
                File destAssets = new File(main, "assets");
                this.myImporter.mkdirs(destAssets);
                this.myImporter.copyDir(srcAssets, destAssets, null, false, null);
                summary.reportMoved(this, srcAssets, destAssets);
                ImportModule.recordCopiedFile(copied, srcAssets);
            }
            if ((lintXml = this.getLintXml()) != null) {
                File destLintXml = new File(destDir, lintXml.getName());
                this.myImporter.copyTextFile(this, lintXml, destLintXml);
                summary.reportMoved(this, lintXml, destLintXml);
                ImportModule.recordCopiedFile(copied, lintXml);
            }
        }
        for (File src : this.getSourcePaths()) {
            final File srcJava = this.resolveFile(src);
            File destJava = new File(main, "java");
            if (srcJava.isDirectory()) {
                this.myImporter.mkdirs(destJava);
            } else {
                destJava = new File(main, srcJava.getName());
            }
            this.myImporter.copyDir(srcJava, destJava, new GradleImport.CopyHandler(){

                @Override
                public boolean handle(@NonNull File source, @NonNull File dest, boolean updateEncoding, @Nullable ImportModule sourceModule) throws IOException {
                    String sourcePath = source.getPath();
                    if (sourcePath.endsWith(".aidl")) {
                        File aidlDir = new File(main, "aidl");
                        File relative = GradleImport.computeRelativePath(srcJava, source);
                        if (relative == null) {
                            relative = GradleImport.computeRelativePath(srcJava.getCanonicalFile(), source);
                        }
                        if (relative != null) {
                            File destAidl = new File(aidlDir, relative.getPath());
                            ImportModule.this.myImporter.mkdirs(destAidl.getParentFile());
                            ImportModule.this.myImporter.copyTextFile(ImportModule.this, source, destAidl);
                            ImportModule.this.myImporter.getSummary().reportMoved(ImportModule.this, source, destAidl);
                            return true;
                        }
                    } else if (sourcePath.endsWith(".rs") || sourcePath.endsWith(".rsh") || sourcePath.endsWith(".fs")) {
                        File destRs = new File(main, "rs" + File.separator + source.getName());
                        ImportModule.this.myImporter.mkdirs(destRs.getParentFile());
                        ImportModule.this.myImporter.copyTextFile(ImportModule.this, source, destRs);
                        ImportModule.this.myImporter.getSummary().reportMoved(ImportModule.this, source, destRs);
                        return true;
                    }
                    return false;
                }
            }, true, this);
            summary.reportMoved(this, srcJava, destJava);
            ImportModule.recordCopiedFile(copied, srcJava);
        }
        for (File jar : this.getJarPaths()) {
            File srcJar = this.resolveFile(jar);
            File destJar = new File(destDir, this.getJarOutputRelativePath(jar).getPath());
            if (destJar.getParentFile() != null) {
                this.myImporter.mkdirs(destJar.getParentFile());
            }
            Files.copy((File)srcJar, (File)destJar);
            summary.reportMoved(this, srcJar, destJar);
            ImportModule.recordCopiedFile(copied, srcJar);
        }
        for (File lib : this.getNativeLibs()) {
            File srcLib = this.resolveFile(lib);
            String abi = lib.getParentFile().getName();
            File destLib = new File(destDir, "src" + File.separator + "main" + File.separator + "jniLibs" + File.separator + abi + File.separator + lib.getName());
            if (destLib.getParentFile() != null) {
                this.myImporter.mkdirs(destLib.getParentFile());
            }
            Files.copy((File)srcLib, (File)destLib);
            summary.reportMoved(this, srcLib, destLib);
            ImportModule.recordCopiedFile(copied, srcLib);
        }
        File jni = this.getNativeSources();
        if (jni != null) {
            File srcJni = this.resolveFile(jni);
            File destJni = new File(destDir, "src" + File.separator + "main" + File.separator + "jni");
            this.myImporter.copyDir(srcJni, destJni, null, true, this);
            summary.reportMoved(this, srcJni, destJni);
            ImportModule.recordCopiedFile(copied, srcJni);
        }
        if ((instrumentation = this.getInstrumentationDir()) != null) {
            File srcJava;
            File test = new File(destDir, "src" + File.separator + "androidTest");
            this.myImporter.mkdirs(test);
            ImportModule.recordCopiedFile(copied, new File(instrumentation, "AndroidManifest.xml"));
            File srcRes = new File(instrumentation, "res");
            if (srcRes.isDirectory()) {
                File destRes = new File(test, "res");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcRes, destRes, null, true, this);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcJava = new File(instrumentation, "src")).isDirectory()) {
                File destRes = new File(test, "java");
                this.myImporter.mkdirs(destRes);
                this.myImporter.copyDir(srcJava, destRes, null, true, this);
                summary.reportMoved(this, srcJava, destRes);
                ImportModule.recordCopiedFile(copied, srcJava);
            }
            for (File jar : this.getTestJarPaths()) {
                File srcJar = this.resolveFile(jar);
                File destJar = new File(destDir, ImportModule.getTestJarOutputRelativePath(jar).getPath());
                if (destJar.exists()) continue;
                if (destJar.getParentFile() != null) {
                    this.myImporter.mkdirs(destJar.getParentFile());
                }
                Files.copy((File)srcJar, (File)destJar);
                summary.reportMoved(this, srcJar, destJar);
                ImportModule.recordCopiedFile(copied, srcJar);
            }
        }
        if (this.isAndroidProject()) {
            for (File srcProguard : this.getLocalProguardFiles()) {
                File destProguard = new File(destDir, srcProguard.getName());
                if (!destProguard.exists()) {
                    this.myImporter.copyTextFile(this, srcProguard, destProguard);
                    summary.reportMoved(this, srcProguard, destProguard);
                    ImportModule.recordCopiedFile(copied, srcProguard);
                    continue;
                }
                this.myImporter.reportWarning(this, destProguard, "Local proguard config file name is not unique");
            }
        }
        this.reportIgnored(copied);
    }

    private static boolean hasUpperCaseExtension(@NonNull File file) {
        String path = file.getPath();
        int index = path.lastIndexOf(File.separatorChar);
        if ((index = path.indexOf(46, index + 1)) == -1) {
            return false;
        }
        ++index;
        while (index < path.length()) {
            if (Character.isUpperCase(path.charAt(index))) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void reportIgnored(Set<File> copied) throws IOException {
        File canonicalDir = this.getCanonicalModuleDir();
        File outputDir = this.getOutputDir();
        if (outputDir != null) {
            copied.add(this.resolveFile(outputDir).getCanonicalFile());
        }
        copied.add(new File(canonicalDir, "bin"));
        copied.add(new File(canonicalDir, "gen"));
        copied.add(new File(canonicalDir, ".classpath"));
        copied.add(new File(canonicalDir, ".project"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "local.properties"));
        copied.add(new File(canonicalDir, "libs"));
        copied.add(new File(canonicalDir, ".settings"));
        copied.add(new File(canonicalDir, ".cproject"));
        if (this.isNdkProject()) {
            copied.add(new File(canonicalDir, "obj"));
        }
        this.reportIgnored(canonicalDir, copied, 0);
    }

    private boolean reportIgnored(@NonNull File file, @NonNull Set<File> copied, int depth) throws IOException {
        if (depth > 0 && copied.contains(file)) {
            return true;
        }
        boolean ignore = true;
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (depth == 1 && GradleImport.isIgnoredFile(file)) {
                return false;
            }
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    ignore &= this.reportIgnored(child, copied, depth + 1);
                }
            }
        } else {
            ignore = false;
        }
        if (depth > 0 && !ignore) {
            File relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file);
            if (relative == null) {
                relative = file;
            }
            String path = relative.getPath();
            if (isDirectory) {
                path = path + File.separator;
            }
            this.myImporter.getSummary().reportIgnored(this.getOriginalName(), path);
        }
        return ignore;
    }

    public List<File> getJarDependencies() {
        return this.myJarDependencies;
    }

    public List<GradleCoordinate> getDependencies() {
        return this.myDependencies;
    }

    public List<File> getTestJarDependencies() {
        return this.myTestJarDependencies;
    }

    public List<GradleCoordinate> getTestDependencies() {
        return this.myTestDependencies;
    }

    @Nullable
    public File computeProjectRelativePath(@NonNull File file) throws IOException {
        return GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file);
    }

    protected abstract boolean dependsOn(@NonNull ImportModule var1);

    protected abstract boolean dependsOnLibrary(@NonNull String var1);

    void removeJarDependencies() {
        ListIterator<File> iterator = this.getJarPaths().listIterator();
        while (iterator.hasNext()) {
            File jar = iterator.next();
            if (this.myImporter.isJarHandled(jar)) {
                iterator.remove();
                continue;
            }
            String pkg = jar.getName();
            if (pkg.endsWith(".jar")) {
                pkg = pkg.substring(0, pkg.length() - ".jar".length());
            }
            if (!this.dependsOnLibrary(pkg = pkg.replace('-', '.'))) continue;
            iterator.remove();
        }
    }

    @Override
    public int compareTo(@NonNull ImportModule other) {
        if (this.dependsOn(other)) {
            return 1;
        }
        if (other.dependsOn(this)) {
            return -1;
        }
        return this.getOriginalName().compareTo(other.getOriginalName());
    }
}

