/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.messages.AbstractNavigatable;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.structure.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ProjectSyncMessages {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    @NotNull
    public static ProjectSyncMessages getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        ProjectSyncMessages projectSyncMessages = (ProjectSyncMessages)ServiceManager.getService((Project)project, ProjectSyncMessages.class);
        if (projectSyncMessages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        return projectSyncMessages;
    }

    public int getErrorCount() {
        return this.myNotificationManager.getMessageCount(null, NotificationSource.PROJECT_SYNC, NotificationCategory.ERROR, GradleConstants.SYSTEM_ID);
    }

    public ProjectSyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public void removeMessages(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "removeMessages"));
        }
        this.myNotificationManager.clearNotifications(groupName, NotificationSource.PROJECT_SYNC, GradleConstants.SYSTEM_ID);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getMessageCount"));
        }
        return this.myNotificationManager.getMessageCount(groupName, NotificationSource.PROJECT_SYNC, null, GradleConstants.SYSTEM_ID);
    }

    public void add(@NotNull Message message, NotificationHyperlink ... hyperlinks) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        Navigatable navigatable = message.getNavigatable();
        String title = message.getGroupName();
        String errorMsg = StringUtil.join((String[])message.getText(), (String)"\n");
        VirtualFile file = message.getFile();
        String filePath = file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : null;
        NotificationData notification = new NotificationData(title, errorMsg, NotificationCategory.convert((int)message.getType().getValue()), NotificationSource.PROJECT_SYNC, filePath, message.getLine(), message.getColumn(), false);
        notification.setNavigatable(navigatable);
        if (hyperlinks.length > 0) {
            AbstractSyncErrorHandler.updateNotification(notification, this.myProject, title, errorMsg, hyperlinks);
        }
        this.myNotificationManager.showNotification(GradleConstants.SYSTEM_ID, notification);
    }

    public boolean isEmpty() {
        return this.myNotificationManager.getMessageCount(NotificationSource.PROJECT_SYNC, null, GradleConstants.SYSTEM_ID) == 0;
    }

    public void reportUnresolvedDependencies(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolvedDependencies", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        VirtualFile buildFile = null;
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleProject() != null) {
            IdeaGradleProject gradleProject = gradleFacet.getGradleProject();
            buildFile = gradleProject.getBuildFile();
        }
        for (String dep : unresolvedDependencies) {
            GradleCoordinate coordinate;
            Message msg;
            File repository;
            String group;
            ArrayList hyperlinks = Lists.newArrayList();
            File androidHome = ProjectSyncMessages.getAndroidHome(module);
            if (dep.startsWith("com.android.support")) {
                group = "Unresolved Android dependencies";
                repository = SdkMavenRepository.ANDROID.getRepositoryLocation(androidHome, true);
                if (repository == null || !repository.isDirectory()) {
                    hyperlinks.add(InstallRepositoryHyperlink.installAndroidRepository());
                }
            } else if (dep.startsWith("com.google.android.gms")) {
                group = "Unresolved Android dependencies";
                repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(androidHome, true);
                if (repository == null || !repository.isDirectory()) {
                    hyperlinks.add(InstallRepositoryHyperlink.installGoogleRepository());
                }
            } else {
                group = "Unresolved dependencies";
            }
            String text = "Failed to find: " + dep;
            if (buildFile != null) {
                msg = new Message(module.getProject(), group, Message.Type.ERROR, buildFile, -1, -1, text);
                hyperlinks.add(new OpenFileHyperlink(buildFile.getPath()));
            } else {
                msg = new Message(group, Message.Type.ERROR, AbstractNavigatable.NOT_NAVIGATABLE, text);
            }
            if (AndroidStudioSpecificInitializer.isAndroidStudio() && (coordinate = GradleCoordinate.parseCoordinateString((String)dep)) != null) {
                hyperlinks.add(new OpenDependencyInProjectStructureHyperlink(module, coordinate));
            }
            this.add(msg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
        }
        if (!unresolvedDependencies.isEmpty()) {
            this.myProject.putUserData(Projects.HAS_UNRESOLVED_DEPENDENCIES, (Object)true);
        }
    }

    @Nullable
    private static File getAndroidHome(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getAndroidHome"));
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return DefaultSdks.getDefaultAndroidHome();
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getHomePath() != null) {
            return new File(FileUtil.toSystemDependentName((String)sdk.getHomePath()));
        }
        return null;
    }

    private static class InstallRepositoryHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final IdDisplay myIdDisplay;
        @NotNull
        private final String myPath;
        @NotNull
        private final String myDisplayName;

        @NotNull
        static InstallRepositoryHyperlink installAndroidRepository() {
            InstallRepositoryHyperlink installRepositoryHyperlink = new InstallRepositoryHyperlink(new IdDisplay("android", "Android"), "m2repository", "Android Support Repository");
            if (installRepositoryHyperlink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "installAndroidRepository"));
            }
            return installRepositoryHyperlink;
        }

        @NotNull
        static InstallRepositoryHyperlink installGoogleRepository() {
            InstallRepositoryHyperlink installRepositoryHyperlink = new InstallRepositoryHyperlink(new IdDisplay("google", "Google"), "m2repository", "Google Support Repository");
            if (installRepositoryHyperlink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "installGoogleRepository"));
            }
            return installRepositoryHyperlink;
        }

        InstallRepositoryHyperlink(@NotNull IdDisplay idDisplay, @NotNull String path, @NotNull String displayName) {
            if (idDisplay == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idDisplay", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "<init>"));
            }
            if (displayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "<init>"));
            }
            super("install.m2.repo", "Install Repository and sync project");
            this.myIdDisplay = idDisplay;
            this.myPath = path;
            this.myDisplayName = displayName;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            requested.add(PkgDesc.Builder.newExtra((IdDisplay)this.myIdDisplay, (String)this.myPath, (String)this.myDisplayName, null, (NoPreviewRevision)new NoPreviewRevision(1)).create());
            SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
            wizard.init();
            wizard.setTitle("Install Missing Components");
            if (wizard.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }

    private static class OpenDependencyInProjectStructureHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Module myModule;
        @NotNull
        private final GradleCoordinate myDependency;

        OpenDependencyInProjectStructureHyperlink(@NotNull Module module, @NotNull GradleCoordinate dependency) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$OpenDependencyInProjectStructureHyperlink", "<init>"));
            }
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$OpenDependencyInProjectStructureHyperlink", "<init>"));
            }
            super("open.dependency.in.project.structure", "Open in Project Structure dialog");
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$OpenDependencyInProjectStructureHyperlink", "execute"));
            }
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openAndSelectDependency(this.myModule, this.myDependency);
            }
        }
    }
}

