/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.repository.FullRevision;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GradleModelVersionCheck {
    private static final Logger LOG = Logger.getInstance(GradleModelVersionCheck.class);
    static final FullRevision MINIMUM_SUPPORTED_VERSION = FullRevision.parseRevision((String)"0.14.0");

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/GradleModelVersionCheck", "isSupportedVersion"));
        }
        return GradleModelVersionCheck.isSupportedVersion(androidProject, MINIMUM_SUPPORTED_VERSION);
    }

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject, @NotNull FullRevision minimumSupportedVersion) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/GradleModelVersionCheck", "isSupportedVersion"));
        }
        if (minimumSupportedVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSupportedVersion", "com/android/tools/idea/gradle/project/GradleModelVersionCheck", "isSupportedVersion"));
        }
        FullRevision version = GradleModelVersionCheck.getModelVersion(androidProject);
        if (version != null) {
            return version.compareTo(minimumSupportedVersion) >= 0;
        }
        return false;
    }

    @Nullable
    static FullRevision getModelVersion(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/GradleModelVersionCheck", "getModelVersion"));
        }
        String modelVersion = androidProject.getModelVersion();
        if (Strings.isNullOrEmpty((String)modelVersion)) {
            return null;
        }
        int snapshotIndex = modelVersion.indexOf("-");
        if (snapshotIndex != -1) {
            modelVersion = modelVersion.substring(0, snapshotIndex);
        }
        try {
            return FullRevision.parseRevision((String)modelVersion);
        }
        catch (NumberFormatException e) {
            LOG.info(String.format("Unable to parse Gradle model version '%1$s'", modelVersion), (Throwable)e);
            return null;
        }
    }

    private GradleModelVersionCheck() {
    }
}

