/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.psi.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMethodConflictResolver
implements PsiConflictResolver {
    @Nullable
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/android/tools/idea/psi/resolve/AndroidMethodConflictResolver", "resolveConflict"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        ProjectFileIndex index = null;
        for (CandidateInfo conflict : conflicts) {
            PsiElement element = conflict.getElement();
            if (element == null) continue;
            index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            break;
        }
        if (index == null) {
            return null;
        }
        CandidateInfo sourceInfo = null;
        Sdk sdk = null;
        for (CandidateInfo conflict : conflicts) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiElement element = conflict.getElement();
            if (element == null || (psiFile = element.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            List orderEntries = index.getOrderEntriesForFile(virtualFile);
            if (orderEntries.size() != 1) {
                return null;
            }
            OrderEntry orderEntry = (OrderEntry)orderEntries.get(0);
            if (!(orderEntry instanceof JdkOrderEntry)) {
                return null;
            }
            Sdk currentSdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (!AndroidSdkUtils.isAndroidSdk(currentSdk) || sdk != null && !sdk.equals(currentSdk)) {
                return null;
            }
            sdk = currentSdk;
            if (!index.isInLibrarySource(virtualFile)) continue;
            if (sourceInfo == null) {
                sourceInfo = conflict;
                continue;
            }
            return null;
        }
        return sourceInfo;
    }
}

