/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.KeyString;

public class Counter
extends KeyString
implements Comparable<Counter> {
    private final int myCount;

    Counter(String key, int count) {
        super(key, null);
        this.myCount = count;
    }

    @Override
    public String getValue() {
        return Integer.toString(this.myCount);
    }

    @Override
    public int compareTo(Counter rhs) {
        int v = this.getKey().compareTo(rhs.getKey());
        if (v == 0) {
            v = this.myCount - rhs.myCount;
        }
        return v;
    }

    @Override
    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return false;
        }
        Counter counter = (Counter)rhs;
        if (this.myCount != counter.myCount) {
            return false;
        }
        return this.getKey().equals(counter.getKey());
    }

    @Override
    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.myCount;
        return result;
    }

    @Override
    public String toString() {
        return "Counter{myKey='" + this.getKey() + '\'' + ", myCount=" + this.myCount + '}';
    }
}

