/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.PreinstallOperation;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.welcome.WizardException;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class DownloadOperation
extends PreinstallOperation<File> {
    private final String myUrl;

    public DownloadOperation(InstallContext context, String url, double progressShare) {
        super(context, progressShare);
        this.myUrl = url;
    }

    @Override
    @Nullable
    protected File perform() throws WizardException {
        DownloadableFileService fileService = DownloadableFileService.getInstance();
        DownloadableFileDescription myDescription = fileService.createFileDescription(this.myUrl, "components.zip");
        FileDownloader downloader = fileService.createDownloader((List)ImmutableList.of((Object)myDescription), "Android Studio components");
        while (true) {
            try {
                List result = downloader.download(this.myContext.getTempDirectory());
                return result.size() == 1 ? (File)((Pair)result.get(0)).getFirst() : null;
            }
            catch (IOException e) {
                String details = StringUtil.isEmpty((String)e.getMessage()) ? "." : ": " + e.getMessage();
                String message = WelcomeUIUtils.getMessageWithDetails("Unable to download Android Studio components", details);
                this.promptToRetry(message + " Please check your Internet connection and retry.", message, e);
                continue;
            }
            break;
        }
    }
}

