/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.welcome.Haxm;
import com.google.common.collect.Iterables;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class FirstRunWizardDefaults {
    public static final String HAXM_DOCUMENTATION_URL = "http://www.intel.com/software/android/";

    private FirstRunWizardDefaults() {
    }

    public static int getRecommendedHaxmMemory(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > 4L * GB ? 2L * GB : (memorySize > 2L * GB ? GB : GB / 2L);
        return (int)(defaultMemory / Haxm.UI_UNITS.getNumberOfBytes());
    }

    @NotNull
    public static String getSdkDownloadUrl() {
        String downloadUrl;
        String url = System.getProperty("android.sdkurl");
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            File file = new File(url);
            if (file.isFile()) {
                String string = "file://" + PathUtil.toSystemIndependentName((String)file.getAbsolutePath());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getSdkDownloadUrl"));
                }
                return string;
            }
            System.err.println("File " + file.getAbsolutePath() + " does not exist.");
        }
        if ((downloadUrl = AndroidSdkUtils.getSdkDownloadUrl()) == null) {
            throw new IllegalStateException("Unsupported OS");
        }
        String string = downloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getSdkDownloadUrl"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultSdkLocation() {
        List<Sdk> sdks = AndroidSdkUtils.getAllAndroidSdks();
        Sdk sdk = (Sdk)Iterables.getFirst(sdks, null);
        if (sdk != null && !StringUtil.isEmptyOrSpaces((String)sdk.getHomePath())) {
            String string = sdk.getHomePath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getDefaultSdkLocation"));
            }
            return string;
        }
        String userHome = System.getProperty("user.home");
        if (SystemInfo.isWindows) {
            String string = FileUtil.join((String[])new String[]{userHome, "AppData", "Local", "Android", "Sdk"});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getDefaultSdkLocation"));
            }
            return string;
        }
        if (SystemInfo.isLinux || SystemInfo.isMac) {
            String string = FileUtil.join((String[])new String[]{userHome, "Android", "Sdk"});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/FirstRunWizardDefaults", "getDefaultSdkLocation"));
            }
            return string;
        }
        throw new IllegalStateException("Unsupported OS");
    }
}

