/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.prefs.AndroidLocation;
import com.android.tools.idea.welcome.JdkLocationStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardUtils;
import com.google.common.base.Objects;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallerData {
    static final ScopedStateStore.Key<InstallerData> CONTEXT_KEY = ScopedStateStore.createKey("installer.handoff.data", ScopedStateStore.Scope.WIZARD, InstallerData.class);
    public static final String PATH_FIRST_RUN_PROPERTIES = FileUtil.join((String[])new String[]{"studio", "installer", "firstrun.properties"});
    @Nullable
    private final String myJavaDir;
    @Nullable
    private final String myAndroidSrc;
    @Nullable
    private final String myAndroidDest;

    InstallerData(@Nullable String javaDir, @Nullable String androidSrc, @Nullable String androidDest) {
        this.myJavaDir = javaDir;
        this.myAndroidSrc = androidSrc;
        this.myAndroidDest = androidDest;
    }

    private static InstallerData parse() {
        Properties properties = InstallerData.readProperties();
        return new InstallerData(InstallerData.getIfExists(properties, "jdk.dir"), InstallerData.getIfExists(properties, "androidsdk.repo"), properties.getProperty("androidsdk.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperties() {
        Properties properties;
        block6: {
            properties = new Properties();
            try {
                File file = new File(AndroidLocation.getFolder(), PATH_FIRST_RUN_PROPERTIES);
                if (!file.isFile()) break block6;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(file);
                    properties.load(stream);
                }
                catch (IOException e) {
                    try {
                        Logger.getInstance(InstallerData.class).error((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(stream);
                        throw throwable;
                    }
                    Closeables.closeQuietly((InputStream)stream);
                    break block6;
                }
                Closeables.closeQuietly((InputStream)stream);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                Logger.getInstance(InstallerData.class).error((Throwable)e);
            }
        }
        return properties;
    }

    @Nullable
    private static String getIfExists(Properties properties, String propertyName) {
        String path = properties.getProperty(propertyName);
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            File file = new File(path);
            return file.isDirectory() ? file.getAbsolutePath() : null;
        }
        return null;
    }

    @NotNull
    public static synchronized InstallerData get(ScopedStateStore state) {
        InstallerData installerData = state.get(CONTEXT_KEY);
        if (installerData == null) {
            installerData = InstallerData.parse();
            state.put(CONTEXT_KEY, installerData);
        }
        InstallerData installerData2 = installerData;
        if (installerData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/InstallerData", "get"));
        }
        return installerData2;
    }

    @Nullable
    public String getJavaDir() {
        return this.myJavaDir;
    }

    @Nullable
    public String getAndroidSrc() {
        return this.myAndroidSrc;
    }

    @Nullable
    public String getAndroidDest() {
        return this.myAndroidDest;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("jdk.dir", (Object)this.myJavaDir).add("androidsdk.repo", (Object)this.myAndroidSrc).add("androidsdk.dir", (Object)this.myAndroidDest).toString();
    }

    public boolean exists() {
        return this.myJavaDir != null || this.myAndroidSrc != null || this.myAndroidDest != null;
    }

    public boolean hasValidSdkLocation() {
        return this.exists() && !WizardUtils.validateLocation(this.getAndroidDest(), "SDK location", false).isError();
    }

    public boolean hasValidJdkLocation() {
        return this.exists() && JdkLocationStep.validateJdkLocation(this.getJavaDir()) == null;
    }
}

